/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileUpdateListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static JavaFileUpdateListener instance = null;
    private List<IFile> filesList = null;

    public static JavaFileUpdateListener getInstance() {
        if (instance == null) {
            instance = new JavaFileUpdateListener();
        }
        return instance;
    }

    public void setFiles(List<IFile> filesList) {
        this.filesList = filesList;
    }

    public boolean areFilesCreated() {
        return this.filesList == null || this.filesList.size() == 0;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (this.filesList == null) {
            return false;
        }
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                int i = 0;
                while (i < this.filesList.size()) {
                    if (this.filesList.get(i).getProject().equals((Object)resource)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 2: {
                int i = 0;
                while (i < this.filesList.size()) {
                    IContainer container = this.filesList.get(i).getParent();
                    while (container != null && container.getType() == 2) {
                        if (resource.equals((Object)container)) {
                            return true;
                        }
                        container = container.getParent();
                    }
                    ++i;
                }
                return false;
            }
            case 1: {
                if (this.filesList.contains(resource)) {
                    this.filesList.remove(resource);
                    if (this.filesList.isEmpty()) {
                        this.filesList = null;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

