/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;

public class ProjectDependencyTests
extends AbstractTests {
    private ProjectDependencyTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project Dependency Tests");
        suite.addTest((Test)new ProjectDependencyTests("testEARWebDependency"));
        suite.addTest((Test)new ProjectDependencyTests("testEARDependencyRemoval"));
        suite.addTest((Test)new ProjectDependencyTests("testEARUtilDependency"));
        suite.addTest((Test)new ProjectDependencyTests("testEAREJBDependency"));
        suite.addTest((Test)new ProjectDependencyTests("testStandaloneWebUtilDependency"));
        suite.addTest((Test)new ProjectDependencyTests("testWebUtilWebInfLibDependency"));
        suite.addTest((Test)new ProjectDependencyTests("testWebEJBModuleDependency"));
        return suite;
    }

    public void testEARWebDependency() throws Exception {
        this.testEARDependency(ProjectUtil.createEARProject("TestEAR"), ProjectUtil.createWebProject("TestWeb", null), true);
    }

    public void testEARDependencyRemoval() throws Exception {
        IProject earProject = ProjectUtil.createEARProject("TestEAR");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", null);
        String moduleURI = this.testEARDependency(earProject, webProject, true);
        DependencyCreationUtil.removeEARDependency(earProject, webProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, webProject, moduleURI);
    }

    public void testEARUtilDependency() throws Exception {
        this.testEARDependency(ProjectUtil.createEARProject("TestEAR"), ProjectUtil.createUtilityProject("TestUtil", null), false);
    }

    public void testEAREJBDependency() throws Exception {
        this.testEARDependency(ProjectUtil.createEARProject("TestEAR"), ProjectUtil.createEJBProject("TestEJB", null), true);
    }

    private String testEARDependency(IProject earProject, IProject childProject, boolean moduleRef) throws Exception {
        DependencyCreationUtil.createEARDependency(earProject, childProject);
        return DependencyVerificationUtil.verifyEARDependency(earProject, childProject, moduleRef);
    }

    public void testStandaloneWebUtilDependency() throws Exception {
        IProject saWeb = ProjectUtil.createWebProject("TestWeb", null);
        IProject util = ProjectUtil.createUtilityProject("TestUtil", null);
        DependencyCreationUtil.createWebLibDependency(saWeb, util);
        DependencyVerificationUtil.verifyWebLibDependency(saWeb, util);
    }

    public void testWebUtilWebInfLibDependency() throws Exception {
        IProject web = ProjectUtil.createWebProject("TestWeb", null);
        IProject util = ProjectUtil.createUtilityProject("TestUtil", null);
        IProject ear = ProjectUtil.createEARProject("TestEAR");
        this.testEARDependency(ear, web, true);
        this.testEARDependency(ear, util, false);
        DependencyCreationUtil.createWebLibDependency(web, util);
        DependencyVerificationUtil.verifyWebLibDependency(web, util);
    }

    public void testWebEJBModuleDependency() throws Exception {
        IProject web = ProjectUtil.createWebProject("TestWeb", null);
        IProject ejb = ProjectUtil.createEJBProject("TestEJB", null);
        IProject ear = ProjectUtil.createEARProject("TestEAR");
        this.testEARDependency(ear, web, true);
        this.testEARDependency(ear, ejb, true);
        DependencyCreationUtil.createModuleDependency(web, ejb);
        DependencyVerificationUtil.verifyModuleDependency(web, ejb);
    }
}

