/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ArchiveUtil {
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    public static final String DOT_SQLJ = ".sqlj";
    public static final String DOT_JSP = ".jsp";
    protected static boolean isRuntime = false;
    protected static boolean shouldUseTempDirectoryForRead = true;
    protected static String tempDirectoryName;
    protected static File tempDirectory;
    public static boolean INCLUDE_EMPTY_DIRECTORIES;

    static {
        INCLUDE_EMPTY_DIRECTORIES = true;
    }

    public static String classNameToJavaUri(String className) {
        return className.replace('.', '/').concat(DOT_JAVA);
    }

    public static String classNameToUri(String className) {
        return className.replace('.', '/').concat(DOT_CLASS);
    }

    public static String classUriToJavaUri(String classUri) {
        if (classUri == null || !classUri.endsWith(DOT_CLASS)) {
            return null;
        }
        String truncated = ArchiveUtil.truncateIgnoreCase(classUri, DOT_CLASS);
        StringTokenizer tok = new StringTokenizer(truncated, "$");
        return tok.nextToken().concat(DOT_JAVA);
    }

    public static String concatUri(String directoryname, String filename, char separator) {
        String uri = directoryname;
        if (!directoryname.endsWith(String.valueOf(separator)) && !filename.startsWith(String.valueOf(separator))) {
            uri = String.valueOf(uri) + separator;
        }
        return String.valueOf(uri) + filename;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            if (!(in instanceof ZipInputStream)) {
                in.close();
            }
            if (!(out instanceof ZipOutputStream)) {
                out.close();
            }
        }
    }

    public static File createTempDirectory(String baseName, File parentDirectory) throws IOException {
        File tempFile = ArchiveUtil.createTempFile(baseName, parentDirectory);
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    public static File createTempFile(String baseName) throws IOException {
        return ArchiveUtil.createTempFile(baseName, ArchiveUtil.getTempDirectory());
    }

    public static File createTempFile(String baseName, File directory) throws IOException {
        String fileName = ArchiveUtil.getFileNameTail(baseName);
        if (fileName.length() < 3) {
            fileName = "WSTMP" + fileName;
        }
        File tempFile = File.createTempFile(fileName, null, directory);
        return tempFile;
    }

    public static boolean delete(File aFile) {
        File[] files;
        if (aFile == null) {
            return true;
        }
        if (aFile.isDirectory() && (files = aFile.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (!ArchiveUtil.delete(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return aFile.delete();
    }

    public static List getWriteProtectedFiles(File aFile, List aList) {
        if (aList == null) {
            aList = new ArrayList<File>();
        }
        if (aFile.exists() && !aFile.canWrite()) {
            aList.add(aFile);
        }
        if (aFile.isDirectory()) {
            File[] files = aFile.listFiles();
            int i = 0;
            while (i < files.length) {
                ArchiveUtil.getWriteProtectedFiles(files[i], aList);
                ++i;
            }
        }
        return aList;
    }

    public static String deriveRelativeURI(String classpathEntry, Container container) {
        URI containerURI = URI.createFileURI((String)container.getURI());
        URI entryURI = URI.createFileURI((String)classpathEntry);
        URI resolvedURI = entryURI.resolve(containerURI);
        URI recoveredURI = resolvedURI.deresolve(containerURI);
        return recoveredURI.toFileString();
    }

    public static String deriveEARRelativeURI(String classpathEntry, Archive anArchive) {
        return ArchiveUtil.deriveEARRelativeURI(classpathEntry, anArchive.getURI());
    }

    public static String deriveEARRelativeURI(String classpathEntry, String archiveUri) {
        String resolvedPath;
        String workingDir;
        block6: {
            block5: {
                try {
                    String parent = ArchiveUtil.getFileNameParent(archiveUri);
                    if (parent == null || parent.equals("")) {
                        parent = ".";
                    }
                    workingDir = new File(".").getCanonicalPath();
                    resolvedPath = new File(parent, classpathEntry).getCanonicalPath();
                    if (resolvedPath.startsWith(workingDir)) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            if (!resolvedPath.equals(workingDir)) break block6;
            return null;
        }
        int start = workingDir.endsWith(File.separator) ? workingDir.length() : workingDir.length() + 1;
        return resolvedPath.substring(start, resolvedPath.length()).replace(File.separatorChar, '/');
    }

    public static String getFileNameExtension(String uri) {
        int index;
        if (uri != null && (index = uri.lastIndexOf(".")) != -1) {
            return uri.substring(index + 1);
        }
        return "";
    }

    public static String getFileNameParent(String uri) {
        if (uri == null) {
            return "";
        }
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return "";
        }
        if (lastIndex == 0) {
            return "/";
        }
        return uri.substring(0, lastIndex);
    }

    public static String getFileNameTail(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }

    public static ModuleFile getModuleFile(EObject ddObject) {
        Resource res = ddObject.eResource();
        if (res == null) {
            return null;
        }
        Archive archive = ArchiveUtil.getArchive(res);
        if (archive == null || !archive.isModuleFile()) {
            return null;
        }
        if (!(res instanceof XMLResource)) {
            return null;
        }
        XMLResource xmlRes = (XMLResource)res;
        if (xmlRes.isAlt()) {
            return ArchiveUtil.getModuleFileUsingAltDD((EARFile)archive, res);
        }
        return (ModuleFile)archive;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile ear, Resource res) {
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        Module m = ear.getDeploymentDescriptor().getModuleHavingAltDD(uri);
        if (m == null) {
            return null;
        }
        ModuleRef ref = ear.getModuleRef(m);
        if (ref == null) {
            return null;
        }
        return ref.getModuleFile();
    }

    public static String getModuleFileTypeName(int moduleType) {
        switch (moduleType) {
            case 2: {
                return CommonArchiveResourceHandler.A_Application_file;
            }
            case 1: {
                return CommonArchiveResourceHandler.An_Application_Client_JAR_file;
            }
            case 3: {
                return CommonArchiveResourceHandler.An_EJB_JAR_file;
            }
            case 4: {
                return CommonArchiveResourceHandler.A_WAR_file;
            }
            case 5: {
                return CommonArchiveResourceHandler.A_RAR_file;
            }
        }
        return null;
    }

    public static Archive getArchive(Resource res) {
        if (res == null) {
            return null;
        }
        ResourceSet set = res.getResourceSet();
        if (set == null) {
            return null;
        }
        URIConverter conv = set.getURIConverter();
        if (conv == null || !(conv instanceof ArchiveURIConverterImpl)) {
            return null;
        }
        return ((ArchiveURIConverterImpl)conv).getArchive();
    }

    public static String getOSUri(String uri) {
        char sep = File.separatorChar;
        if (sep != '/') {
            return uri.replace('/', sep);
        }
        return uri.replace('\\', sep);
    }

    public static String getOSUri(String directoryname, String filename) {
        String osDirName = ArchiveUtil.getOSUri(directoryname);
        String osFileName = ArchiveUtil.getOSUri(filename);
        return ArchiveUtil.concatUri(osDirName, osFileName, File.separatorChar);
    }

    public static EObject getRoot(Resource aResource) throws EmptyResourceException {
        EList extent = aResource.getContents();
        if (extent.size() < 1) {
            throw new EmptyResourceException(aResource.getURI().toString());
        }
        return (EObject)extent.get(0);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String aString) {
        return ArchiveUtil.getTokens(aString, null);
    }

    public static String[] getTokens(String aString, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(aString) : new StringTokenizer(aString, delimiter);
        int size = tok.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size && tok.hasMoreTokens()) {
            tokens[i] = tok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String getValueIgnoreKeyCase(String key, Attributes attr) {
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            String entryKey = entry.getKey().toString();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static void inform(String message) {
        Logger.getLogger().logInfo(message);
    }

    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArchiveUtil.copy(in, out);
        return out.toByteArray();
    }

    public static boolean isJavaResource(Resource aResource) {
        return JavaURL.isJavaURL((String)aResource.getURI().toString());
    }

    public static boolean isRegisteredURIMapping(Resource res) {
        return URIMappingRegistryImpl.INSTANCE.getURI(res.getURI()) != res.getURI();
    }

    public static boolean isPlatformMetaResource(Resource res) {
        URI uri = res.getURI();
        return "platform".equals(uri.scheme()) && "meta".equals(uri.segment(0));
    }

    public static boolean isNullOrEmpty(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static boolean isRuntime() {
        return isRuntime;
    }

    public static boolean isValidDependency(Archive referencedJAR, Archive referencingJAR) {
        if (referencedJAR.isWARFile()) {
            return false;
        }
        if (referencedJAR == referencingJAR) {
            return false;
        }
        return referencingJAR.isApplicationClientFile() || !referencedJAR.isApplicationClientFile();
    }

    public static Properties loadProperties(Archive archive, String uri) throws FileNotFoundException, IOException {
        InputStream in = null;
        try {
            in = archive.getInputStream(uri);
            Properties p = new Properties();
            p.load(in);
            Properties properties = p;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void setIsRuntime(boolean aBoolean) {
        isRuntime = aBoolean;
    }

    public static void setShouldUseTempDirectoryForRead(boolean value) {
        shouldUseTempDirectoryForRead = value;
    }

    public static void setTempDirectory(File newTempDirectory) {
        tempDirectory = newTempDirectory;
        tempDirectoryName = newTempDirectory.getAbsolutePath();
    }

    public static void setTempDirectoryName(String newTempDirectoryName) throws ArchiveException {
        File dir = new File(newTempDirectoryName);
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                throw new ArchiveException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.make_temp_dir_EXC_, new Object[]{newTempDirectoryName}));
            }
            DeleteOnExitUtility.markForDeletion(dir);
        }
        ArchiveUtil.setTempDirectory(dir);
    }

    public static boolean shouldUseTempDirectoryForRead() {
        return shouldUseTempDirectoryForRead;
    }

    public static URL[] toLocalURLs(List entries, String uriRoot) {
        ArrayList<URL> urls = new ArrayList<URL>();
        int i = 0;
        while (i < entries.size()) {
            block22: {
                String pathEntry = (String)entries.get(i);
                File aFile = new File(pathEntry);
                if (!aFile.isAbsolute()) {
                    pathEntry = ArchiveUtil.getOSUri(uriRoot, pathEntry);
                    aFile = new File(pathEntry);
                }
                if (aFile.exists()) {
                    if (aFile.isDirectory()) {
                        if (!pathEntry.endsWith(File.separator)) {
                            pathEntry = String.valueOf(pathEntry) + File.separatorChar;
                        }
                    } else {
                        ZipFile zip = null;
                        try {
                            try {
                                zip = org.eclipse.jst.jee.archive.internal.ArchiveUtil.newZipFile(aFile);
                            }
                            catch (Exception exception) {
                                ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_classpath_WARN_, new Object[]{pathEntry}));
                                if (zip != null) {
                                    try {
                                        zip.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (zip != null) {
                                try {
                                    zip.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        aFile = new File(pathEntry);
                        URL aUrl = aFile.toURL();
                        urls.add(aUrl);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_cp_file_WARN_, new Object[]{pathEntry}));
                    }
                }
            }
            ++i;
        }
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    public static String truncateFromFrontIgnoreCase(String aString, String leadingSubString) {
        if (!aString.toLowerCase().startsWith(leadingSubString.toLowerCase())) {
            return aString;
        }
        return aString.substring(leadingSubString.length(), aString.length());
    }

    public static String truncateIgnoreCase(String aString, String trailingSubString) {
        int index = aString.toLowerCase().lastIndexOf(trailingSubString.toLowerCase());
        if (index != -1) {
            return aString.substring(0, index);
        }
        return aString;
    }

    public static String uriToClassName(String uri) {
        return ArchiveUtil.truncateIgnoreCase(uri.replace('/', '.'), DOT_CLASS);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        block17: {
            if (moduleFile == null) {
                return false;
            }
            if (moduleFile.isRARFile()) {
                return true;
            }
            in = null;
            uri = moduleFile.getDeploymentDescriptorUri();
            in = moduleFile.getInputStream(uri);
            docType = XmlDocumentReader.readDocumentType(in, uri);
            if (docType != null) break block17;
lbl11:
            // 3 sources

            while (true) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException v0) {}
                return false;
            }
        }
        ids = ArchiveUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
        if (ids == null) ** GOTO lbl11
        var6_5 = ids[0].equals(docType.getPublicId()) != false && ids[1].equals(docType.getSystemId()) != false;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException v1) {}
        return var6_5;
        catch (IOException v2) {
            try {
                ** continue;
            }
            catch (Throwable var5_6) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException v3) {}
                throw var5_6;
            }
        }
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static int getFastSpecVersion(ModuleFile moduleFile) {
        InputStream in = null;
        String uri = moduleFile.getDeploymentDescriptorUri();
        in = moduleFile.getInputStream(uri);
        DocumentType docType = null;
        InputSource source = new InputSource(in);
        XmlDocumentReader aReader = new XmlDocumentReader(source);
        aReader.setValidate(false);
        Document aDocument = aReader.parseDocument();
        if (aDocument != null) {
            docType = aDocument.getDoctype();
        }
        int version = -1;
        if (docType != null) {
            String publicID = docType.getPublicId();
            String systemID = docType.getSystemId();
            if (publicID != null && systemID != null) {
                version = ArchiveUtil.lookupVersion(moduleFile, publicID, systemID);
            }
        }
        if (version == -1) {
            NamedNodeMap map;
            String schemaName = null;
            String versionString = null;
            if (aDocument != null && docType == null && (map = aDocument.getDocumentElement().getAttributes()) != null) {
                Node versionNode;
                Node schemaNode = map.getNamedItem("xsi:schemaLocation");
                if (schemaNode != null) {
                    schemaName = schemaNode.getNodeValue();
                }
                if ((versionNode = map.getNamedItem("version")) != null) {
                    versionString = versionNode.getNodeValue();
                }
            }
            if (schemaName != null) {
                version = ArchiveUtil.lookupVersion(moduleFile, schemaName);
            }
            if (version == -1) {
                version = ArchiveUtil.parseVersionString(moduleFile, versionString);
            }
        }
        int n = version;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        return n;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException3) {}
            return -1;
        }
    }

    private static int parseVersionString(ModuleFile moduleFile, String versionAttr) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            version = versionAttr == null ? 14 : (versionAttr.equals("1.2") ? 12 : (versionAttr.equals("1.3") ? 13 : 14));
        } else if (moduleFile.isEJBJarFile()) {
            version = versionAttr == null ? 21 : (versionAttr.equals("1.1") ? 11 : (versionAttr.equals("2.0") ? 20 : 21));
        } else if (moduleFile.isApplicationClientFile()) {
            version = versionAttr == null ? 14 : (versionAttr.equals("1.2") ? 12 : (versionAttr.equals("1.3") ? 13 : 14));
        } else if (moduleFile.isWARFile()) {
            version = versionAttr == null ? 24 : (versionAttr.equals("2.2") ? 22 : (versionAttr.equals("2.3") ? 23 : 24));
        } else if (moduleFile.isRARFile()) {
            version = versionAttr == null ? 15 : (versionAttr.equals("1.0") ? 10 : 15);
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String schemaName) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                version = 21;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isWARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                version = 24;
            }
        } else if (moduleFile.isRARFile() && schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            version = 15;
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String publicID, String systemID) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd")) ? 12 : 14);
        } else if (moduleFile.isEJBJarFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (systemID.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || systemID.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd")) ? 20 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd")) ? 11 : 21);
        } else if (moduleFile.isApplicationClientFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application-client_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd")) ? 12 : 14);
        } else if (moduleFile.isWARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || systemID.equals("http://java.sun.com/dtd/web-app_2.3.dtd")) ? 23 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd")) ? 22 : 24);
        } else if (moduleFile.isRARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (systemID.equals("http://java.sun.com/dtd/connector_1_0.dtd") || systemID.equals("http://java.sun.com/dtd/connector_1.0.dtd")) ? 10 : 15;
        }
        return version;
    }
}

