/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDPrinter;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDUtil;

public class DTDResourceImpl
extends ResourceImpl {
    private DTDUtil dtdUtil;

    public DTDResourceImpl() {
    }

    public DTDResourceImpl(String filename) {
        super(URI.createURI((String)filename));
    }

    public DTDResourceImpl(URI uri) {
        super(uri);
    }

    public EObject getEObject(String uriFragment) {
        EList contents = this.getContents();
        if (contents != null) {
            Iterator i = contents.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof DTDFile)) continue;
                DTDObject result = ((DTDFile)obj).findObject(uriFragment);
                return result;
            }
        }
        System.out.println(">>> DTDKey Error: cannot find object " + uriFragment);
        return super.getEObject(uriFragment);
    }

    public String getURIFragment(EObject eObject) {
        if (eObject instanceof DTDObject) {
            return ((DTDObject)eObject).getPathname();
        }
        return super.getURIFragment(eObject);
    }

    public DTDUtil getDTDUtil() {
        return this.dtdUtil;
    }

    public void setDTDUtil(DTDUtil dtdUtil) {
        this.dtdUtil = dtdUtil;
    }

    public void load(Map options) {
        String uriString = this.getURI().toString();
        try {
            DTDUtil dtdUtil = new DTDUtil();
            dtdUtil.parse(this.getResourceSet(), uriString);
            dtdUtil.setResource((Resource)this);
            this.setDTDUtil(dtdUtil);
            this.getContents().add((Object)dtdUtil.getDTDFile());
            this.setModified(false);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void save(OutputStream os, Object options) throws Exception {
        if (this.contents != null) {
            Iterator i = this.contents.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof DTDFile)) continue;
                try {
                    DTDPrinter printer = new DTDPrinter(true);
                    printer.visitDTDFile((DTDFile)obj);
                    String s = printer.getBuffer().toString();
                    os.write(s.getBytes());
                    this.setModified(false);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    public void save(ZipOutputStream zos, String entry, String metaModelName) throws Exception {
        throw new Exception(DTDCoreMessages._EXC_OPERATION_NOT_SUPPORTED);
    }
}

