/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.strategy;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.core.set.constraint.MemberConstraint;
import org.eclipse.jst.jsf.core.set.mapping.ElementToTagIdentifierMapping;
import org.eclipse.jst.jsf.core.tagmatcher.EvaluationException;
import org.eclipse.jst.jsf.core.tagmatcher.InvalidExpressionException;
import org.eclipse.jst.jsf.core.tagmatcher.XPathMatchingAlgorithm;
import org.eclipse.jst.jsf.validation.internal.AbstractXMLViewValidationStrategy;
import org.eclipse.jst.jsf.validation.internal.JSFValidationContext;
import org.eclipse.jst.jsf.validation.internal.constraints.ContainsTagConstraint;
import org.eclipse.jst.jsf.validation.internal.constraints.TagId;
import org.eclipse.jst.jsf.validation.internal.constraints.TagSet;
import org.w3c.dom.Node;

public class ContainmentValidatingStrategy
extends AbstractXMLViewValidationStrategy {
    public static final String ID = "org.eclipse.jst.jsf.validation.strategy.ElementValidatingStrategy";
    private static final String DISPLAY_NAME = "Tag Containment Validator";
    private static final ElementToTagIdentifierMapping elem2TagIdMapper = new ElementToTagIdentifierMapping();
    private int _containmentValidationCount;
    private final JSFValidationContext _jsfValidationContext;
    private static final String MESSAGE_PATTERN = "Tag {0} is missing required parent tag \"{1}\" ({2})";

    public ContainmentValidatingStrategy(JSFValidationContext jsfValidationContext) {
        super(ID, DISPLAY_NAME);
        this._jsfValidationContext = jsfValidationContext;
    }

    public boolean isInteresting(DOMAdapter domAdapter) {
        return domAdapter instanceof Region2ElementAdapter;
    }

    public void validate(DOMAdapter domAdapter) {
        if (domAdapter instanceof Region2ElementAdapter) {
            Region2ElementAdapter elementAdapter = (Region2ElementAdapter)domAdapter;
            this.validateContainment(elementAdapter, this._jsfValidationContext);
        }
    }

    private void validateContainment(Region2ElementAdapter elementAdapter, JSFValidationContext jsfValidationContext) {
        Trait trait;
        if (JSPUtil.isJSPFragment((IFile)jsfValidationContext.getFile()) || this._containmentValidationCount > 0) {
            return;
        }
        IStructuredDocumentContext context = elementAdapter.getDocumentContext();
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node node = resolver.getNode();
        String uri = elementAdapter.getNamespace();
        String tagName = elementAdapter.getLocalName();
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)jsfValidationContext.getFile().getProject(), (String)uri);
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)modelContext, (String)tagName);
        if (entity != null && (trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"containment-constraint")) != null) {
            ContainsTagConstraint tagConstraint = (ContainsTagConstraint)trait.getValue();
            String algorithm = tagConstraint.getSetGenerator().getAlgorithm();
            if (!"xpath".equals(algorithm)) {
                return;
            }
            String expr = tagConstraint.getSetGenerator().getExpression();
            XPathMatchingAlgorithm xpathAlg = new XPathMatchingAlgorithm(expr);
            AxiomaticSet set = null;
            try {
                set = xpathAlg.evaluate(node);
                set = elem2TagIdMapper.map(set);
            }
            catch (InvalidExpressionException e) {
                JSFCorePlugin.log(e, "Problem with expression: " + expr + " on node " + node);
                return;
            }
            catch (EvaluationException e) {
                JSFCorePlugin.log(e, "Problem evaluating expression: " + expr + " on node " + node);
                return;
            }
            TagSet constraintData = tagConstraint.getSatisfiesSet();
            ConcreteAxiomaticSet constraintSet = new ConcreteAxiomaticSet();
            for (TagId tagId : constraintData.getTags()) {
                constraintSet.add((Object)TagIdentifierFactory.createJSPTagWrapper(tagId.getUri(), tagId.getName()));
            }
            MemberConstraint memberConstraint = new MemberConstraint((AxiomaticSet)constraintSet);
            Diagnostic diag = memberConstraint.isSatisfied(set);
            if (diag.getSeverity() != 0) {
                ++this._containmentValidationCount;
                List data = diag.getData();
                for (TagIdentifier missingParent : data) {
                    this.reportContainmentProblem(context, node.getNodeName(), 2, missingParent.getTagName(), missingParent.getUri());
                }
            }
        }
    }

    private void reportContainmentProblem(IStructuredDocumentContext context, String nodeName, int severity, String tagName, String uri) {
        String msg = MessageFormat.format(MESSAGE_PATTERN, nodeName, tagName, uri);
        BasicDiagnostic problem = new BasicDiagnostic(severity, "", -1, msg, null);
        int start = context.getDocumentPosition() + 1;
        int length = nodeName.length();
        this._jsfValidationContext.getReporter().report((Diagnostic)problem, start, length);
    }
}

