/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.core;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.common.internal.annotations.core.AnnotatedCommentHandler;
import org.eclipse.jst.common.internal.annotations.core.AnnotationTagParser;
import org.eclipse.jst.common.internal.annotations.core.AnnotationsAdapter;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class AnnotationsTranslator
extends Translator {
    private AnnotatedCommentHandler handler;
    private AnnotationTagParser parser;
    public static final AnnotationsTranslator INSTANCE = new AnnotationsTranslator();

    public AnnotationsTranslator() {
        super("#comment", AnnotationsAdapter.NOTIFICATION_FEATURE, 1024);
    }

    public AnnotationsTranslator(String domNameAndPath) {
        super(domNameAndPath, AnnotationsAdapter.NOTIFICATION_FEATURE, 1024);
    }

    public AnnotationsTranslator(String domNameAndPath, int style) {
        super(domNameAndPath, AnnotationsAdapter.NOTIFICATION_FEATURE, style | 0x400);
    }

    public void setMOFValue(EObject emfObject, Object value) {
        if (value == null) {
            return;
        }
        this.getHandler().getAnnotations().clear();
        this.getParser().setParserInput(value.toString());
        this.getParser().parse();
        Map annotations = this.getHandler().getAnnotations();
        Iterator keys = annotations.keySet().iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            AnnotationsAdapter.addAnnotations(emfObject, name, annotations.get(name));
        }
    }

    public boolean isSetMOFValue(EObject emfObject) {
        return this.getMOFValue(emfObject) != null;
    }

    public Object getMOFValue(EObject emfObject) {
        return AnnotationsAdapter.getAnnotations(emfObject, "generated");
    }

    public void unSetMOFValue(EObject emfObject) {
        AnnotationsAdapter.removeAnnotations(emfObject, "generated");
    }

    public boolean featureExists(EObject emfObject) {
        return true;
    }

    public boolean isDataType() {
        return true;
    }

    public boolean isMapFor(Object aFeature, Object oldValue, Object newValue) {
        return aFeature == this.feature;
    }

    protected AnnotatedCommentHandler getHandler() {
        if (this.handler == null) {
            this.handler = new AnnotatedCommentHandler();
        }
        return this.handler;
    }

    protected AnnotationTagParser getParser() {
        if (this.parser == null) {
            this.parser = new AnnotationTagParser(this.getHandler());
        }
        return this.parser;
    }
}

