/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyExtensions;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyValidatorHelper;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class ClasspathDependencyValidator
implements IValidatorJob {
    public static final String AppClientProject = "AppClientProject";
    public static final String RootMappingNonEARWARRef = "RootMappingNonEARWARRef";
    public static final String NonTaggedExportedClasses = "NonTaggedExportedClasses";
    public static final String DuplicateArchiveName = "DuplicateArchiveName";
    public static final String ProjectClasspathEntry = "ProjectClasspathEntry";
    public static final String SourceEntry = "SourceEntry";
    public static final String FilteredContainer = "FilteredContainer";
    public static final String ClassFolderEntry = "ClassFolderEntry";
    public static final String NonWebNonExported = "NonWebNonExported";
    public static final String InvalidNonWebRuntimePath = "InvalidNonWebRuntimePath";
    public static final String InvalidWebRuntimePath = "InvalidWebRuntimePath";
    protected IReporter _reporter;

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this._reporter = reporter;
        this._reporter.removeAllMessages((IValidator)this);
        HashSet<String> archiveNames = new HashSet<String>();
        IProject proj = ((ClasspathDependencyValidatorHelper)helper).getProject();
        try {
            if (proj.isAccessible() && proj.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && proj.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)proj);
                boolean isWebApp = J2EEProjectUtilities.isDynamicWebProject(proj);
                Map referencedRawEntries = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject);
                List potentialRawEntries = ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(javaProject);
                IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
                Iterator<Object> i = referencedRawEntries.keySet().iterator();
                boolean hasRootMapping = false;
                while (i.hasNext()) {
                    IClasspathEntry entry = (IClasspathEntry)i.next();
                    IClasspathAttribute attrib = (IClasspathAttribute)referencedRawEntries.get(entry);
                    IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp);
                    if (runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                        hasRootMapping = true;
                    }
                    IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, proj);
                    String cpEntryPath = entry.getPath().toString();
                    int j = 0;
                    while (j < msgs.length) {
                        msgs[j].setGroupName(cpEntryPath);
                        ++j;
                    }
                    this.reportMessages(msgs);
                    if (isWebApp || entry.isExported()) continue;
                    this._reporter.addMessage((IValidator)this, (IMessage)new Message("classpathdependencyvalidator", 2, NonWebNonExported, new String[]{cpEntryPath}, (Object)proj));
                }
                if (!referencedRawEntries.isEmpty()) {
                    if (J2EEProjectUtilities.isApplicationClientProject(proj)) {
                        Message msg = new Message("classpathdependencyvalidator", 1, AppClientProject, null, (Object)proj);
                        this._reporter.addMessage((IValidator)this, (IMessage)msg);
                    }
                    if (hasRootMapping && component != null) {
                        boolean referencedFromEARorWAR = false;
                        ArrayList<IVirtualComponent> earWarRefs = new ArrayList<IVirtualComponent>();
                        IVirtualComponent[] refComponents = component.getReferencingComponents();
                        int j = 0;
                        while (j < refComponents.length) {
                            if (J2EEProjectUtilities.isEARProject(refComponents[j].getProject()) || J2EEProjectUtilities.isDynamicWebProject(refComponents[j].getProject())) {
                                referencedFromEARorWAR = true;
                                earWarRefs.add(refComponents[j]);
                            }
                            ++j;
                        }
                        if (!referencedFromEARorWAR) {
                            Message msg = new Message("classpathdependencyvalidator", 2, RootMappingNonEARWARRef, null, (Object)proj);
                            this._reporter.addMessage((IValidator)this, (IMessage)msg);
                        }
                    }
                }
                for (IClasspathEntry entry : potentialRawEntries) {
                    Message msg = new Message("classpathdependencyvalidator", 2, NonTaggedExportedClasses, new String[]{entry.getPath().toString()}, (Object)proj);
                    msg.setGroupName(entry.getPath().toString());
                    this._reporter.addMessage((IValidator)this, (IMessage)msg);
                }
                if (!referencedRawEntries.isEmpty()) {
                    Map referencedResolvedEntries = ClasspathDependencyUtil.getComponentClasspathDependencies(javaProject, isWebApp, false);
                    for (IClasspathEntry entry : referencedResolvedEntries.keySet()) {
                        IClasspathAttribute attrib = (IClasspathAttribute)referencedResolvedEntries.get(entry);
                        String archivePath = ClasspathDependencyUtil.getArchiveName(entry);
                        if (archiveNames.contains(archivePath)) {
                            Message msg = new Message("classpathdependencyvalidator", 1, DuplicateArchiveName, new String[]{entry.getPath().toString()}, (Object)proj);
                            this._reporter.addMessage((IValidator)this, (IMessage)msg);
                        } else {
                            archiveNames.add(archivePath);
                        }
                        if (referencedRawEntries.containsKey(entry)) continue;
                        IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, proj);
                        this.reportMessages(msgs);
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void reportMessages(IMessage[] msgs) {
        int i = 0;
        while (i < msgs.length) {
            this._reporter.addMessage((IValidator)this, msgs[i]);
            ++i;
        }
    }

    public static IMessage[] validateVirtualComponentEntry(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project) {
        ArrayList<Message> results = new ArrayList<Message>();
        if (entry == null) {
            return results.toArray(new IMessage[results.size()]);
        }
        int kind = entry.getEntryKind();
        if (kind == 2) {
            results.add(new Message("classpathdependencyvalidator", 1, ProjectClasspathEntry, new String[]{entry.getPath().toString()}, (Object)project));
            return results.toArray(new IMessage[results.size()]);
        }
        if (kind == 3) {
            results.add(new Message("classpathdependencyvalidator", 1, SourceEntry, new String[]{entry.getPath().toString()}, (Object)project));
            return results.toArray(new IMessage[results.size()]);
        }
        if (kind == 5) {
            List filteredIDs = ClasspathDependencyExtensions.get().getFilteredClasspathContainerIDs();
            IPath path = entry.getPath();
            int i = 0;
            while (i < filteredIDs.size()) {
                String id = (String)filteredIDs.get(i);
                if (path.segment(0).equals(id)) {
                    results.add(new Message("classpathdependencyvalidator", 1, FilteredContainer, new String[]{entry.getPath().toString()}, (Object)project));
                    return results.toArray(new IMessage[results.size()]);
                }
                ++i;
            }
        } else if (kind == 1) {
            IPath entryPath;
            IPath entryLocation = entryPath = entry.getPath();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (resource != null) {
                entryLocation = resource.getLocation();
            }
            boolean isFile = true;
            if (entryLocation.toFile().isDirectory()) {
                isFile = false;
            }
            if (!isFile) {
                results.add(new Message("classpathdependencyvalidator", 1, ClassFolderEntry, new String[]{entry.getPath().toString()}, (Object)project));
            }
        }
        IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp);
        if (!isWebApp) {
            if (!runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                results.add(new Message("classpathdependencyvalidator", 1, InvalidNonWebRuntimePath, new String[]{entry.getPath().toString(), runtimePath.toString()}, (Object)project));
            }
        } else {
            String pathStr = runtimePath.toString();
            if (!(runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) || pathStr.equals("/WEB-INF/lib") || pathStr.equals("/WEB-INF/classes"))) {
                results.add(new Message("classpathdependencyvalidator", 1, InvalidWebRuntimePath, new String[]{entry.getPath().toString(), pathStr}, (Object)project));
            }
        }
        return results.toArray(new IMessage[results.size()]);
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public void cleanup(IReporter reporter) {
        this._reporter = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }
}

