/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class RuntimeType
implements IRuntimeType {
    private IConfigurationElement element;
    private List moduleTypes;

    public RuntimeType(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        try {
            return this.element.getAttribute("name");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDescription() {
        try {
            return this.element.getAttribute("description");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getVendor() {
        try {
            String vendor = this.element.getAttribute("vendor");
            if (vendor != null) {
                return vendor;
            }
        }
        catch (Exception exception) {}
        return Messages.defaultVendor;
    }

    public String getVersion() {
        try {
            String version = this.element.getAttribute("version");
            if (version != null) {
                return version;
            }
        }
        catch (Exception exception) {}
        return Messages.defaultVersion;
    }

    public String getFacetRuntimeComponent() {
        try {
            return this.element.getAttribute("facetRuntimeComponent");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFacetRuntimeVersion() {
        try {
            return this.element.getAttribute("facetRuntimeVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected RuntimeDelegate createRuntimeDelegate() throws CoreException {
        try {
            return (RuntimeDelegate)this.element.createExecutableExtension("class");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IModuleType[] getModuleTypes() {
        try {
            if (this.moduleTypes == null) {
                this.moduleTypes = ServerPlugin.getModuleTypes(this.element.getChildren("moduleType"));
            }
            IModuleType[] mt = new IModuleType[this.moduleTypes.size()];
            this.moduleTypes.toArray(mt);
            return mt;
        }
        catch (Exception exception) {
            return new IModuleType[0];
        }
    }

    public boolean canCreate() {
        try {
            String a = this.element.getAttribute("class");
            return a != null && a.length() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IRuntimeWorkingCopy createRuntime(String id, IProgressMonitor monitor) {
        if (this.element == null) {
            return null;
        }
        RuntimeWorkingCopy rwc = new RuntimeWorkingCopy(null, id, this);
        rwc.setDefaults(monitor);
        return rwc;
    }

    public void dispose() {
        this.element = null;
    }

    public String getNamespace() {
        if (this.element == null) {
            return null;
        }
        return this.element.getDeclaringExtension().getContributor().getName();
    }

    public String toString() {
        return "RuntimeType[" + this.getId() + ", " + this.getName() + "]";
    }
}

