/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.CloneIterator;
import org.eclipse.dali.utility.tests.TestTools;

public class CloneIteratorTests
extends TestCase {
    Collection originalCollection;
    private boolean concurrentProblem;
    private Collection concurrentCollection;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.CloneIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.CloneIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CloneIteratorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.originalCollection = this.buildCollection();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext() {
        int originalSize = this.originalCollection.size();
        int i = 0;
        Iterator stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalCollection.add("foo");
            ++i;
        }
        CloneIteratorTests.assertTrue((originalSize != this.originalCollection.size() ? 1 : 0) != 0);
        CloneIteratorTests.assertEquals((int)originalSize, (int)i);
    }

    public void testNext() {
        Iterator nestedIterator = this.originalCollection.iterator();
        Iterator stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            CloneIteratorTests.assertEquals((String)"bogus element", nestedIterator.next(), stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = this.buildCloneIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemoveDefault() {
        boolean exCaught = false;
        Iterator stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testRemoveEliminator() {
        CloneIterator.Mutator eliminator = new CloneIterator.Mutator(){

            public void remove(Object current) {
                CloneIteratorTests.this.originalCollection.remove(current);
            }
        };
        this.verifyRemove((Iterator)new CloneIterator(this.originalCollection, eliminator));
    }

    public void testRemoveSubclass() {
        this.verifyRemove((Iterator)new CloneIterator(this.originalCollection){

            protected void remove(Object current) {
                CloneIteratorTests.this.originalCollection.remove(current);
            }
        });
    }

    public void testConcurrentAccess() throws Exception {
        SlowCollection slow = new SlowCollection();
        this.populateCollection(slow);
        this.originalCollection = Collections.synchronizedCollection(slow);
        this.concurrentProblem = false;
        this.concurrentCollection = new ArrayList();
        Thread thread = new Thread(this.buildRunnable());
        thread.start();
        while (!slow.hasStartedClone()) {
            Thread.yield();
        }
        this.originalCollection.add("seventeen");
        while (thread.isAlive()) {
            Thread.yield();
        }
        CloneIteratorTests.assertFalse((boolean)this.concurrentProblem);
        ArrayList expected = new ArrayList();
        this.populateCollection(expected);
        CloneIteratorTests.assertEquals(expected, (Object)this.concurrentCollection);
    }

    private Runnable buildRunnable() {
        return new Runnable(){

            public void run() {
                CloneIteratorTests.this.loopWithCloneIterator();
            }
        };
    }

    void loopWithCloneIterator() {
        try {
            Iterator stream = this.buildCloneIterator();
            while (stream.hasNext()) {
                this.concurrentCollection.add(stream.next());
            }
        }
        catch (Throwable throwable) {
            this.concurrentProblem = true;
        }
    }

    private void verifyRemove(Iterator iterator) {
        String removed = "three";
        CloneIteratorTests.assertTrue((boolean)this.originalCollection.contains(removed));
        boolean exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        CloneIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        while (iterator.hasNext()) {
            if (!iterator.next().equals(removed)) continue;
            iterator.remove();
            exCaught = false;
            try {
                iterator.remove();
            }
            catch (IllegalStateException illegalStateException) {
                exCaught = true;
            }
            CloneIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        }
        CloneIteratorTests.assertFalse((boolean)this.originalCollection.contains(removed));
    }

    private Iterator buildCloneIterator() {
        return this.buildCloneIterator(this.originalCollection);
    }

    private Iterator buildCloneIterator(Collection c) {
        return new CloneIterator(c);
    }

    private Collection buildCollection() {
        Collection c = this.buildEmptyCollection();
        this.populateCollection(c);
        return c;
    }

    protected Collection buildEmptyCollection() {
        return new ArrayList();
    }

    private void populateCollection(Collection c) {
        c.add("one");
        c.add("two");
        c.add("three");
        c.add("four");
        c.add("five");
        c.add("six");
        c.add("seven");
        c.add("eight");
    }

    static class SlowCollection
    extends ArrayList {
        private boolean hasStartedClone = false;

        public Object[] toArray() {
            this.setHasStartedClone(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return super.toArray();
        }

        synchronized void setHasStartedClone(boolean hasStartedClone) {
            this.hasStartedClone = hasStartedClone;
        }

        synchronized boolean hasStartedClone() {
            return this.hasStartedClone;
        }
    }
}

