/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Bag;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.ReverseComparator;

public class CollectionToolsTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.CollectionToolsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.CollectionToolsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CollectionToolsTests(String name) {
        super(name);
    }

    public void testAddObjectArrayObject() {
        Object[] a = CollectionTools.add((Object[])this.buildArray1(), (Object)"twenty");
        CollectionToolsTests.assertEquals((String)"invalid size", (int)4, (int)a.length);
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
    }

    public void testAddObjectArrayObject2() {
        Object[] a = (String[])CollectionTools.add((Object[])this.buildStringArray1(), (Object)"twenty");
        CollectionToolsTests.assertEquals((String)"invalid size", (int)4, (int)a.length);
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
    }

    public void testAddObjectArrayIntObject() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.add((Object[])a, (int)2, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject2() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.add((Object[])a, (int)2, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObjectException() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        boolean exCaught = false;
        try {
            a = CollectionTools.add((Object[])a, (int)33, (Object)"X");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAddCharArrayChar() {
        char[] a = CollectionTools.add((char[])this.buildCharArray(), (char)'d');
        CollectionToolsTests.assertEquals((String)"invalid size", (int)4, (int)a.length);
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((char[])a, (char)'d'));
    }

    public void testAddCharArrayIntChar() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.add((char[])a, (int)2, (char)'X');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'c', 'd'}, a));
    }

    public void testAddIntArrayInt() {
        int[] a = CollectionTools.add((int[])this.buildIntArray(), (int)30);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)4, (int)a.length);
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((int[])a, (int)30));
    }

    public void testAddIntArrayIntInt() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.add((int[])a, (int)2, (int)99);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 3, 4}, a));
    }

    public void testAddAllCollectionIterator() {
        List l1 = this.buildList1();
        List l2 = this.buildList2();
        Set s1 = this.buildSet1();
        List l3 = this.buildList1();
        CollectionToolsTests.assertTrue((String)"invalid return value", (boolean)CollectionTools.addAll((Collection)l1, l2.iterator()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)l1.size());
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)l1.containsAll(l2));
        CollectionToolsTests.assertFalse((String)"invalid return value", (boolean)CollectionTools.addAll((Collection)s1, l3.iterator()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)s1.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)s1.containsAll(l3));
    }

    public void testAddAllCollectionObjectArray() {
        List l = this.buildList1();
        Object[] a = this.buildArray1();
        Set s = this.buildSet1();
        CollectionToolsTests.assertTrue((String)"invalid return value", (boolean)CollectionTools.addAll((Collection)l, (Object[])a));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)l.size());
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)l.containsAll(CollectionTools.collection((Object[])a)));
        CollectionToolsTests.assertFalse((String)"invalid return value", (boolean)CollectionTools.addAll((Collection)s, (Object[])a));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)s.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)s.containsAll(CollectionTools.collection((Object[])a)));
    }

    public void testAddAllObjectArrayCollection() {
        Object[] a = this.buildArray1();
        List c = this.buildList1();
        Object[] newArray = CollectionTools.addAll((Object[])a, (Collection)c);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Collection)c));
    }

    public void testAddAllObjectArrayCollection2() {
        Object[] a = this.buildStringArray1();
        List c = this.buildList1();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (Collection)c);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Collection)c));
    }

    public void testAddAllObjectArrayIterator() {
        Object[] a = this.buildArray1();
        Iterator i = this.buildList1().iterator();
        Object[] newArray = CollectionTools.addAll((Object[])a, i);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Collection)this.buildList1()));
    }

    public void testAddAllObjectArrayObjectArray() {
        Object[] a1 = this.buildArray1();
        Object[] a2 = this.buildArray2();
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray2() {
        Object[] a1 = this.buildStringArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((String)"elements not added", (boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayIntObjectArray() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)2, (Object[])new Object[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray2() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllCharArrayCharArray() {
        char[] a = CollectionTools.addAll((char[])this.buildCharArray(), (char[])new char[]{'d', 'e'});
        CollectionToolsTests.assertEquals((String)"invalid size", (int)5, (int)a.length);
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((char[])a, (char)'e'));
    }

    public void testAddAllCharArrayIntCharArray() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.addAll((char[])a, (int)2, (char[])new char[]{'X', 'X', 'X'});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'X', 'X', 'c', 'd'}, a));
    }

    public void testAddAllIntArrayIntArray() {
        int[] a = CollectionTools.addAll((int[])this.buildIntArray(), (int[])new int[]{30, 40});
        CollectionToolsTests.assertEquals((String)"invalid size", (int)5, (int)a.length);
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((int[])a, (int)40));
    }

    public void testAddAllIntArrayIntIntArray() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.addAll((int[])a, (int)2, (int[])new int[]{99, 99, 99});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 99, 99, 3, 4}, a));
    }

    public void testArrayIterator() {
        Object[] a = CollectionTools.array(this.buildList1().iterator());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)a.length);
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Object[])a, this.buildList1().iterator()));
    }

    public void testArrayIteratorObjectArray() {
        Object[] a = (String[])CollectionTools.array(this.buildList1().iterator(), (Object[])new String[0]);
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)a.length);
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Object[])a, this.buildList1().iterator()));
    }

    public void testBagEnumeration() {
        Bag b = CollectionTools.bag(this.buildVector1().elements());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)b.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)b.containsAll((Collection)this.buildVector1()));
    }

    public void testBagIterator() {
        Bag b = CollectionTools.bag(this.buildList1().iterator());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)b.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)b.containsAll((Collection)this.buildList1()));
    }

    public void testBagObjectArray() {
        Bag b = CollectionTools.bag((Object[])this.buildArray1());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)b.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Collection)b, (Object[])this.buildArray1()));
    }

    public void testCollectionEnumeration() {
        Collection c = CollectionTools.collection(this.buildVector1().elements());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)c.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)c.containsAll(this.buildVector1()));
    }

    public void testCollectionIterator() {
        Collection c = CollectionTools.collection(this.buildList1().iterator());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)c.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)c.containsAll(this.buildList1()));
    }

    public void testCollectionObjectArray() {
        Collection c = CollectionTools.collection((Object[])this.buildArray1());
        CollectionToolsTests.assertEquals((String)"invalid size", (int)3, (int)c.size());
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Collection)c, (Object[])this.buildArray1()));
    }

    public void testContainsIteratorObject() {
        List c = this.buildList1();
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains(c.iterator(), (Object)"one"));
        CollectionToolsTests.assertFalse((String)"null present", (boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((String)"null not present", (boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsObjectArrayObject() {
        Object[] a = this.buildArray1();
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((Object[])a, (Object)"one"));
        CollectionToolsTests.assertFalse((String)"null present", (boolean)CollectionTools.contains((Object[])a, null));
        Object[] a2 = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertTrue((String)"null not present", (boolean)CollectionTools.contains((Object[])a2, null));
    }

    public void testContainsCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((char[])a, (char)'a'));
        CollectionToolsTests.assertFalse((String)"'z' present", (boolean)CollectionTools.contains((char[])a, (char)'z'));
        char[] a2 = CollectionTools.add((char[])a, (char)'z');
        CollectionToolsTests.assertTrue((String)"'z' not present", (boolean)CollectionTools.contains((char[])a2, (char)'z'));
    }

    public void testContainsIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertTrue((String)"element not present", (boolean)CollectionTools.contains((int[])a, (int)10));
        CollectionToolsTests.assertFalse((String)"55 present", (boolean)CollectionTools.contains((int[])a, (int)55));
        int[] a2 = CollectionTools.add((int[])a, (int)55);
        CollectionToolsTests.assertTrue((String)"55 not present", (boolean)CollectionTools.contains((int[])a2, (int)55));
    }

    public void testContainsAllCollectionIterator() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Collection)this.buildList1(), this.buildList1().iterator()));
    }

    public void testContainsAllCollectionObjectArray() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Collection)this.buildList1(), (Object[])this.buildArray1()));
    }

    public void testContainsAllIteratorCollection() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll(this.buildList1().iterator(), (Collection)this.buildList1()));
    }

    public void testContainsAllIteratorIterator() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll(this.buildList1().iterator(), this.buildList1().iterator()));
    }

    public void testContainsAllIteratorObjectArray() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll(this.buildList1().iterator(), (Object[])this.buildArray1()));
    }

    public void testContainsAllObjectArrayCollection() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Object[])this.buildArray1(), (Collection)this.buildList1()));
    }

    public void testContainsAllObjectArrayIterator() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Object[])this.buildArray1(), this.buildList1().iterator()));
    }

    public void testContainsAllObjectArrayObjectArray() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((Object[])this.buildArray1(), (Object[])this.buildArray1()));
    }

    public void testContainsAllCharArrayCharArray() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((char[])this.buildCharArray(), (char[])this.buildCharArray()));
    }

    public void testContainsAllIntArrayIntArray() {
        CollectionToolsTests.assertTrue((String)"elements not present", (boolean)CollectionTools.containsAll((int[])this.buildIntArray(), (int[])this.buildIntArray()));
    }

    public void testIdentityDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((String)"invalid setup", (a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)0, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)3, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((String)"invalid identity diff end", (int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((String)"invalid setup", (a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)5, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)1, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)4, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)4, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)3, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((String)"invalid identity diff start", (int)5, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
    }

    public void testDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        CollectionToolsTests.assertTrue((String)"invalid setup", (a != a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (b != b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c != c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (d != d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)2, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)0, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)3, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)2, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((String)"invalid diff end", (int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
    }

    public void testDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        CollectionToolsTests.assertTrue((String)"invalid setup", (a != a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (b != b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c != c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (d != d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((String)"invalid setup", (e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)1, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)4, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)4, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)2, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)3, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((String)"invalid setup", (c != c__ && c.equals(c__) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)2, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((String)"invalid diff start", (int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
    }

    public void testEqualsListIteratorListIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 1;
        while (i < list1.size() + 1) {
            list2.add(String.valueOf(i * 1000));
            ++i;
        }
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical(list1.listIterator(), list2.listIterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.equals(list1.listIterator(), list2.listIterator()));
    }

    public void testGetListIteratorInt() {
        List list = this.buildList1();
        CollectionToolsTests.assertEquals((String)"invalid object", (Object)"one", (Object)CollectionTools.get(list.listIterator(), (int)1));
        list.add(null);
        CollectionToolsTests.assertEquals((String)"invalid object", null, (Object)CollectionTools.get(list.listIterator(), (int)(list.size() - 1)));
        boolean exCaught = false;
        try {
            CollectionTools.get(list.listIterator(), (int)list.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((String)"IndexOutOfBoundsException not thrown", (boolean)exCaught);
    }

    public void testIdenticalObjectArrayObjectArray() {
        Object[] a1 = new Object[4];
        int i = 0;
        while (i < a1.length) {
            a1[i] = String.valueOf(i * 1000);
            ++i;
        }
        Object[] a2 = new Object[a1.length];
        int i2 = 0;
        while (i2 < a2.length) {
            a2[i2] = a1[i2];
            ++i2;
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
        a2[2] = "2000";
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testIdenticalListIteratorListIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList list2 = new ArrayList();
        int i = 0;
        while (i < list1.size()) {
            list2.add(list1.get(i));
            ++i;
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical(list1.listIterator(), list2.listIterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.equals(list1.listIterator(), list2.listIterator()));
    }

    public void testIndexOfListIteratorObject() {
        List list = this.buildList1();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.indexOf(list.listIterator(), (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(list.size() - 1), (int)CollectionTools.indexOf(list.listIterator(), null));
    }

    public void testIndexOfObjectArrayObject() {
        Object[] a = this.buildArray1();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.indexOf((Object[])a, (Object)"one"));
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(a.length - 1), (int)CollectionTools.indexOf((Object[])a, null));
    }

    public void testIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((char[])a, (char)'b'));
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((char[])a, (char)'d'));
    }

    public void testIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.indexOf((int[])a, (int)10));
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(a.length - 1), (int)CollectionTools.indexOf((int[])a, (int)30));
    }

    public void testInsertionIndexOfListComparable() {
        List<Object> list = Arrays.asList("A", "C", "D");
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"E")));
        list = Arrays.asList("B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
        list = Arrays.asList("A", "A", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfListObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        List<Object> list = Arrays.asList("D", "C", "A");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "A");
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Object)"E", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "A", "A");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
    }

    public void testInsertionIndexOfObjectArrayComparable() {
        Object[] a = new Object[]{"A", "C", "D"};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf((Object[])a, (Comparable)((Object)"B")));
        a = new Object[]{"A", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Object[])a, (Comparable)((Object)"B")));
        a = new Object[]{"A", "B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf((Object[])a, (Comparable)((Object)"B")));
        a = new Object[]{"A", "B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf((Object[])a, (Comparable)((Object)"E")));
        a = new Object[]{"B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf((Object[])a, (Comparable)((Object)"A")));
        a = new Object[]{"A", "A", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Object[])a, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfObjectArrayObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        Object[] a = new Object[]{"D", "C", "A"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new Object[]{"D", "C", "B", "A"};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new Object[]{"D", "C", "B", "B", "B", "A"};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new Object[]{"D", "C", "B", "B", "B", "A"};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"E", (Comparator)c));
        a = new Object[]{"D", "C", "B", "B", "B"};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
        a = new Object[]{"D", "C", "B", "B", "A", "A"};
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
    }

    public void testIteratorObjectArray() {
        Object[] a = this.buildArray1();
        int i = 0;
        Iterator stream = CollectionTools.iterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)"invalid element", (Object)a[i], stream.next());
            ++i;
        }
    }

    public void testLastIndexOfListIteratorObject() {
        List list = this.buildList1();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.lastIndexOf(list.listIterator(), (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(list.size() - 1), (int)CollectionTools.lastIndexOf(list.listIterator(), null));
    }

    public void testLastIndexOfObjectArrayObject() {
        Object[] a = this.buildArray1();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.lastIndexOf((Object[])a, (Object)"one"));
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(a.length - 1), (int)CollectionTools.lastIndexOf((Object[])a, null));
    }

    public void testLastIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.lastIndexOf((char[])a, (char)'b'));
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(a.length - 1), (int)CollectionTools.lastIndexOf((char[])a, (char)'d'));
    }

    public void testLastIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((String)"invalid index", (int)1, (int)CollectionTools.lastIndexOf((int[])a, (int)10));
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((String)"invalid index", (int)(a.length - 1), (int)CollectionTools.lastIndexOf((int[])a, (int)30));
    }

    public void testListIterator() {
        List list = CollectionTools.list(this.buildList1().iterator());
        CollectionToolsTests.assertEquals((String)"invalid list", (Object)this.buildList1(), (Object)list);
    }

    public void testListObjectArray() {
        List list = CollectionTools.list((Object[])this.buildArray1());
        CollectionToolsTests.assertEquals((String)"invalid list", (Object)this.buildList1(), (Object)list);
    }

    public void testListIteratorObjectArray() {
        Object[] a = this.buildArray1();
        int i = 0;
        ListIterator stream = CollectionTools.listIterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)"invalid element", (Object)a[i], stream.next());
            ++i;
        }
    }

    public void testListIteratorObjectArrayInt() {
        Object[] a = this.buildArray1();
        int i = 1;
        ListIterator stream = CollectionTools.listIterator((Object[])a, (int)1);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)"invalid element", (Object)a[i], stream.next());
            ++i;
        }
    }

    public void testMaxCharArray() {
        CollectionToolsTests.assertEquals((char)'c', (char)CollectionTools.max((char[])this.buildCharArray()));
    }

    public void testMaxIntArray() {
        CollectionToolsTests.assertEquals((int)20, (int)CollectionTools.max((int[])this.buildIntArray()));
    }

    public void testMinCharArray() {
        CollectionToolsTests.assertEquals((char)'a', (char)CollectionTools.min((char[])this.buildCharArray()));
    }

    public void testMinIntArray() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.min((int[])this.buildIntArray()));
    }

    public void testRemoveAllObjectArrayObjectArray() {
        Object[] a1 = new Object[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new Object[]{"E", "B"};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"A", "A", "C", "C", "D", "D", "F", "F"}, CollectionTools.removeAll((Object[])a1, (Object[])a2)));
    }

    public void testRemoveAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'A', 'C', 'C', 'D', 'D', 'F', 'F'}, CollectionTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 1, 3, 3, 4, 4, 6, 6}, CollectionTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveObjectArrayObject() {
        Object[] a = this.buildArray1();
        a = CollectionTools.add((Object[])a, (Object)"three");
        a = CollectionTools.add((Object[])a, (Object)"four");
        a = CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        a = CollectionTools.remove((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveObjectArrayObject2() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.add((Object[])a, (Object)"three");
        a = (String[])CollectionTools.add((Object[])a, (Object)"four");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        a = (String[])CollectionTools.remove((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveCharArrayChar() {
        char[] a = this.buildCharArray();
        a = CollectionTools.add((char[])a, (char)'d');
        a = CollectionTools.add((char[])a, (char)'e');
        a = CollectionTools.add((char[])a, (char)'f');
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        a = CollectionTools.remove((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'e'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'f'));
    }

    public void testRemoveIntArrayInt() {
        int[] a = this.buildIntArray();
        a = CollectionTools.add((int[])a, (int)30);
        a = CollectionTools.add((int[])a, (int)40);
        a = CollectionTools.add((int[])a, (int)50);
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        a = CollectionTools.remove((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)40));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)50));
    }

    public void testRemoveAllCollectionIterator() {
        List c = this.buildList1();
        CollectionToolsTests.assertTrue((String)"invalid return value", (boolean)CollectionTools.removeAll((Collection)c, this.buildList1().iterator()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)0, (int)c.size());
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("three"));
        c = this.buildList1();
        CollectionToolsTests.assertFalse((String)"invalid return value", (boolean)CollectionTools.removeAll((Collection)c, this.buildList2().iterator()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)this.buildList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals((String)"elements removed", (Object)this.buildList1(), (Object)c);
    }

    public void testRemoveAllCollectionObjectArray() {
        List c = this.buildList1();
        CollectionToolsTests.assertTrue((String)"invalid return value", (boolean)CollectionTools.removeAll((Collection)c, (Object[])this.buildArray1()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)0, (int)c.size());
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("three"));
        c = this.buildList1();
        CollectionToolsTests.assertFalse((String)"invalid return value", (boolean)CollectionTools.removeAll((Collection)c, (Object[])this.buildArray2()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)this.buildList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals((String)"elements removed", (Object)this.buildList1(), (Object)c);
    }

    public void testRemoveAllOccurrencesCollectionObject() {
        List c = this.buildList1();
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences((Collection)c, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences((Collection)c, (Object)"two"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences((Collection)c, (Object)"two"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add("five");
        c.add("five");
        c.add("five");
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences((Collection)c, (Object)"five"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences((Collection)c, (Object)"five"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add(null);
        c.add(null);
        c.add(null);
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences((Collection)c, null));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences((Collection)c, null));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
    }

    public void testRemoveAllOccurrencesObjectArrayObject() {
        Object[] a = this.buildArray1();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, (Object)"two");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, (Object)"two");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((Object[])a, (Object)"five");
        a = CollectionTools.add((Object[])a, (Object)"five");
        a = CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((Object[])a, null);
        a = CollectionTools.add((Object[])a, null);
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, null);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((Object[])a, null);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'b');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'b');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((char[])a, (char)'g');
        a = CollectionTools.add((char[])a, (char)'g');
        a = CollectionTools.add((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)55);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)10);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)10);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((int[])a, (int)77);
        a = CollectionTools.add((int[])a, (int)77);
        a = CollectionTools.add((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testReplaceAllObjectArray() {
        Object[] a = new Object[]{"A", "B", "A", "C", "A", "D"};
        a = CollectionTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllCharArray() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.replaceAll((char[])a, (char)'A', (char)'Z');
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'Z', 'B', 'Z', 'C', 'Z', 'D'}, a));
    }

    public void testReplaceAllIntArray() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[3] = 7;
        nArray[5] = 99;
        int[] a = nArray;
        a = CollectionTools.replaceAll((int[])a, (int)0, (int)13);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{13, 1, 13, 7, 13, 99}, a));
    }

    public void testRetainAllCollectionIterator() {
        List c = this.buildList1();
        CollectionToolsTests.assertFalse((String)"invalid return value", (boolean)CollectionTools.retainAll((Collection)c, this.buildList1().iterator()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)this.buildList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals((String)"elements removed", (Object)this.buildList1(), (Object)c);
        CollectionToolsTests.assertTrue((String)"invalid return value", (boolean)CollectionTools.retainAll((Collection)c, this.buildList2().iterator()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)0, (int)c.size());
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("three"));
    }

    public void testRetainAllCollectionObjectArray() {
        List c = this.buildList1();
        CollectionToolsTests.assertFalse((String)"invalid return value", (boolean)CollectionTools.retainAll((Collection)c, (Object[])this.buildArray1()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)this.buildList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals((String)"elements removed", (Object)this.buildList1(), (Object)c);
        CollectionToolsTests.assertTrue((String)"invalid return value", (boolean)CollectionTools.retainAll((Collection)c, (Object[])this.buildArray2()));
        CollectionToolsTests.assertEquals((String)"invalid size", (int)0, (int)c.size());
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((String)"element present", (boolean)c.contains("three"));
    }

    public void testRetainAllObjectArrayObjectArray() {
        Object[] a1 = new Object[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new Object[]{"E", "B"};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, (Object[])a2)));
    }

    public void testRetainAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'B', 'B', 'E', 'E'}, CollectionTools.retainAll((char[])a1, (char[])a2)));
    }

    public void testRetainAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{2, 2, 5, 5}, CollectionTools.retainAll((int[])a1, (int[])a2)));
    }

    public void testReverseObjectArray() {
        Object[] a = this.buildArray1();
        a = CollectionTools.reverse((Object[])a);
        CollectionToolsTests.assertEquals((Object)"two", (Object)a[0]);
        CollectionToolsTests.assertEquals((Object)"one", (Object)a[1]);
        CollectionToolsTests.assertEquals((Object)"zero", (Object)a[2]);
    }

    public void testReverseCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.reverse((char[])a);
        CollectionToolsTests.assertEquals((char)'c', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testReverseIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.reverse((int[])a);
        CollectionToolsTests.assertEquals((int)20, (int)a[0]);
        CollectionToolsTests.assertEquals((int)10, (int)a[1]);
        CollectionToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testReverseListIterator() {
        List actual = CollectionTools.reverseList(this.buildList1().iterator());
        List expected = this.buildList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals((String)"invalid reverse list", (Object)expected, (Object)actual);
    }

    public void testRotateObjectArray() {
        Object[] a = this.buildArray1();
        a = CollectionTools.rotate((Object[])a);
        CollectionToolsTests.assertEquals((Object)"two", (Object)a[0]);
        CollectionToolsTests.assertEquals((Object)"zero", (Object)a[1]);
        CollectionToolsTests.assertEquals((Object)"one", (Object)a[2]);
    }

    public void testRotateObjectArrayInt() {
        Object[] a = this.buildArray1();
        a = CollectionTools.rotate((Object[])a, (int)2);
        CollectionToolsTests.assertEquals((Object)"one", (Object)a[0]);
        CollectionToolsTests.assertEquals((Object)"two", (Object)a[1]);
        CollectionToolsTests.assertEquals((Object)"zero", (Object)a[2]);
    }

    public void testRotateCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.rotate((char[])a);
        CollectionToolsTests.assertEquals((char)'c', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testRotateCharArrayInt() {
        char[] a = this.buildCharArray();
        a = CollectionTools.rotate((char[])a, (int)2);
        CollectionToolsTests.assertEquals((char)'b', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'c', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testRotateIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.rotate((int[])a);
        CollectionToolsTests.assertEquals((int)20, (int)a[0]);
        CollectionToolsTests.assertEquals((int)0, (int)a[1]);
        CollectionToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRotateIntArrayInt() {
        int[] a = this.buildIntArray();
        a = CollectionTools.rotate((int[])a, (int)2);
        CollectionToolsTests.assertEquals((int)10, (int)a[0]);
        CollectionToolsTests.assertEquals((int)20, (int)a[1]);
        CollectionToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testSetIterator() {
        CollectionToolsTests.assertEquals((String)"incorrect Set", (Object)this.buildSet1(), (Object)CollectionTools.set(this.buildSet1().iterator()));
    }

    public void testSetObjectArray() {
        CollectionToolsTests.assertEquals((String)"incorrect Set", (Object)this.buildSet1(), (Object)CollectionTools.set((Object[])this.buildSet1().toArray()));
    }

    public void testSortedSetIterator() {
        CollectionToolsTests.assertEquals((String)"incorrect SortedSet", (Object)this.buildSortedSet1(), (Object)CollectionTools.set(this.buildSortedSet1().iterator()));
    }

    public void testSortedSetObjectArray() {
        CollectionToolsTests.assertEquals((String)"incorrect SortedSet", (Object)this.buildSortedSet1(), (Object)CollectionTools.set((Object[])this.buildSortedSet1().toArray()));
    }

    public void testSwapObjectArray() {
        Object[] a = this.buildArray1();
        a = CollectionTools.swap((Object[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((Object)"zero", (Object)a[0]);
        CollectionToolsTests.assertEquals((Object)"two", (Object)a[1]);
        CollectionToolsTests.assertEquals((Object)"one", (Object)a[2]);
    }

    public void testSwapCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.swap((char[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((char)'a', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'c', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testSwapIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.swap((int[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((int)0, (int)a[0]);
        CollectionToolsTests.assertEquals((int)20, (int)a[1]);
        CollectionToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRemoveDuplicateElementsList() {
        List list = this.buildVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        list = CollectionTools.removeDuplicateElements((List)list);
        int i = 0;
        CollectionToolsTests.assertEquals((Object)"zero", list.get(i++));
        CollectionToolsTests.assertEquals((Object)"one", list.get(i++));
        CollectionToolsTests.assertEquals((Object)"two", list.get(i++));
        CollectionToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsObjectArray() {
        Vector list = this.buildVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        Object[] array = CollectionTools.removeDuplicateElements((Object[])list.toArray());
        int i = 0;
        CollectionToolsTests.assertEquals((Object)"zero", (Object)array[i++]);
        CollectionToolsTests.assertEquals((Object)"one", (Object)array[i++]);
        CollectionToolsTests.assertEquals((Object)"two", (Object)array[i++]);
        CollectionToolsTests.assertEquals((int)i, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray2() {
        Vector list = this.buildVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        String[] array = (String[])CollectionTools.removeDuplicateElements((Object[])list.toArray(new String[list.size()]));
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"one", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"two", (String)array[i++]);
        CollectionToolsTests.assertEquals((int)i, (int)array.length);
    }

    private Object[] buildArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private char[] buildCharArray() {
        return new char[]{'a', 'b', 'c'};
    }

    private int[] buildIntArray() {
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 20;
        return nArray;
    }

    private Object[] buildArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private String[] buildStringArray2() {
        return new String[]{"three", "four", "five"};
    }

    private Vector buildVector1() {
        Vector v = new Vector();
        this.addToCollection1(v);
        return v;
    }

    private List buildList1() {
        ArrayList l = new ArrayList();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List buildList2() {
        ArrayList l = new ArrayList();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }

    private Set buildSet1() {
        HashSet s = new HashSet();
        this.addToCollection1(s);
        return s;
    }

    private SortedSet buildSortedSet1() {
        TreeSet s = new TreeSet();
        this.addToCollection1(s);
        return s;
    }
}

