/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.projects;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dali.core.tests.projects.TestDaliProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class SimpleTestProject
extends TestDaliProject {
    public static String PROJECT_NAME = "SimpleTestProject";
    public static String PACKAGE_NAME = "test";
    public static String TYPE_NAME = "TestClass";
    public static String FILE_NAME = "TestClass.java";

    public SimpleTestProject() throws CoreException {
        super(PROJECT_NAME, false);
        this.createType(this.createPackage(PACKAGE_NAME), FILE_NAME, this.createTypeSource());
    }

    public String getFullyQualifiedTestClassName() {
        return String.valueOf(PACKAGE_NAME) + "." + TYPE_NAME;
    }

    public IType getTestClassType() throws JavaModelException {
        return this.getJavaProject().findType(this.getFullyQualifiedTestClassName());
    }

    public IField getTestClassField() throws JavaModelException {
        return this.getTestClassType().getField("testField");
    }

    public IMethod getTestClassMethod() throws JavaModelException {
        return this.getTestClassType().getMethod("getTestField", null);
    }

    private String createTypeSource() {
        StringBuffer sb = new StringBuffer();
        sb.append("import javax.persistence.Id;\n");
        sb.append("\n");
        sb.append("public class " + TYPE_NAME + " {\n");
        sb.append("    @Id\n");
        sb.append("    private int id;\n");
        sb.append("    \n");
        sb.append("    private String testField;\n");
        sb.append("    \n");
        sb.append("    public int getId() {\n");
        sb.append("        return this.id;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public void setId(int id) {\n");
        sb.append("        this.id = id;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public String getTestField() {\n");
        sb.append("        return this.testField;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public void setTestField(String testField) {\n");
        sb.append("        this.testField = testField;\n");
        sb.append("    }\n");
        sb.append("}");
        return sb.toString();
    }
}

