/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaTableModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaTableModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaTableModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testTableNameUpdatesFromComboBoxChanges() throws JavaModelException {
        Type type = ((JavaPersistentTypeModelAdapter)this.testClassType.getModelAdapter()).getType();
        Entity entity = (Entity)this.testClassType.getTypeMapping();
        entity.getTable().setSpecifiedName("EMPLOYEE");
        CompilationUnit astRoot = type.createASTRoot();
        JavaTableModelAdapter tableModelAdapter = (JavaTableModelAdapter)entity.getTable().getModelAdapter();
        StringAnnotationElementAdapter specifiedTableNameAdapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)tableModelAdapter, (String)"specifiedNameAdapter");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String javaValue = (String)ClassTools.invokeMethod((Object)specifiedTableNameAdapter, (String)"javaValue", (Class)clazz, (Object)astRoot);
        JavaTableModelAdapterTests.assertTrue((boolean)javaValue.equals("EMPLOYEE"));
        JavaTableModelAdapterTests.assertTrue((String)"javax.persistence.Table import was not added", (boolean)type.getJDTMember().getCompilationUnit().getImport("javax.persistence.Table").exists());
        entity.getTable().setSpecifiedName(null);
        astRoot = type.createASTRoot();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)specifiedTableNameAdapter, (String)"javaValue", (Class)clazz2, (Object)astRoot);
        JavaTableModelAdapterTests.assertTrue((String)"Table annotation was not removed", (!type.containsAnnotation("Table", astRoot) ? 1 : 0) != 0);
        JavaTableModelAdapterTests.assertTrue((javaValue == null ? 1 : 0) != 0);
    }

    public void testTableNameComboBoxUpdatesFromSourceChanges() throws JavaModelException {
        Type type = ((JavaPersistentTypeModelAdapter)this.testClassType.getModelAdapter()).getType();
        Entity entity = (Entity)this.testClassType.getTypeMapping();
        JavaTableModelAdapter tableModelAdapter = (JavaTableModelAdapter)entity.getTable().getModelAdapter();
        StringAnnotationElementAdapter specifiedTableNameAdapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)tableModelAdapter, (String)"specifiedNameAdapter");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)specifiedTableNameAdapter, (String)"setJavaValue", (Class)clazz, (Object)"EMPLOYEE");
        JavaTableModelAdapterTests.assertTrue((String)"Table name was not updated", (boolean)entity.getTable().getSpecifiedName().equals("EMPLOYEE"));
        JavaTableModelAdapterTests.assertTrue((String)"javax.persistence.Table import was not added", (boolean)type.getJDTMember().getCompilationUnit().getImport("javax.persistence.Table").exists());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)specifiedTableNameAdapter, (String)"setJavaValue", (Class)clazz2, (Object)"");
        JavaTableModelAdapterTests.assertTrue((String)"Table name was not updated", (boolean)entity.getTable().getSpecifiedName().equals(""));
        type.removeAnnotationElement("Table", "name");
        JavaTableModelAdapterTests.assertTrue((String)"Table name combo was not set to default", (entity.getTable().getSpecifiedName() == null ? 1 : 0) != 0);
    }
}

