/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.DiscriminatorType;
import org.eclipse.dali.orm.DiscriminatorValue;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.JavaDiscriminatorValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaEntityModelAdapter;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaDiscriminatorValueModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaDiscriminatorValueModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaDiscriminatorValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    private Entity getEntity() {
        return (Entity)this.testClassType.getTypeMapping();
    }

    private JavaEntityModelAdapter getEntityModelAdapter() {
        return (JavaEntityModelAdapter)this.testClassType.getTypeMapping().getModelAdapter();
    }

    private JavaDiscriminatorValueModelAdapter getDiscriminatorValueModelAdapter() {
        return (JavaDiscriminatorValueModelAdapter)this.getDiscriminatorValue().getModelAdapter();
    }

    private DiscriminatorValue getDiscriminatorValue() {
        return ((Entity)this.testClassType.getTypeMapping()).getInheritance().getDiscriminatorValue();
    }

    public void testSetDiscriminatorValueInPersistenceModelUpdatesJava() {
        DiscriminatorValue discriminatorValue = this.getDiscriminatorValue();
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorValueModelAdapter(), (String)"specifiedValueAnnotationElementAdapter");
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        discriminatorValue.setSpecifiedValue("Customer");
        CompilationUnit astRoot = type.createASTRoot();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz, (Object)astRoot);
        JavaDiscriminatorValueModelAdapterTests.assertEquals((String)"Customer", (String)javaValue);
        JavaDiscriminatorValueModelAdapterTests.assertEquals((String)"Customer", (String)discriminatorValue.getValue());
        discriminatorValue.setSpecifiedValue(null);
        astRoot = type.createASTRoot();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz2, (Object)astRoot);
        JavaDiscriminatorValueModelAdapterTests.assertEquals(null, (String)javaValue);
    }

    public void testSetDiscriminatorValueInJavaUpdatesPersistenceModel() {
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getDiscriminatorValueModelAdapter(), (String)"specifiedValueAnnotationElementAdapter");
        JavaDiscriminatorValueModelAdapterTests.assertEquals((String)SimpleTestProject.TYPE_NAME, (String)this.getDiscriminatorValue().getDefaultValue());
        JavaDiscriminatorValueModelAdapterTests.assertEquals(null, (String)this.getDiscriminatorValue().getSpecifiedValue());
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"Customer");
        JavaDiscriminatorValueModelAdapterTests.assertEquals((String)"Customer", (String)this.getDiscriminatorValue().getSpecifiedValue());
        this.getEntity().getInheritance().getDiscriminatorColumn().setDiscriminatorType(DiscriminatorType.INTEGER_LITERAL);
        JavaDiscriminatorValueModelAdapterTests.assertEquals((String)"DiscriminatorValue default for DiscriminatorColumn Type of INTEGER should be null", null, (String)this.getDiscriminatorValue().getDefaultValue());
    }
}

