/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.product;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/**
 * Meta data for an ORM product.
 */
public class OrmProduct {

	private String id;

	private String name;

	private String version;

	private String vendor;

	private String entityModelManager;

	private String namespace;

	private Image icon;

    private Properties properties = new Properties();

	OrmProduct(String id, String name, String version, String vendor,
			String entityModelManager, String icon, String namespace) {
		super();
		this.id = id;
		this.name = name;
		this.version = version;
		this.vendor = vendor;
		this.entityModelManager = entityModelManager;
		this.namespace = namespace;
		if (icon != null && icon.trim().length() > 0) {
			try {
				Bundle bundle = Platform.getBundle(namespace);
				URL resource = bundle.getEntry(icon);
				if (resource != null) {
					InputStream in = resource.openStream();
					this.icon = new Image(Display.getCurrent(), in);
					in.close();
				} else {
					OrmPlugin.log(null, null,
                            new Status(IStatus.WARNING, OrmPlugin.ID, 0,
							"Could not create icon '"+icon+"' for " + name, null));
				}
			} catch (Exception x) {
				OrmPlugin.log(null, "Could not create icon '"+icon+"' for " + name, 
                        x, IStatus.WARNING);
			}
		}
	}

	public String getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getVersion() {
		return version;
	}

	public String getVendor() {
		return vendor;
	}

	public String getEntityModelManager() {
		return entityModelManager;
	}

	public String getNamespace() {
		return namespace;
	}

	public String toString() {
		if (version == null) {
			return name;
		}
		return name + " (" + version + ")";
	}

	public Image getIcon() {
		return icon;
	}

    public Properties getProperties() {
        return properties ;
    }
}
