/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.options;

import org.eclipse.jsr220orm.core.options.IIntOption;

public class IntOption implements IIntOption {

    private int id;
    private String text;
    private Object image;
    private String tooltip;

    public IntOption(int id, String text) {
    	this(id, text, null, null);
    }

    public IntOption(int id, String text, String tooltip) {
    	this(id, text, tooltip, null);
    }
    
    public IntOption(int id, String text, String tooltip, Object image) {
    	this.id = id;
    	this.text = text;
    	this.tooltip = tooltip;
    	this.image = image;
    }
    
    public int getId() {
        return id;
    }
    
    public String getText() {
        return text;
    }

    public Object getImage() {
        return image;
    }

    public String getTooltipText() {
        return tooltip;
    }

    public int hashCode() {
        return id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IIntOption){
            return ((IIntOption)obj).getId() == getId();
        }
        return false;
    }
    
    public String toString() {
    	return id + " " + text;
    }
}
