/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.io.ast;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;

/**
 * Wraps an AST import list and provides methods to quickly check if a class
 * is imported and to add imports as needed.
 */
public class ImportListHelper {
	
	protected final CompilationUnit root;
	protected final Set<String> importedNames = new HashSet();

	public ImportListHelper(CompilationUnit root) {
		this.root = root;
		for (Iterator iter = root.imports().iterator(); iter.hasNext();) {
			ImportDeclaration imp = (ImportDeclaration)iter.next();
			String name = imp.getName().getFullyQualifiedName();
			importedNames.add(name);
		}
	}
	
	public CompilationUnit getRoot() {
		return root;
	}

	/**
	 * Make sure that className is imported, adding it if necessary. 
	 */
	public void ensureImport(String className) {
		if (importedNames.contains(className)) {
			return;
		}
		AST ast = root.getAST();
		ImportDeclaration newImp = ast.newImportDeclaration();
		newImp.setName(ast.newName(className));
		root.imports().add(newImp);
	}

}
