/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataItemProviderAdapterFactory.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jsr220orm.metadata.util.MetadataAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MetadataItemProviderAdapterFactory extends MetadataAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public MetadataItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);		
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.CollectionAttribute} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected CollectionAttributeItemProvider collectionAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.CollectionAttribute}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter createCollectionAttributeAdapter() {
		if (collectionAttributeItemProvider == null) {
			collectionAttributeItemProvider = new CollectionAttributeItemProvider(this);
		}

		return collectionAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.EntityMetaData} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected EntityMetaDataItemProvider entityMetaDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.EntityMetaData}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter createEntityMetaDataAdapter() {
		if (entityMetaDataItemProvider == null) {
			entityMetaDataItemProvider = new EntityMetaDataItemProvider(this);
		}

		return entityMetaDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.EntityModel} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected EntityModelItemProvider entityModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.EntityModel}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter createEntityModelAdapter() {
		if (entityModelItemProvider == null) {
			entityModelItemProvider = new EntityModelItemProvider(this);
		}

		return entityModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.JdoEntity} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected JdoEntityItemProvider jdoEntityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.JdoEntity}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter createJdoEntityAdapter() {
		if (jdoEntityItemProvider == null) {
			jdoEntityItemProvider = new JdoEntityItemProvider(this);
		}

		return jdoEntityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.MapAttribute} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected MapAttributeItemProvider mapAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.MapAttribute}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter createMapAttributeAdapter() {
		if (mapAttributeItemProvider == null) {
			mapAttributeItemProvider = new MapAttributeItemProvider(this);
		}

		return mapAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.TypeMetaData} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected TypeMetaDataItemProvider typeMetaDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.TypeMetaData}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter createTypeMetaDataAdapter() {
		if (typeMetaDataItemProvider == null) {
			typeMetaDataItemProvider = new TypeMetaDataItemProvider(this);
		}

		return typeMetaDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.BasicAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BasicAttributeItemProvider basicAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.BasicAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBasicAttributeAdapter() {
		if (basicAttributeItemProvider == null) {
			basicAttributeItemProvider = new BasicAttributeItemProvider(this);
		}

		return basicAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.ReferenceAttribute} instances.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected ReferenceAttributeItemProvider referenceAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.ReferenceAttribute}.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Adapter createReferenceAttributeAdapter() {
		if (referenceAttributeItemProvider == null) {
			referenceAttributeItemProvider = new ReferenceAttributeItemProvider(this);
		}

		return referenceAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.Join} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinItemProvider joinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.Join}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createJoinAdapter() {
		if (joinItemProvider == null) {
			joinItemProvider = new JoinItemProvider(this);
		}

		return joinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.JoinPair} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinPairItemProvider joinPairItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.JoinPair}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createJoinPairAdapter() {
		if (joinPairItemProvider == null) {
			joinPairItemProvider = new JoinPairItemProvider(this);
		}

		return joinPairItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.OrmColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrmColumnItemProvider ormColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.OrmColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createOrmColumnAdapter() {
		if (ormColumnItemProvider == null) {
			ormColumnItemProvider = new OrmColumnItemProvider(this);
		}

		return ormColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.OrmTable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrmTableItemProvider ormTableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.OrmTable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createOrmTableAdapter() {
		if (ormTableItemProvider == null) {
			ormTableItemProvider = new OrmTableItemProvider(this);
		}

		return ormTableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.SimpleTypeMetaData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleTypeMetaDataItemProvider simpleTypeMetaDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.SimpleTypeMetaData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSimpleTypeMetaDataAdapter() {
		if (simpleTypeMetaDataItemProvider == null) {
			simpleTypeMetaDataItemProvider = new SimpleTypeMetaDataItemProvider(this);
		}

		return simpleTypeMetaDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.CollectionTypeMetaData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionTypeMetaDataItemProvider collectionTypeMetaDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.CollectionTypeMetaData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCollectionTypeMetaDataAdapter() {
		if (collectionTypeMetaDataItemProvider == null) {
			collectionTypeMetaDataItemProvider = new CollectionTypeMetaDataItemProvider(this);
		}

		return collectionTypeMetaDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jsr220orm.metadata.EmbeddedAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EmbeddedAttributeItemProvider embeddedAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.jsr220orm.metadata.EmbeddedAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEmbeddedAttributeAdapter() {
		if (embeddedAttributeItemProvider == null) {
			embeddedAttributeItemProvider = new EmbeddedAttributeItemProvider(this);
		}

		return embeddedAttributeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void dispose() {
		if (collectionAttributeItemProvider != null) collectionAttributeItemProvider.dispose();
		if (entityMetaDataItemProvider != null) entityMetaDataItemProvider.dispose();
		if (entityModelItemProvider != null) entityModelItemProvider.dispose();
		if (jdoEntityItemProvider != null) jdoEntityItemProvider.dispose();
		if (mapAttributeItemProvider != null) mapAttributeItemProvider.dispose();
		if (typeMetaDataItemProvider != null) typeMetaDataItemProvider.dispose();
		if (basicAttributeItemProvider != null) basicAttributeItemProvider.dispose();
		if (referenceAttributeItemProvider != null) referenceAttributeItemProvider.dispose();
		if (joinItemProvider != null) joinItemProvider.dispose();
		if (joinPairItemProvider != null) joinPairItemProvider.dispose();
		if (ormColumnItemProvider != null) ormColumnItemProvider.dispose();
		if (ormTableItemProvider != null) ormTableItemProvider.dispose();
		if (simpleTypeMetaDataItemProvider != null) simpleTypeMetaDataItemProvider.dispose();
		if (collectionTypeMetaDataItemProvider != null) collectionTypeMetaDataItemProvider.dispose();
		if (embeddedAttributeItemProvider != null) embeddedAttributeItemProvider.dispose();
	}

}
