/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.views.provider;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.nature.OrmNatureEvent;
import org.eclipse.jsr220orm.core.nature.OrmNatureListener;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.swt.widgets.Display;

public class OutlineContentProvider implements ITreeContentProvider,
		INotifyChangedListener, OrmNatureListener, IResourceChangeListener {

	private AdapterFactoryContentProvider contentProvider;

	private Viewer viewer;

	public OutlineContentProvider(ComposedAdapterFactory adapterFactory) {
		contentProvider = new AdapterFactoryContentProvider(adapterFactory);
	}

	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof IWorkspaceRoot) {
			IWorkspaceRoot workspaceRoot = (IWorkspaceRoot) inputElement;
			workspaceRoot.getWorkspace().addResourceChangeListener(this,
					IResourceChangeEvent.POST_CHANGE);
			return (workspaceRoot).getProjects();
		} else if (inputElement instanceof IProject) {
			IProject project = (IProject) inputElement;
			OrmNature nature = null;
			try {
				nature = (OrmNature) project.getNature(OrmNature.ID);
			} catch (CoreException e) {
				return null;
			}
			if (nature == null) {
				return null;
			}
			nature.addOrmNatureListener(this);
            OrmProject ormProject = nature.getActiveOrmProject();
			return contentProvider.getElements(ormProject.getModel());
		} else if (inputElement instanceof OrmProject) {
			OrmProject ormProject = (OrmProject) inputElement;
			return contentProvider.getElements(ormProject.getModel());
		} else if (inputElement instanceof Object[]) {
			return (Object[]) inputElement;
		} else if (inputElement instanceof EntityMetaData) {
            EntityMetaData entity = (EntityMetaData) inputElement;
            return entity.getAttributeList().toArray();
//		} else if (inputElement instanceof AttributeMetaData) {
//		    return contentProvider.getElements(inputElement);
		} else {
		    return null;
		}
	}

    public void dispose() {
		viewer = null;
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		contentProvider.inputChanged(viewer, oldInput, newInput);
		this.viewer = viewer;
	}

	public Object[] getChildren(Object parentElement) {
		return getElements(parentElement);
	}

	public Object getParent(Object element) {
		if (element instanceof IProject) {
			return null;
		} else if (element instanceof OrmProject) {
			OrmProject ormProject = (OrmProject) element;
			return ormProject.getIProject();
		} else {
			Object parent = contentProvider.getParent(element);
			if (parent instanceof EntityModel) {
				return null;
			}
			return parent;
		}
	}

	public boolean hasChildren(Object element) {
		Object[] children = getChildren(element);
		return children != null && children.length > 0;
	}

	public void notifyChanged(Notification notification) {
		contentProvider.notifyChanged(notification);
	}

    public void projectActivated(OrmNatureEvent e) {
        refreshElement(e.getNature().getProject(), true, true);
        
    }

    public void projectDeactivated(OrmNatureEvent e) {
        refreshElement(e.getNature().getProject(), true, true);
    }

	public void ormNatureRemoved(OrmNatureEvent e) {
		refreshElement(e.getNature().getProject(), false, true);
	}

	public void refreshElement(Object element, boolean updateLabels,
			boolean refreshContent) {
		if (viewer != null && viewer.getControl() != null
				&& !viewer.getControl().isDisposed()) {
			RefreshRunner viewerRefresh = new RefreshRunner(viewer, element,
					updateLabels, refreshContent);
			Display d = viewer.getControl().getDisplay();
			if (d != Display.getCurrent()) {
				d.asyncExec(viewerRefresh);
			} else {
				viewerRefresh.run();
			}
		}
	}

	class RefreshRunner implements Runnable {
		Viewer viewer;

		Object element;

		boolean updateLabels;

		boolean refreshContent;

		public RefreshRunner(Viewer viewer, Object element,
				boolean updateLabels, boolean refreshContent) {
			super();
			this.viewer = viewer;
			this.element = element;
			this.updateLabels = updateLabels;
			this.refreshContent = refreshContent;
		}

		public void run() {
			if (viewer instanceof StructuredViewer) {
				StructuredViewer structuredViewer = (StructuredViewer) viewer;
				if (element != null) {
					if (refreshContent) {
						structuredViewer.refresh(element, updateLabels);
					} else if (updateLabels) {
						structuredViewer.update(element, null);
					}
				} else {
					structuredViewer.refresh(updateLabels);
				}
			} else {
				viewer.refresh();
			}
		}
	}

	public void resourceChanged(IResourceChangeEvent event) {
		System.out.println("OutlineContentProvider.resourceChanged(): "
				+ event);

	}
}
