/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.mapping.MappingUIProvider;
import org.eclipse.jsr220orm.ui.mapping.MetadataUISelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;

public class MainMetadataUISelector implements MetadataUISelector {

	private Map selectors = new HashMap();
	private Map selectorsInstances = new HashMap();
	private DefaultMetadataUISelector defaultSelector;

	public MainMetadataUISelector() {
		// TODO make this an ExtentionPoint and remove next line;
		// (DefaultMetadataUISelector not in ext point)
		selectors.put(MetadataElement.class.getName(), new ProviderExtention(
				DefaultMetadataUISelector.class.getName(), OrmUiPlugin.getPluginId()));
	}

	public MappingUIProvider getMappingUIProvider(MetadataElement element,
			Composite parent, FormToolkit toolkit) {
		MetadataUISelector selector = getSelector(element.getClass());
		if (selector != null) {
			return selector.getMappingUIProvider(element, parent, toolkit);
		}
		return null;
	}

	private MetadataUISelector getSelector(Class clazz) {
		if (clazz == null) {
			return getDefaultSelector();
		}
		MetadataUISelector selector = (MetadataUISelector) selectorsInstances
				.get(clazz);
		if (selector == null) {
			selector = getSelector(clazz.getName());
			if (selector == null) {
				selector = getSelector(clazz.getSuperclass());
				if (selector == null) {
					Class[] interfaces = clazz.getInterfaces();
					for (int x = interfaces.length - 1; x >= 0; x--) {
						selector = getSelector(interfaces[x]);
						if (selector != null) {
							break;
						}
					}
				}
			}
			if (selector != null) {
				selectorsInstances.put(clazz, selector);
			}
		}
		return selector;
	}

	private MetadataUISelector getSelector(String className) {
		ProviderExtention selectorExtention = (ProviderExtention) selectors
				.get(className);
		if (selectorExtention != null) {
			try {
				Bundle bundle = Platform.getBundle(selectorExtention.namespace);
				Class selectorClass = bundle
						.loadClass(selectorExtention.selectorClassName);
				return (MetadataUISelector) selectorClass.newInstance();
			} catch (Exception x) {
				OrmPlugin.log(null, "Could not load MetadataUISelector class "
						+ selectorExtention.selectorClassName + " for plgin "
						+ selectorExtention.namespace, x, IStatus.WARNING);
			}
		}
		return null;
	}

	private class ProviderExtention {
		private String selectorClassName;

		private String namespace;

		public ProviderExtention(String selectorClassName, String namespace) {
			this.selectorClassName = selectorClassName;
			this.namespace = namespace;
		}
	}

	public DefaultMetadataUISelector getDefaultSelector() {
		if (defaultSelector == null) {
			defaultSelector = new DefaultMetadataUISelector();
		}
		return defaultSelector;
	}

}
