/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributeMetaDataImpl.java,v 1.16 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Attribute Meta Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getEntityMetaData <em>Entity Meta Data</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getEmbeddedIn <em>Embedded In</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getJavaType <em>Java Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getFetchType <em>Fetch Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#isOptional <em>Optional</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getGetterMethodName <em>Getter Method Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getSetterMethodName <em>Setter Method Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getMappedBy <em>Mapped By</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getInverseList <em>Inverse List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getOverrideOf <em>Override Of</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl#getOverrideList <em>Override List</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AttributeMetaDataImpl extends MetadataElementImpl
		implements AttributeMetaData {
	/**
	 * The cached value of the '{@link #getEntityMetaData() <em>Entity Meta Data</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntityMetaData()
	 * @generated
	 * @ordered
	 */
	protected EntityMetaData entityMetaData = null;

	/**
	 * The cached value of the '{@link #getEmbeddedIn() <em>Embedded In</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEmbeddedIn()
	 * @generated
	 * @ordered
	 */
	protected EmbeddedAttribute embeddedIn = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getJavaType() <em>Java Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getJavaType()
	 * @generated
	 * @ordered
	 */
	protected TypeMetaData javaType = null;

	/**
	 * The default value of the '{@link #getFetchType() <em>Fetch Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFetchType()
	 * @generated
	 * @ordered
	 */
	protected static final int FETCH_TYPE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getFetchType() <em>Fetch Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFetchType()
	 * @generated
	 * @ordered
	 */
	protected int fetchType = FETCH_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #isOptional() <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isOptional()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OPTIONAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isOptional() <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isOptional()
	 * @generated
	 * @ordered
	 */
	protected boolean optional = OPTIONAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getGetterMethodName() <em>Getter Method Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getGetterMethodName()
	 * @generated
	 * @ordered
	 */
    protected static final String GETTER_METHOD_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getGetterMethodName() <em>Getter Method Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getGetterMethodName()
	 * @generated
	 * @ordered
	 */
    protected String getterMethodName = GETTER_METHOD_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSetterMethodName() <em>Setter Method Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getSetterMethodName()
	 * @generated
	 * @ordered
	 */
    protected static final String SETTER_METHOD_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSetterMethodName() <em>Setter Method Name</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getSetterMethodName()
	 * @generated
	 * @ordered
	 */
    protected String setterMethodName = SETTER_METHOD_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMappedBy() <em>Mapped By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMappedBy()
	 * @generated
	 * @ordered
	 */
	protected AttributeMetaData mappedBy = null;

	/**
	 * The cached value of the '{@link #getInverseList() <em>Inverse List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInverseList()
	 * @generated
	 * @ordered
	 */
	protected EList inverseList = null;

	/**
	 * The cached value of the '{@link #getOverrideOf() <em>Override Of</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverrideOf()
	 * @generated
	 * @ordered
	 */
	protected AttributeMetaData overrideOf = null;

	/**
	 * The cached value of the '{@link #getOverrideList() <em>Override List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverrideList()
	 * @generated
	 * @ordered
	 */
	protected EList overrideList = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeMetaDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getAttributeMetaData();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EntityMetaData getEntityMetaData() {
		if (entityMetaData != null && entityMetaData.eIsProxy()) {
			EntityMetaData oldEntityMetaData = entityMetaData;
			entityMetaData = (EntityMetaData)eResolveProxy((InternalEObject)entityMetaData);
			if (entityMetaData != oldEntityMetaData) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA, oldEntityMetaData, entityMetaData));
			}
		}
		return entityMetaData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EntityMetaData basicGetEntityMetaData() {
		return entityMetaData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEntityMetaData(EntityMetaData newEntityMetaData, NotificationChain msgs) {
		EntityMetaData oldEntityMetaData = entityMetaData;
		entityMetaData = newEntityMetaData;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA, oldEntityMetaData, newEntityMetaData);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntityMetaData(EntityMetaData newEntityMetaData) {
		if (newEntityMetaData != entityMetaData) {
			NotificationChain msgs = null;
			if (entityMetaData != null)
				msgs = ((InternalEObject)entityMetaData).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, EntityMetaData.class, msgs);
			if (newEntityMetaData != null)
				msgs = ((InternalEObject)newEntityMetaData).eInverseAdd(this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, EntityMetaData.class, msgs);
			msgs = basicSetEntityMetaData(newEntityMetaData, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA, newEntityMetaData, newEntityMetaData));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EmbeddedAttribute getEmbeddedIn() {
		if (embeddedIn != null && embeddedIn.eIsProxy()) {
			EmbeddedAttribute oldEmbeddedIn = embeddedIn;
			embeddedIn = (EmbeddedAttribute)eResolveProxy((InternalEObject)embeddedIn);
			if (embeddedIn != oldEmbeddedIn) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN, oldEmbeddedIn, embeddedIn));
			}
		}
		return embeddedIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EmbeddedAttribute basicGetEmbeddedIn() {
		return embeddedIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEmbeddedIn(EmbeddedAttribute newEmbeddedIn, NotificationChain msgs) {
		EmbeddedAttribute oldEmbeddedIn = embeddedIn;
		embeddedIn = newEmbeddedIn;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN, oldEmbeddedIn, newEmbeddedIn);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEmbeddedIn(EmbeddedAttribute newEmbeddedIn) {
		if (newEmbeddedIn != embeddedIn) {
			NotificationChain msgs = null;
			if (embeddedIn != null)
				msgs = ((InternalEObject)embeddedIn).eInverseRemove(this, MetadataPackage.EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST, EmbeddedAttribute.class, msgs);
			if (newEmbeddedIn != null)
				msgs = ((InternalEObject)newEmbeddedIn).eInverseAdd(this, MetadataPackage.EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST, EmbeddedAttribute.class, msgs);
			msgs = basicSetEmbeddedIn(newEmbeddedIn, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN, newEmbeddedIn, newEmbeddedIn));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData getJavaType() {
		if (javaType != null && javaType.eIsProxy()) {
			TypeMetaData oldJavaType = javaType;
			javaType = (TypeMetaData)eResolveProxy((InternalEObject)javaType);
			if (javaType != oldJavaType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE, oldJavaType, javaType));
			}
		}
		return javaType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData basicGetJavaType() {
		return javaType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setJavaType(TypeMetaData newJavaType) {
		TypeMetaData oldJavaType = javaType;
		javaType = newJavaType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE, oldJavaType, javaType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public int getFetchType() {
		return fetchType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setFetchType(int newFetchType) {
		int oldFetchType = fetchType;
		fetchType = newFetchType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE, oldFetchType, fetchType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isOptional() {
		return optional;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setOptional(boolean newOptional) {
		boolean oldOptional = optional;
		optional = newOptional;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL, oldOptional, optional));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getGetterMethodName() {
		return getterMethodName;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setGetterMethodName(String newGetterMethodName) {
		String oldGetterMethodName = getterMethodName;
		getterMethodName = newGetterMethodName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__GETTER_METHOD_NAME, oldGetterMethodName, getterMethodName));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getSetterMethodName() {
		return setterMethodName;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setSetterMethodName(String newSetterMethodName) {
		String oldSetterMethodName = setterMethodName;
		setterMethodName = newSetterMethodName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__SETTER_METHOD_NAME, oldSetterMethodName, setterMethodName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeMetaData getMappedBy() {
		if (mappedBy != null && mappedBy.eIsProxy()) {
			AttributeMetaData oldMappedBy = mappedBy;
			mappedBy = (AttributeMetaData)eResolveProxy((InternalEObject)mappedBy);
			if (mappedBy != oldMappedBy) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY, oldMappedBy, mappedBy));
			}
		}
		return mappedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeMetaData basicGetMappedBy() {
		return mappedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMappedBy(AttributeMetaData newMappedBy, NotificationChain msgs) {
		AttributeMetaData oldMappedBy = mappedBy;
		mappedBy = newMappedBy;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY, oldMappedBy, newMappedBy);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMappedBy(AttributeMetaData newMappedBy) {
		if (newMappedBy != mappedBy) {
			NotificationChain msgs = null;
			if (mappedBy != null)
				msgs = ((InternalEObject)mappedBy).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, AttributeMetaData.class, msgs);
			if (newMappedBy != null)
				msgs = ((InternalEObject)newMappedBy).eInverseAdd(this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, AttributeMetaData.class, msgs);
			msgs = basicSetMappedBy(newMappedBy, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY, newMappedBy, newMappedBy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInverseList() {
		if (inverseList == null) {
			inverseList = new EObjectWithInverseResolvingEList(AttributeMetaData.class, this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY);
		}
		return inverseList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeMetaData getOverrideOf() {
		if (overrideOf != null && overrideOf.eIsProxy()) {
			AttributeMetaData oldOverrideOf = overrideOf;
			overrideOf = (AttributeMetaData)eResolveProxy((InternalEObject)overrideOf);
			if (overrideOf != oldOverrideOf) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF, oldOverrideOf, overrideOf));
			}
		}
		return overrideOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeMetaData basicGetOverrideOf() {
		return overrideOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOverrideOf(AttributeMetaData newOverrideOf, NotificationChain msgs) {
		AttributeMetaData oldOverrideOf = overrideOf;
		overrideOf = newOverrideOf;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF, oldOverrideOf, newOverrideOf);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverrideOf(AttributeMetaData newOverrideOf) {
		if (newOverrideOf != overrideOf) {
			NotificationChain msgs = null;
			if (overrideOf != null)
				msgs = ((InternalEObject)overrideOf).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, AttributeMetaData.class, msgs);
			if (newOverrideOf != null)
				msgs = ((InternalEObject)newOverrideOf).eInverseAdd(this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, AttributeMetaData.class, msgs);
			msgs = basicSetOverrideOf(newOverrideOf, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF, newOverrideOf, newOverrideOf));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOverrideList() {
		if (overrideList == null) {
			overrideList = new EObjectWithInverseResolvingEList(AttributeMetaData.class, this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF);
		}
		return overrideList;
	}

	public boolean isPrimaryKey() {
		return entityMetaData != null
			&& entityMetaData.getPrimaryKeyList().contains(this);
	}

	public boolean isVersion() {
		return entityMetaData != null
			&& entityMetaData.getVersionList().contains(this);
	}

	public boolean isNonPersistent() {
		return entityMetaData == null && embeddedIn == null;
	}

	public void makeNonPersistent() {
		if (entityMetaData != null) {
			entityMetaData.getPrimaryKeyList().remove(this);
			entityMetaData.getVersionList().remove(this);
			setEntityMetaData(null);
		}
		if (embeddedIn != null) {
			setEmbeddedIn(null);
		}
		if (mappedBy != null) {
			setMappedBy(null);
		}
		if (inverseList != null) {
			inverseList.clear();
			inverseList = null;
		}
		if (overrideOf != null) {
			setOverrideOf(null);
		}
		if (overrideList != null) {
			overrideList.clear();
			overrideList = null;
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA:
					if (entityMetaData != null)
						msgs = ((InternalEObject)entityMetaData).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, EntityMetaData.class, msgs);
					return basicSetEntityMetaData((EntityMetaData)otherEnd, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN:
					if (embeddedIn != null)
						msgs = ((InternalEObject)embeddedIn).eInverseRemove(this, MetadataPackage.EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST, EmbeddedAttribute.class, msgs);
					return basicSetEmbeddedIn((EmbeddedAttribute)otherEnd, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
					if (mappedBy != null)
						msgs = ((InternalEObject)mappedBy).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, AttributeMetaData.class, msgs);
					return basicSetMappedBy((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicAdd(otherEnd, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF:
					if (overrideOf != null)
						msgs = ((InternalEObject)overrideOf).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, AttributeMetaData.class, msgs);
					return basicSetOverrideOf((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA:
					return basicSetEntityMetaData(null, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN:
					return basicSetEmbeddedIn(null, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
					return basicSetMappedBy(null, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicRemove(otherEnd, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF:
					return basicSetOverrideOf(null, msgs);
				case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	public boolean isField() {
		return getterMethodName == null;
	}

	public void delete() {
		makeNonPersistent();
		super.delete();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA:
				if (resolve) return getEntityMetaData();
				return basicGetEntityMetaData();
			case MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN:
				if (resolve) return getEmbeddedIn();
				return basicGetEmbeddedIn();
			case MetadataPackage.ATTRIBUTE_META_DATA__NAME:
				return getName();
			case MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE:
				if (resolve) return getJavaType();
				return basicGetJavaType();
			case MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE:
				return new Integer(getFetchType());
			case MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL:
				return isOptional() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.ATTRIBUTE_META_DATA__GETTER_METHOD_NAME:
				return getGetterMethodName();
			case MetadataPackage.ATTRIBUTE_META_DATA__SETTER_METHOD_NAME:
				return getSetterMethodName();
			case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
				if (resolve) return getMappedBy();
				return basicGetMappedBy();
			case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
				return getInverseList();
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF:
				if (resolve) return getOverrideOf();
				return basicGetOverrideOf();
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST:
				return getOverrideList();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__NAME:
				setName((String)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE:
				setJavaType((TypeMetaData)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE:
				setFetchType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL:
				setOptional(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__GETTER_METHOD_NAME:
				setGetterMethodName((String)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__SETTER_METHOD_NAME:
				setSetterMethodName((String)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
				setMappedBy((AttributeMetaData)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
				getInverseList().clear();
				getInverseList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)newValue);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST:
				getOverrideList().clear();
				getOverrideList().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)null);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)null);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__NAME:
				setName(NAME_EDEFAULT);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE:
				setJavaType((TypeMetaData)null);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE:
				setFetchType(FETCH_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL:
				setOptional(OPTIONAL_EDEFAULT);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__GETTER_METHOD_NAME:
				setGetterMethodName(GETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__SETTER_METHOD_NAME:
				setSetterMethodName(SETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
				setMappedBy((AttributeMetaData)null);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
				getInverseList().clear();
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)null);
				return;
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST:
				getOverrideList().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA:
				return entityMetaData != null;
			case MetadataPackage.ATTRIBUTE_META_DATA__EMBEDDED_IN:
				return embeddedIn != null;
			case MetadataPackage.ATTRIBUTE_META_DATA__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case MetadataPackage.ATTRIBUTE_META_DATA__JAVA_TYPE:
				return javaType != null;
			case MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE:
				return fetchType != FETCH_TYPE_EDEFAULT;
			case MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL:
				return optional != OPTIONAL_EDEFAULT;
			case MetadataPackage.ATTRIBUTE_META_DATA__GETTER_METHOD_NAME:
				return GETTER_METHOD_NAME_EDEFAULT == null ? getterMethodName != null : !GETTER_METHOD_NAME_EDEFAULT.equals(getterMethodName);
			case MetadataPackage.ATTRIBUTE_META_DATA__SETTER_METHOD_NAME:
				return SETTER_METHOD_NAME_EDEFAULT == null ? setterMethodName != null : !SETTER_METHOD_NAME_EDEFAULT.equals(setterMethodName);
			case MetadataPackage.ATTRIBUTE_META_DATA__MAPPED_BY:
				return mappedBy != null;
			case MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST:
				return inverseList != null && !inverseList.isEmpty();
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_OF:
				return overrideOf != null;
			case MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST:
				return overrideList != null && !overrideList.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", fetchType: ");
		result.append(fetchType);
		result.append(", optional: ");
		result.append(optional);
		result.append(", getterMethodName: ");
		result.append(getterMethodName);
		result.append(", setterMethodName: ");
		result.append(setterMethodName);
		result.append(')');
		return result.toString();
	}

	public MetadataElement getParentElement() {
		return getEntityMetaData();
	}
	
    public List getColumns() {
    	if (mappedBy == null) {
    		return Collections.EMPTY_LIST;
    	}
        List cols = getMappedBy().getColumns();
		int n = cols.size();
		if (n <= 1) {
			return cols;
		}
		EntityMetaData emd = getEntityMetaData();
		if (emd == null) {
			return cols;
		}
		// put columms that are in our entities table first
		OrmTable table = emd.getTable();
		ArrayList ans = new ArrayList(n);
		for (int i = 0; i < n; i++) {
			OrmColumn c = (OrmColumn)cols.get(i);
			if (c.getTable() == table) {
				ans.add(c);
			}
		}
		for (int i = n-1; i >= 0; i--) {
			OrmColumn c = (OrmColumn)cols.get(i);
			if (c.getTable() != table) {
				ans.add(c);
			}
		}
        return ans;
    }

} // AttributeMetaDataImpl
