/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import java.util.Set;

import org.eclipse.emf.common.util.EList;

/**
 * Meta data for a self-contained set of persistent entities.
 * 
 * @model
 * @generated
 */
public interface EntityModel extends MetadataElement {

	/**
	 * Get all the persistent types known to the model. This list includes
	 * simple types like int, java.lang.Integer, java.lang.String as well as
	 * persistent entities. The list contents are of type
	 * {@link org.eclipse.jsr220orm.metadata.TypeMetaData}. It is bidirectional
	 * and its opposite is '{@link org.eclipse.jsr220orm.metadata.TypeMetaData#getEntityModel <em>Entity Model</em>}'.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.TypeMetaData"
	 *        opposite="entityModel" containment="true"
	 * @generated
	 */
	EList getTypeList();

	/**
	 * Lookup a type by its {@link TypeMetaData#getClassName()}. Returns null
	 * if not found.
	 * 
	 * @model
	 * @generated
	 */
	TypeMetaData findTypeByClassName(String className);

	/**
	 * Lookup an entity by its {@link EntityMetaData#getSchemaName()}. Returns
	 * null if not found.
	 * 
	 * @model
	 * @generated
	 */
	EntityMetaData findEntityBySchemaName(String schemaName);

    Set getTopLevelSqlObjects();

} // EntityModel
