/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.diagram.EditableLabel;
import org.eclipse.jsr220orm.ui.internal.diagram.er.IHelpTextHelper;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.ExtendedDirectEditManager;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.LabelCellEditorLocator;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.TableDirectEditPolicy;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.TableFigure;
import org.eclipse.jsr220orm.ui.internal.diagram.er.model.DotDotDotColumn;
import org.eclipse.jsr220orm.ui.internal.diagram.er.model.TableSectionHeader;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.MetadataEditPart;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class TableEditPart
extends MetadataEditPart {
    private Set colSet;
    private OrmTable table;
    private Schema schema;
    protected DirectEditManager manager;
    private Table rdbTable;
    private Map rdbCols = new HashMap();
    private Map ormCols = new HashMap();
    private List children = new ArrayList();
    private boolean connected;
    private IHelpTextHelper helper;
    static /* synthetic */ Class class$0;

    public TableEditPart(Schema schema, Set colSet, OrmTable table, IHelpTextHelper helper) {
        this.colSet = colSet;
        this.schema = schema;
        this.table = table;
        this.helper = helper;
        this.connected = schema != null;
        this.selectColumns();
        this.setModel(table);
    }

    public void selectColumns() {
        this.ormCols.clear();
        this.children.clear();
        this.children.addAll(this.table.getColumnList());
        DotDotDotColumn lastDotDotDot = null;
        int x = 0;
        while (x < this.children.size()) {
            OrmColumn ormColumn = (OrmColumn)this.children.get(x);
            String name = ormColumn.getName();
            if (name == null) {
                name = "<NULL" + x + ">";
            }
            this.ormCols.put(name.toLowerCase(), ormColumn);
            if (!this.colSet.contains(ormColumn)) {
                this.children.remove(x);
                if (lastDotDotDot == null) {
                    lastDotDotDot = new DotDotDotColumn();
                    this.children.add(x, lastDotDotDot);
                } else {
                    --x;
                }
                lastDotDotDot.add(ormColumn);
            } else {
                lastDotDotDot = null;
            }
            ++x;
        }
        String tableName = this.table.getName();
        this.rdbCols.clear();
        if (tableName != null && this.connected) {
            try {
                EList tables = this.schema.getTables();
                this.connected = !tables.isEmpty();
                for (Table rdbTable : tables) {
                    if (!rdbTable.getName().equalsIgnoreCase(tableName)) continue;
                    boolean foundRdbCols = false;
                    this.rdbTable = rdbTable;
                    EList columns = rdbTable.getColumns();
                    for (Column rdbColumn : columns) {
                        String name = rdbColumn.getName().toLowerCase();
                        this.rdbCols.put(name, rdbColumn);
                        if (this.ormCols.containsKey(name)) continue;
                        if (!foundRdbCols) {
                            foundRdbCols = true;
                            this.helper.addHelpText("<b>Drag and drop</b> unmapped columns onto mapped columns to map them.");
                            this.children.add(new TableSectionHeader("Unmapped columns"));
                        }
                        this.children.add(rdbColumn);
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.connected = false;
                OrmUiPlugin.log((IStatus)new Status(2, OrmUiPlugin.getPluginId(), 0, "Could not load table data.", e));
            }
        }
        if (!this.connected) {
            this.helper.addHelpText("Connect to database using Persistence Properties to map to existing columns");
        }
        if (this.rdbCols != null && !this.rdbCols.isEmpty()) {
            int x2 = 0;
            while (x2 < this.children.size()) {
                OrmColumn ormColumn;
                String name;
                Object object = this.children.get(x2);
                if (object instanceof OrmColumn && !this.rdbCols.containsKey(name = (ormColumn = (OrmColumn)object).getName().toLowerCase())) {
                    this.helper.addHelpText("<span color=\"red\">Red Columns</span> where <b>not</b> found in the database table.");
                    break;
                }
                ++x2;
            }
        }
    }

    protected IFigure createFigure() {
        return new TableFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new TableDirectEditPolicy());
    }

    protected void refreshVisuals() {
        OrmTable node = (OrmTable)this.getModel();
        TableFigure table = (TableFigure)this.getFigure();
        table.setName(node.getName());
        table.setToolTipText(node.getComment());
    }

    protected List getModelChildren() {
        try {
            this.selectColumns();
        }
        catch (Throwable s) {
            s.printStackTrace();
        }
        return this.children;
    }

    public IFigure getContentPane() {
        TableFigure figure = (TableFigure)this.getFigure();
        return figure.getContentPane();
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        TableFigure figure = (TableFigure)this.getFigure();
        if (value != 0) {
            figure.setSelected(true);
        } else {
            figure.setSelected(false);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        return true;
    }

    protected void performDirectEdit() {
        if (this.manager == null) {
            TableFigure figure = (TableFigure)this.getFigure();
            EditableLabel nameLabel = figure.getNameLabel();
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(nameLabel), nameLabel, null);
        }
        this.manager.show();
    }

    public void handleNameChange(String value) {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        tableFigure.setNameVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        TableFigure tableFigure = (TableFigure)this.getFigure();
        tableFigure.setNameVisible(true);
        this.refreshVisuals();
    }

    public Map getOrmCols() {
        return this.ormCols;
    }

    public Map getRdbCols() {
        return this.rdbCols;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void expandDots() {
        ArrayList refreshList = new ArrayList(4);
        for (Object col : this.children) {
            if (!(col instanceof DotDotDotColumn)) continue;
            DotDotDotColumn ddd = (DotDotDotColumn)col;
            List hiddenColumns = ddd.getHiddenColumns();
            this.colSet.addAll(hiddenColumns);
            refreshList.addAll(hiddenColumns);
        }
        ArrayList children = new ArrayList();
        EditPart parent = this.getParent();
        if (parent != null) {
            children.addAll(parent.getChildren());
        } else {
            children.addAll(this.getChildren());
        }
        int x = 0;
        while (x < children.size()) {
            AbstractEditPart child = (AbstractEditPart)children.get(x);
            children.addAll(child.getChildren());
            child.refresh();
            ++x;
        }
    }
}

