/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.util;

import java.math.BigInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.util.JdbcUtils;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.constraints.PrimaryKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.SQLConstraintsPackage;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpressionDefault;
import org.eclipse.wst.rdb.internal.models.sql.expressions.impl.SQLExpressionsFactoryImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesFactory;

public class RdbUtils {
    static /* synthetic */ Class class$0;

    public static DatabaseDefinitionRegistry getDatabaseDefinitionRegistry() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    }

    public static ConnectionInfo[] getRdbConnections() {
        return RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
    }

    public static String getColumnDefinition(DatabaseDefinition dbdef, PredefinedDataTypeDefinition typeDef, String dataTypeName, OrmColumn c) {
        int jdbcType = c.getJdbcType();
        DDLGenerator gen = dbdef.getDDLGenerator();
        if (gen != null && typeDef != null) {
            EStructuralFeature feature;
            Column col = SQLTablesFactory.eINSTANCE.createColumn();
            col.setName(c.getName());
            col.setNullable(c.isNullable());
            PredefinedDataType type = dbdef.getPredefinedDataType(typeDef);
            if (typeDef.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                type.eSet(feature, (Object)new Integer(c.getLength()));
            } else if (typeDef.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                type.eSet(feature, (Object)new Integer(c.getLength()));
            }
            if (typeDef.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                type.eSet(feature, (Object)new Integer(c.getScale()));
            }
            if (c.isIdentity()) {
                DataModelElementFactory factory = dbdef.getDataModelElementFactory();
                IdentitySpecifier identitySpecifier = (IdentitySpecifier)factory.create(SQLSchemaPackage.eINSTANCE.getIdentitySpecifier());
                col.setIdentitySpecifier(identitySpecifier);
            }
            col.setContainedType((SQLDataType)type);
            String[] a = gen.createSQLObjects(new SQLObject[]{col}, false, false, null);
            if (a.length > 0) {
                return a[0];
            }
        }
        String name = c.getName();
        int length = c.getLength();
        int scale = c.getScale();
        boolean nullable = c.isNullable();
        return RdbUtils.getColumnDefinition(typeDef, jdbcType, dataTypeName, name, length, scale, nullable);
    }

    public static String getColumnDefinition(Column rdbColumn) {
        String[] a;
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        DatabaseDefinition dbdef = ddr.getDefinition(rdbColumn.getTable().getSchema().getDatabase());
        DDLGenerator gen = dbdef.getDDLGenerator();
        if (gen != null && (a = gen.createSQLObjects(new SQLObject[]{rdbColumn}, false, false, null)).length > 0) {
            return a[0];
        }
        DataType type = rdbColumn.getDataType();
        PredefinedDataTypeDefinition typeDef = dbdef.getPredefinedDataTypeDefinition(type.getName());
        int jdbcType = typeDef.getJdbcEnumType();
        String dataTypeName = rdbColumn.getDataType().getName();
        String name = rdbColumn.getName();
        int length = RdbUtils.getLength(typeDef, rdbColumn);
        int scale = RdbUtils.getScale(typeDef, rdbColumn);
        boolean nullable = rdbColumn.isNullable();
        return RdbUtils.getColumnDefinition(typeDef, jdbcType, dataTypeName, name, length, scale, nullable);
    }

    public static int getScale(PredefinedDataTypeDefinition typeDef, Column rdbColumn) {
        EStructuralFeature feature;
        Integer scale;
        if (typeDef.isScaleSupported() && (scale = (Integer)rdbColumn.eGet(feature = rdbColumn.eClass().getEStructuralFeature("scale"))) != null) {
            return scale;
        }
        return 0;
    }

    public static int getLength(PredefinedDataTypeDefinition typeDef, Column rdbColumn) {
        EStructuralFeature feature;
        Integer precision;
        DataType type = rdbColumn.getDataType();
        if (typeDef.isLengthSupported()) {
            EStructuralFeature feature2 = type.eClass().getEStructuralFeature("length");
            Integer length = (Integer)type.eGet(feature2);
            if (length != null) {
                return length;
            }
        } else if (typeDef.isPrecisionSupported() && (precision = (Integer)type.eGet(feature = type.eClass().getEStructuralFeature("precision"))) != null) {
            return precision;
        }
        return 0;
    }

    public static String getColumnDefinition(PredefinedDataTypeDefinition typeDef, int jdbcType, String dataTypeName, String name, int length, int scale, boolean nullable) {
        StringBuffer s = new StringBuffer();
        s.append(name);
        s.append(' ');
        if (dataTypeName == null) {
            s.append(JdbcUtils.getJdbcTypeName(jdbcType));
        } else {
            s.append(dataTypeName);
        }
        if (length > 0 && (typeDef == null || RdbUtils.isLengthSupported(typeDef))) {
            s.append('(');
            s.append(length);
            if ((typeDef == null || RdbUtils.isScaleSupported(typeDef, jdbcType)) && scale != 0) {
                s.append(',');
                s.append(scale);
            }
            s.append(')');
        }
        if ((typeDef == null || typeDef.isNullableSupported()) && !nullable) {
            s.append(" NOT NULL");
        }
        return s.toString();
    }

    public static void setColumnDefinition(OrmColumn ormColumn, Column rdbColumn) {
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        DatabaseDefinition dbdef = ddr.getDefinition(rdbColumn.getTable().getSchema().getDatabase());
        DataType type = rdbColumn.getDataType();
        PredefinedDataTypeDefinition typeDef = dbdef.getPredefinedDataTypeDefinition(type.getName());
        ormColumn.setName(rdbColumn.getName());
        ormColumn.setComment(rdbColumn.getDescription());
        ormColumn.setDatabaseType(rdbColumn.getDataType().getName());
        ormColumn.setJdbcType(typeDef.getJdbcEnumType());
        ormColumn.setNullable(rdbColumn.isNullable());
        ormColumn.setLength(RdbUtils.getLength(typeDef, rdbColumn));
        ormColumn.setScale(RdbUtils.getScale(typeDef, rdbColumn));
        ormColumn.setColumnDefinition(RdbUtils.getColumnDefinition(rdbColumn));
    }

    public static boolean isLengthSupported(PredefinedDataTypeDefinition typeDef) {
        if (typeDef != null) {
            return typeDef.isLengthSupported() || typeDef.isPrecisionSupported();
        }
        return true;
    }

    public static boolean isScaleSupported(PredefinedDataTypeDefinition typeDef, int jdbcType) {
        if (typeDef != null) {
            return typeDef.isScaleSupported();
        }
        switch (jdbcType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static String getColumnTypeDescr(Column c) {
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        DatabaseDefinition dbdef = ddr.getDefinition(c.getTable().getSchema().getDatabase());
        DataType type = c.getDataType();
        PredefinedDataTypeDefinition typeDef = dbdef.getPredefinedDataTypeDefinition(type.getName());
        StringBuffer s = new StringBuffer();
        s.append(type.getName());
        if (RdbUtils.isLengthSupported(typeDef)) {
            int length = RdbUtils.getLength(typeDef, c);
            s.append('(');
            s.append(length);
            if (RdbUtils.isScaleSupported(typeDef, typeDef.getJdbcEnumType())) {
                int scale = RdbUtils.getScale(typeDef, c);
                s.append(',');
                s.append(scale);
            }
            s.append(')');
        }
        return s.toString();
    }

    public static void copyToOrm(final OrmColumn ormColumn, final Column rdbColumn) {
        IEntityModelManager manager = (IEntityModelManager)ormColumn.adapt(IEntityModelManager.class);
        if (manager != null) {
            manager.executeModelChanges(new Runnable(){

                public void run() {
                    RdbUtils.copyToOrmImpl(ormColumn, rdbColumn);
                }
            });
        } else {
            RdbUtils.copyToOrmImpl(ormColumn, rdbColumn);
        }
    }

    private static void copyToOrmImpl(OrmColumn ormColumn, Column rdbColumn) {
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        DatabaseDefinition dbdef = ddr.getDefinition(rdbColumn.getTable().getSchema().getDatabase());
        DataType type = rdbColumn.getDataType();
        PredefinedDataTypeDefinition typeDef = dbdef.getPredefinedDataTypeDefinition(type.getName());
        ormColumn.setName(rdbColumn.getName());
        ormColumn.setComment(rdbColumn.getDescription());
        ormColumn.setDatabaseType(rdbColumn.getDataType().getName());
        ormColumn.setJdbcType(typeDef.getJdbcEnumType());
        ormColumn.setNullable(rdbColumn.isNullable());
        ormColumn.setLength(RdbUtils.getLength(typeDef, rdbColumn));
        ormColumn.setScale(RdbUtils.getScale(typeDef, rdbColumn));
        ormColumn.setColumnDefinition(RdbUtils.getColumnDefinition(rdbColumn));
    }

    public static void copyToRdb(OrmColumn ormColumn, Column rdbColumn, DatabaseDefinition dbdef) {
        ormColumn.getJdbcType();
        rdbColumn.setName(ormColumn.getName());
        rdbColumn.setDescription(ormColumn.getComment());
        ValueExpressionDefault expression = SQLExpressionsFactoryImpl.eINSTANCE.createValueExpressionDefault();
        expression.setSQL(ormColumn.getColumnDefinition());
        rdbColumn.setNullable(ormColumn.isNullable());
        IEntityModelManager emm = (IEntityModelManager)ormColumn.adapt(IEntityModelManager.class);
        PredefinedDataTypeDefinition typeDef = emm.getColumnDataTypeDefinition(ormColumn);
        if (typeDef != null && dbdef != null) {
            EStructuralFeature feature;
            PredefinedDataType type = dbdef.getPredefinedDataType(typeDef);
            if (typeDef.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                type.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            } else if (typeDef.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                type.eSet(feature, (Object)new Integer(ormColumn.getLength()));
            }
            if (typeDef.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                type.eSet(feature, (Object)new Integer(ormColumn.getScale()));
            }
            rdbColumn.setContainedType((SQLDataType)type);
        }
        if (ormColumn.isIdentity()) {
            DataModelElementFactory factory = dbdef.getDataModelElementFactory();
            IdentitySpecifier identitySpecifier = (IdentitySpecifier)factory.create(SQLSchemaPackage.eINSTANCE.getIdentitySpecifier());
            identitySpecifier.setStartValue(new BigInteger("0"));
            identitySpecifier.setIncrement(new BigInteger("1"));
            rdbColumn.setIdentitySpecifier(identitySpecifier);
        }
    }

    public static void copyToRdb(OrmTable ormTable, BaseTable table, DatabaseDefinition dbDef) {
        EList pkList = ormTable.getPrimaryKeyList();
        if (!pkList.isEmpty()) {
            DataModelElementFactory factory = dbDef.getDataModelElementFactory();
            EClass primaryKeyClass = SQLConstraintsPackage.eINSTANCE.getPrimaryKey();
            PrimaryKey pk = (PrimaryKey)factory.create(primaryKeyClass);
            pk.setName(String.valueOf(ormTable.getName()) + "_pk");
            block0: for (OrmColumn ormColumn : pkList) {
                if (ormColumn.isIdentity() && dbDef.getProduct().toUpperCase().startsWith("MYSQL")) {
                    return;
                }
                String colName = ormColumn.getName();
                for (Column column : table.getColumns()) {
                    if (!column.getName().equals(colName)) continue;
                    pk.getMembers().add((Object)column);
                    continue block0;
                }
            }
            table.getConstraints().add((Object)pk);
        }
    }
}

