/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.nature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jsr220orm.core.internal.product.OrmProductRegistry;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.nature.OrmNatureEvent;
import org.eclipse.jsr220orm.core.nature.OrmNatureListener;

public class OrmNatureUtils {
    private static final QualifiedName PERSISTENCE_PROPS = new QualifiedName("OrmPersistence", "persistence_props");
    private static List natureListeners = new ArrayList(5);

    static Properties getProperties(IProject project, boolean forceRefresh) throws CoreException, IOException {
        Properties properties;
        if (project == null || !project.isOpen()) {
            return new Properties();
        }
        if (!project.isSynchronized(1)) {
            project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((properties = (Properties)project.getSessionProperty(PERSISTENCE_PROPS)) == null) {
            properties = new Properties();
            project.setSessionProperty(PERSISTENCE_PROPS, (Object)properties);
        } else if (!forceRefresh) {
            return properties;
        }
        IFile persistProps = project.getFile(".persistence");
        if (persistProps.exists()) {
            InputStream in = persistProps.getContents(true);
            try {
                properties.load(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        } else {
            File file = persistProps.getLocation().toFile();
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                try {
                    properties.load(in);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    static void setProperties(IProject project, Properties properties) throws IOException, CoreException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        properties.store(out, "Properties of the Persistence nature for eclipse project: " + project.getName());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        IFile persistProps = project.getFile(".persistence");
        if (persistProps.exists()) {
            if (persistProps.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{persistProps}, null);
            }
            persistProps.setContents((InputStream)inputStream, 1, null);
        } else {
            persistProps.create((InputStream)inputStream, 1, null);
        }
    }

    public static OrmNature setActiveProduct(IProject project, String prodKey) throws Exception {
        Properties properties = OrmNatureUtils.getProperties(project, true);
        if (prodKey != null) {
            OrmProductRegistry ormProductRegistry = OrmProductRegistry.INSTANCE;
            if (!ormProductRegistry.containtsProductKey(prodKey)) {
                throw new Exception("No Persistence plugin found for product key: " + prodKey);
            }
            properties.setProperty("jsr220.orm.active.product", prodKey);
            OrmNatureUtils.setProperties(project, properties);
            if (project.hasNature("org.eclipse.jsr220orm.core.nature")) {
                OrmNature nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
                nature.loadActiveProject();
                return nature;
            }
            OrmNatureUtils.addOrmNature(project);
            return (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
        }
        properties.remove("jsr220.orm.active.product");
        OrmNatureUtils.setProperties(project, properties);
        if (project.hasNature("org.eclipse.jsr220orm.core.nature")) {
            OrmNatureUtils.removeOrmNature(project);
        }
        return null;
    }

    private static void addOrmNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.jsr220orm.core.nature";
        description.setNatureIds(newNatures);
        IStatus status = project.getWorkspace().validateNatureSet(natures);
        if (status.getCode() != 0) {
            throw new CoreException(status);
        }
        project.setDescription(description, null);
    }

    private static void removeOrmNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String id = "org.eclipse.jsr220orm.core.nature";
        boolean hasNature = project.hasNature(id);
        if (!hasNature) {
            return;
        }
        OrmNature nature = (OrmNature)project.getNature(id);
        String[] newNatures = new String[natures.length - 1];
        int i = 0;
        int x = 0;
        while (i < natures.length && x < newNatures.length) {
            if (!natures[i].equals(id)) {
                newNatures[x++] = natures[i];
            }
            ++i;
        }
        description.setNatureIds(newNatures);
        IStatus status = project.getWorkspace().validateNatureSet(natures);
        if (status.getCode() != 0) {
            throw new CoreException(status);
        }
        project.setDescription(description, null);
        if (nature != null) {
            nature.closeProject();
            nature.fireNatureRemoved();
        }
    }

    public static void addOrmNatureListener(OrmNatureListener listener) {
        natureListeners.add(listener);
    }

    public static void removeOrmNatureListener(OrmNatureListener listener) {
        natureListeners.remove(listener);
    }

    public static void fireNatureRemoved(OrmNature nature) {
        OrmNatureListener[] listeners = new OrmNatureListener[natureListeners.size()];
        natureListeners.toArray(listeners);
        OrmNatureEvent ormNatureEvent = new OrmNatureEvent(nature, null);
        int x = listeners.length - 1;
        while (x >= 0) {
            listeners[x].ormNatureRemoved(ormNatureEvent);
            --x;
        }
    }

    public static void fireProjectActivated(OrmNature nature, OrmProject activeProject) {
        OrmNatureListener[] listeners = new OrmNatureListener[natureListeners.size()];
        natureListeners.toArray(listeners);
        OrmNatureEvent ormNatureEvent = new OrmNatureEvent(nature, activeProject);
        int x = listeners.length - 1;
        while (x >= 0) {
            listeners[x].projectActivated(ormNatureEvent);
            --x;
        }
    }

    public static void fireProjectDeactivated(OrmNature nature, OrmProject activeProject) {
        OrmNatureListener[] listeners = new OrmNatureListener[natureListeners.size()];
        natureListeners.toArray(listeners);
        OrmNatureEvent ormNatureEvent = new OrmNatureEvent(nature, activeProject);
        int x = listeners.length - 1;
        while (x >= 0) {
            listeners[x].projectDeactivated(ormNatureEvent);
            --x;
        }
    }
}

