/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

public class ReferenceAttributeIO
extends AttributeIO {
    protected ReferenceAttribute amd;
    public static final IntOption MAPPING_MANY_TO_ONE = new IntOption(1, "Many to one", "Foreign key in table for entity", Utils.getImage("ManyToOne16"));
    public static final IntOption MAPPING_ONE_TO_ONE = new IntOption(2, "One to one", "Unique foreign key in table for entity", Utils.getImage("OneToOne16"));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ReferenceAttributeIO(EntityIO entityIO) {
        super(entityIO);
    }

    public AttributeMetaData getAttributeMetaData() {
        return this.amd;
    }

    public void getPossibleMappings(List ans) {
        ans.add(MAPPING_MANY_TO_ONE);
        ans.add(MAPPING_ONE_TO_ONE);
        ans.add(MAPPING_NOT_PERSISTENT);
    }

    public IntOption getMapping() {
        if (this.amd == null || this.amd.isNonPersistent()) {
            return MAPPING_NOT_PERSISTENT;
        }
        if (this.amd.isOneToOne()) {
            return MAPPING_ONE_TO_ONE;
        }
        return MAPPING_MANY_TO_ONE;
    }

    public void setMapping(IntOption mapping) {
        if (MAPPING_NOT_PERSISTENT.equals((Object)mapping)) {
            this.setPersistent(false);
        } else {
            this.setPersistent(true);
            boolean oneToOne = MAPPING_ONE_TO_ONE.equals((Object)mapping);
            this.amd.setOneToOne(oneToOne);
            if (!oneToOne) {
                this.amd.setMappedBy(null);
            }
        }
    }

    public boolean updateModelFromMetaData(RClass cls, RAnnotatedElement attribute, boolean metaDataChanged) {
        this.amd = (ReferenceAttribute)this.initAttributeMetaData((AttributeMetaData)this.amd, attribute, MetadataPackage.eINSTANCE.getReferenceAttribute());
        if (this.amd.isNonPersistent()) {
            return true;
        }
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        if (!emd.isEntity()) {
            this.updateModelCleanup();
            this.entityIO.addProblem(String.valueOf(this.getTypeName(emd)) + " classes " + "may only have basic attributes", attribute.getLocation());
            return true;
        }
        TypeMetaData tmd = this.amd.getJavaType();
        if (!(tmd instanceof EntityMetaData)) {
            this.updateModelCleanup();
            this.addNullJavaTypeProblem(attribute);
            return true;
        }
        EntityMetaData target = (EntityMetaData)tmd;
        if (target.getEntityType() != 1) {
            this.updateModelCleanup();
            this.entityIO.addProblem(String.valueOf(target.getShortName()) + " is " + this.getTypeName(target) + " so it may not be the " + "target of a persistent relationship", attribute.getLocation());
            this.entityIO.addDependencyOn(target);
            return true;
        }
        if (!this.hasTableAndPrimaryKey(target)) {
            return false;
        }
        target.getTable().getPrimaryKeyList();
        this.entityIO.addDependencyOn(target);
        GenericEntityModelManager mm = this.entityIO.getModelManager();
        OneToOne oneToOne = attribute.getAnnotation(OneToOne.class);
        ManyToOne manyToOne = attribute.getAnnotation(ManyToOne.class);
        boolean usingMappedBy = false;
        this.amd.setOneToOne(oneToOne != null);
        if (oneToOne != null) {
            this.setFetchType((AttributeMetaData)this.amd, oneToOne.fetch());
            this.amd.setOptional(oneToOne.optional());
            if (manyToOne != null) {
                this.entityIO.addProblem("ManyToOne and OneToOne may not be used together", ((AnnotationEx)manyToOne).getLocation(null));
            }
            this.amd.setCascadeType(this.getCascadeBits(oneToOne.cascade()));
            usingMappedBy = this.updateModelMappedBy(oneToOne, target);
        } else {
            if (manyToOne == null) {
                manyToOne = mm.getAnnotationRegistry().getDefaultProxy(ManyToOne.class);
            }
            this.setFetchType((AttributeMetaData)this.amd, manyToOne.fetch());
            this.amd.setOptional(manyToOne.optional());
            this.amd.setMappedBy(null);
            this.amd.setCascadeType(this.getCascadeBits(manyToOne.cascade()));
        }
        if (usingMappedBy) {
            this.deleteJoinAndSrcCols();
        } else {
            AnnotationEx jcs = (AnnotationEx)attribute.getAnnotation(JoinColumns.class);
            AnnotationEx jc = (AnnotationEx)attribute.getAnnotation(JoinColumn.class);
            Join join = this.entityIO.getJoinIO().updateModelJoin(this.amd.getJoin(), jc, jcs == null ? null : (Object[])jcs.get("value"), jcs == null ? null : jcs.getLocation(null), metaDataChanged, emd.getTable(), target.getTable(), mm.getReferenceCNS(this.amd), this.getComment((AttributeMetaData)this.amd), this.amd.isOptional(), this.getRelativePosition(attribute));
            if (this.amd.getJoin() != join) {
                this.amd.setJoin(join);
            }
        }
        return true;
    }

    protected void updateModelCleanup() {
        this.deleteJoinAndSrcCols();
        this.amd.setMappedBy(null);
    }

    protected void deleteJoinAndSrcCols() {
        if (Utils.deleteJoinAndSrcCols(this.amd.getJoin())) {
            this.amd.setJoin(null);
        }
    }

    protected boolean updateModelMappedBy(OneToOne oneToOne, EntityMetaData target) {
        String mappedBy = oneToOne.mappedBy();
        AttributeMetaData mb = null;
        boolean usingMappedBy = mappedBy.length() > 0;
        if (usingMappedBy) {
            mb = this.getMappedByAttribute((AnnotationEx)oneToOne, mappedBy, target);
            if (mb instanceof ReferenceAttribute) {
                ReferenceAttribute ra = (ReferenceAttribute)mb;
                if (ra.getJavaType() != this.entityIO.getEntityMetaData()) {
                    this.entityIO.addProblem("Attribute '" + mappedBy + "' has incorrect type: " + ra.getJavaType().getClassName(), ((AnnotationEx)oneToOne).getLocation("mappedBy"));
                    mb = null;
                }
            } else if (mb != null) {
                this.entityIO.addProblem("Attribute '" + mappedBy + "' is not a reference", ((AnnotationEx)oneToOne).getLocation("mappedBy"));
                mb = null;
            }
        }
        this.amd.setMappedBy(mb);
        return usingMappedBy;
    }

    public void updateMetaDataFromModel(RClass cls, RAnnotatedElement attribute) {
        AttributeMetaData mb;
        AnnotationEx toDelete;
        GenericEntityModelManager mm = this.getModelManager();
        if (this.amd.isNonPersistent()) {
            Utils.removeAnnotation(attribute, OneToOne.class);
            Utils.removeAnnotation(attribute, ManyToOne.class);
            Utils.removeAnnotation(attribute, JoinColumn.class);
            Utils.removeAnnotation(attribute, JoinColumns.class);
            this.ensureTransient(attribute);
            return;
        }
        Utils.removeAnnotation(attribute, Transient.class);
        if (this.amd.getJavaType() == null) {
            return;
        }
        AnnotationEx main = (AnnotationEx)attribute.getAnnotation(this.amd.isOneToOne() ? OneToOne.class : ManyToOne.class, true);
        if (main.getValueCount() == 0 && (toDelete = (AnnotationEx)attribute.getAnnotation(this.amd.isOneToOne() ? ManyToOne.class : OneToOne.class)) != null) {
            toDelete.delete();
        }
        main.set("mappedBy", (mb = this.amd.getMappedBy()) == null ? null : mb.getName());
        if (mb == null) {
            main.setMarker(this.amd.isOneToOne() || mm.isUseMarkerAnnotations());
        }
        Utils.setIfNotNull(main, "fetch", this.getFetchType((AttributeMetaData)this.amd));
        main.set("optional", this.amd.isOptional());
        main.set("cascade", this.getCascadeTypes(this.amd.getCascadeType()));
        Join join = this.amd.getJoin();
        if (join == null) {
            return;
        }
        if (join.getPairList().size() == 1) {
            Utils.removeAnnotation(attribute, JoinColumns.class);
            AnnotationEx jc = (AnnotationEx)attribute.getAnnotation(JoinColumn.class, true);
            this.entityIO.getJoinIO().updateMetaDataJoinColumn(jc, join, (JoinPair)join.getPairList().get(0), mm.getReferenceCNS(this.amd), this.amd.isOptional());
        } else {
            Utils.removeAnnotation(attribute, JoinColumn.class);
            EList pairList = join.getPairList();
            AnnotationEx joinColumns = (AnnotationEx)attribute.getAnnotation(JoinColumns.class, true);
            int n = pairList.size();
            if (joinColumns.setArraySize("value", n)) {
                JoinColumn[] a = ((JoinColumns)joinColumns).value();
                int i = 0;
                while (i < n) {
                    this.entityIO.getJoinIO().updateMetaDataJoinColumn((AnnotationEx)a[i], join, (JoinPair)pairList.get(i), mm.getReferenceCNS(this.amd), this.amd.isOptional());
                    ++i;
                }
            }
        }
    }

    public List getValidMappedByAttributes() {
        TypeMetaData tmd = this.amd.getJavaType();
        if (!(tmd instanceof EntityMetaData) || !this.amd.isOneToOne()) {
            return Collections.EMPTY_LIST;
        }
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        EntityMetaData target = (EntityMetaData)tmd;
        ArrayList<AttributeMetaData> ans = new ArrayList<AttributeMetaData>();
        for (AttributeMetaData a : target.getAttributeList()) {
            if (a.getMappedBy() != null || !(a instanceof ReferenceAttribute) || a.getJavaType() != emd) continue;
            ans.add(a);
        }
        return ans;
    }
}

