/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.AttributeOverrideMap;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.io.OverrideAttributeIO;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;

public class EmbeddedAttributeIO
extends AttributeIO {
    protected EmbeddedAttribute amd;
    public static final IntOption MAPPING_EMBEDDED = new IntOption(1, "Embedded", "Attributes of referenced class in table for entity", Utils.getImage("Embedded16"));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public EmbeddedAttributeIO(EntityIO entityIO) {
        super(entityIO);
    }

    public AttributeMetaData getAttributeMetaData() {
        return this.amd;
    }

    public void getPossibleMappings(List ans) {
        ans.add(MAPPING_EMBEDDED);
        ans.add(MAPPING_NOT_PERSISTENT);
    }

    public IntOption getMapping() {
        if (this.amd == null || this.amd.isNonPersistent()) {
            return MAPPING_NOT_PERSISTENT;
        }
        return MAPPING_EMBEDDED;
    }

    public void setMapping(IntOption mapping) {
        this.setPersistent(MAPPING_EMBEDDED.equals((Object)mapping));
    }

    public boolean updateModelFromMetaData(RClass cls, RAnnotatedElement attribute, boolean metaDataChanged) {
        this.amd = (EmbeddedAttribute)this.initAttributeMetaData((AttributeMetaData)this.amd, attribute, MetadataPackage.eINSTANCE.getEmbeddedAttribute());
        if (this.amd.isNonPersistent()) {
            return true;
        }
        this.entityIO.getModelManager();
        this.entityIO.getEntityMetaData();
        if (this.amd.getJavaType() == null) {
            this.updateModelCleanup();
            this.addNullJavaTypeProblem(attribute);
            return true;
        }
        EntityMetaData target = (EntityMetaData)this.amd.getJavaType();
        if (!this.hasBasicAttributes(target)) {
            return false;
        }
        this.entityIO.addDependencyOn(target);
        HashMap<AttributeMetaData, AttributeMetaData> found = new HashMap<AttributeMetaData, AttributeMetaData>();
        EList attrList = this.amd.getAttributeList();
        int i = attrList.size() - 1;
        while (i >= 0) {
            AttributeMetaData a = (AttributeMetaData)attrList.get(i);
            AttributeMetaData overrideOf = a.getOverrideOf();
            if (overrideOf == null) {
                AttributeIO aio = AttributeIO.get(a);
                if (aio != null) {
                    aio.dispose();
                }
                a.delete();
                continue;
            }
            found.put(overrideOf, a);
            --i;
        }
        AttributeOverrideMap map = new AttributeOverrideMap(attribute, this.entityIO);
        int pos = this.getRelativePosition(attribute);
        for (AttributeMetaData overrideOf : target.getAttributeList()) {
            OverrideAttributeIO aio;
            AttributeMetaData a = (AttributeMetaData)found.get(overrideOf);
            if (a == null) {
                if (!(overrideOf instanceof BasicAttribute)) continue;
                aio = new OverrideAttributeIO(this.entityIO, this.amd);
            } else {
                aio = (OverrideAttributeIO)AttributeIO.get(a);
            }
            String name = overrideOf.getName();
            AttributeOverride attrOverride = map.get(name);
            if (attrOverride != null) {
                map.remove(name);
            }
            aio.updateModelFromMetaData(cls, overrideOf, attrOverride, metaDataChanged, pos++);
        }
        for (AttributeOverride override : map.values()) {
            this.entityIO.addProblem("AttributeOverride does not match any embedded attributes: " + override.name(), (Annotation)override);
        }
        return true;
    }

    protected void updateModelCleanup() {
        EList attrList = this.amd.getAttributeList();
        int i = attrList.size() - 1;
        while (i >= 0) {
            AttributeMetaData a = (AttributeMetaData)attrList.get(i);
            a.delete();
        }
    }

    protected boolean hasBasicAttributes(EntityMetaData target) {
        return target != null && target.getTable() != null && EntityIO.get(target).getModelUpdateStatus() >= 2;
    }

    public void updateMetaDataFromModel(RClass cls, RAnnotatedElement attribute) {
        boolean nonPersistent = this.amd.isNonPersistent();
        if (nonPersistent) {
            Utils.removeAnnotation(attribute, Embedded.class);
            Utils.removeAnnotation(attribute, AttributeOverride.class);
            Utils.removeAnnotation(attribute, AttributeOverrides.class);
            this.ensureTransient(attribute);
            return;
        }
        Utils.removeAnnotation(attribute, Transient.class);
        if (this.amd.getJavaType() == null) {
            return;
        }
        AttributeOverrideMap map = new AttributeOverrideMap(attribute, null);
        AttributeOverride extra = null;
        for (AttributeMetaData a : this.amd.getAttributeList()) {
            OverrideAttributeIO aio = (OverrideAttributeIO)AttributeIO.get(a);
            String name = a.getName();
            AttributeOverride override = map.get(name);
            if (override == null) {
                if (extra == null) {
                    extra = map.append();
                }
                override = extra;
            }
            if (!aio.updateMetaDataFromModel(override) || override != extra || !((AnnotationEx)extra).hasValue("column")) continue;
            ((AnnotationEx)extra).set("name", name);
            extra = null;
        }
        map.cleanupAfterMetaDataUpdates();
    }
}

