/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.internal.ui.config;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionStatusValidator {
    private String[] extentions;
    private boolean acceptFolders;
    private static final IStatus ERROR_STATUS = new Status(4, GenericPlugin.getPluginId(), 4, "", null);
    private static final IStatus OK_STATUS = new Status(0, GenericPlugin.getPluginId(), 0, "", null);

    public FileSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FileSelectionDialog.this.isValid(element);
            }
        });
        this.setValidator(this);
    }

    private boolean isValid(Object obj) {
        if (obj instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)obj).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.isValid(resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                GenericPlugin.log(e.getStatus());
            }
        } else if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            String fileName = file.getName();
            int detIndex = fileName.lastIndexOf(46);
            String ext = fileName.substring(detIndex + 1);
            int x = 0;
            while (x < this.extentions.length) {
                if (this.extentions[x].equalsIgnoreCase(ext)) {
                    return true;
                }
                ++x;
            }
        }
        return false;
    }

    public void setValidExtentions(String ... extentions) {
        this.extentions = extentions;
    }

    private boolean isValid(IFile file) {
        String name = file.getName();
        int detIndex = name.lastIndexOf(46);
        String ext = name.substring(detIndex + 1);
        int x = 0;
        while (x < this.extentions.length) {
            if (this.extentions[x].equalsIgnoreCase(ext)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public IStatus validate(Object[] selection) {
        int cfr_ignored_0 = selection.length;
        int i = 0;
        while (i < selection.length) {
            Object curr = selection[i];
            if (curr instanceof IContainer) {
                IContainer cfr_ignored_1 = (IContainer)curr;
                if (!this.acceptFolders) {
                    return ERROR_STATUS;
                }
            } else if (curr instanceof IFile) {
                IFile file = (IFile)curr;
                String fileName = file.getName();
                int detIndex = fileName.lastIndexOf(46);
                String ext = fileName.substring(detIndex + 1);
                int x = 0;
                while (x < this.extentions.length) {
                    if (this.extentions[x].equalsIgnoreCase(ext)) {
                        return OK_STATUS;
                    }
                    ++x;
                }
                return ERROR_STATUS;
            }
            ++i;
        }
        return OK_STATUS;
    }
}

