/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jsr220Orm.generic.xml.VendorDefinitionDocument;
import org.eclipse.jsr220orm.core.util.JdbcUtils;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationRegistry;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VendorDef {
    protected static final String VENDOR_DEFINITION_XML_NAMESPACE = "http://jsr220orm.eclipse.org/generic/xml";
    protected String name;
    protected Map<Integer, JdbcTypeInfo> jdbcTypeMap;
    protected VendorDefinitionDocument.VendorDefinition vd;

    public void init(String vendorDefResouce, GenericEntityModelManager mm) throws XmlException, IOException {
        String namespace = mm.getNature().getActiveOrmProject().getProduct().getNamespace();
        VendorDefinitionDocument doc = Utils.loadVendorDefinition(namespace, vendorDefResouce);
        this.vd = doc.getVendorDefinition();
        this.name = this.vd.getName();
        AnnotationRegistry reg = mm.getAnnotationRegistry();
        DatabaseDefinition dbdef = mm.getDatabaseDefinition();
        String dbProduct = dbdef.getProduct();
        String dbVersion = dbdef.getVersion();
        VendorDefinitionDocument.VendorDefinition.JdbcTypeMap match = null;
        int i = 0;
        while (i < this.vd.sizeOfJdbcTypeMapArray()) {
            VendorDefinitionDocument.VendorDefinition.JdbcTypeMap map = this.vd.getJdbcTypeMapArray(i);
            String database = map.getDatabase();
            if (database.equals(dbProduct)) {
                if (match == null) {
                    match = map;
                }
                if (dbVersion.equals(map.getVersion())) {
                    match = map;
                    break;
                }
            }
            ++i;
        }
        if (match == null) {
            match = this.vd.getJdbcTypeMapArray(0);
        }
        this.jdbcTypeMap = new HashMap<Integer, JdbcTypeInfo>();
        i = 0;
        while (i < match.sizeOfJdbcTypeArray()) {
            VendorDefinitionDocument.VendorDefinition.JdbcTypeMap.JdbcType t = match.getJdbcTypeArray(i);
            int jdbcType = JdbcUtils.getJdbcTypeValue((String)t.getJdbc());
            JdbcTypeInfo info = this.findPredefinedDataTypeDefinition(dbdef, jdbcType, t.getSql());
            if (info != null) {
                this.jdbcTypeMap.put(jdbcType, info);
            }
            ++i;
        }
        Map<Integer, Integer> fallbackMap = this.createJdbcTypeFallbackMap(this.vd, reg);
        ArrayList<String> failed = new ArrayList<String>();
        Set<Integer> ignore = this.createJdbcTypeIgnoreSet();
        int[] allTypes = mm.getAllJdbcTypeInts();
        int i2 = allTypes.length - 1;
        while (i2 >= 0) {
            int jdbcType = allTypes[i2];
            if (!this.jdbcTypeMap.containsKey(jdbcType)) {
                JdbcTypeInfo info = null;
                int t = jdbcType;
                while (fallbackMap.containsKey(t)) {
                    info = this.jdbcTypeMap.get(t = fallbackMap.get(t).intValue());
                    if (info == null) continue;
                    this.jdbcTypeMap.put(jdbcType, info);
                    break;
                }
                if (info == null && !ignore.contains(jdbcType)) {
                    failed.add(JdbcUtils.getJdbcTypeName((int)jdbcType));
                }
            }
            --i2;
        }
        if (!failed.isEmpty()) {
            String msg = "JDBC types for vendor " + this.name + " on " + dbProduct + " " + dbVersion + " are unmapped: " + failed;
            System.out.println(msg);
        }
    }

    protected Set<Integer> createJdbcTypeIgnoreSet() {
        int[] nArray = new int[8];
        nArray[0] = 2003;
        nArray[1] = 70;
        nArray[2] = 2001;
        nArray[3] = 2000;
        nArray[5] = 1111;
        nArray[6] = 2006;
        nArray[7] = 2002;
        int[] a = nArray;
        HashSet<Integer> ignore = new HashSet<Integer>();
        int i = a.length - 1;
        while (i >= 0) {
            ignore.add(a[i]);
            --i;
        }
        return ignore;
    }

    protected Map<Integer, Integer> createJdbcTypeFallbackMap(VendorDefinitionDocument.VendorDefinition vd, AnnotationRegistry reg) {
        HashMap<Integer, Integer> ans = new HashMap<Integer, Integer>();
        int n = vd.sizeOfJdbcTypeFallbackArray();
        int i = 0;
        while (i < n) {
            VendorDefinitionDocument.VendorDefinition.JdbcTypeFallback f = vd.getJdbcTypeFallbackArray(i);
            int jdbcType = JdbcUtils.getJdbcTypeValue((String)f.getJdbc());
            int alt = JdbcUtils.getJdbcTypeValue((String)f.getAlt());
            ans.put(jdbcType, alt);
            ++i;
        }
        return ans;
    }

    protected JdbcTypeInfo findPredefinedDataTypeDefinition(DatabaseDefinition dbdef, int jdbcType, String sqlType) {
        List tl = dbdef.getPredefinedDataTypeDefinitionsByJDBCEnumType(jdbcType);
        if (tl.isEmpty()) {
            return null;
        }
        JdbcTypeInfo info = new JdbcTypeInfo();
        info.jdbcType = jdbcType;
        info.dataTypeDef = (PredefinedDataTypeDefinition)tl.get(0);
        info.dataTypeName = (String)info.dataTypeDef.getName().get(0);
        block0: for (PredefinedDataTypeDefinition dt : tl) {
            EList nl = dt.getName();
            for (String n : nl) {
                if (sqlType.equals(n)) {
                    info.dataTypeDef = dt;
                    info.dataTypeName = n;
                    return info;
                }
                if (!n.startsWith(sqlType)) continue;
                info.dataTypeDef = dt;
                info.dataTypeName = n;
                continue block0;
            }
        }
        return info;
    }

    public JdbcTypeInfo getJdbcTypeInfo(int jdbcType) {
        return this.jdbcTypeMap.get(jdbcType);
    }

    public boolean isNumericType(int jdbcType) {
        switch (jdbcType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public VendorDefinitionDocument.VendorDefinition.SimpleType[] getSimpleTypes() {
        return this.vd.getSimpleTypeArray();
    }

    public VendorDefinitionDocument.VendorDefinition.CollectionType[] getCollectionTypes() {
        return this.vd.getCollectionTypeArray();
    }

    public void initCleanup() {
        this.vd = null;
    }

    public static class JdbcTypeInfo {
        public int jdbcType;
        public PredefinedDataTypeDefinition dataTypeDef;
        public String dataTypeName;

        public String toString() {
            return "JdbcTypeInfo " + this.jdbcType + " " + this.dataTypeName;
        }

        public boolean isLengthSupported() {
            if (this.dataTypeDef != null) {
                return this.dataTypeDef.isLengthSupported() || this.dataTypeDef.isPrecisionSupported();
            }
            return true;
        }

        public boolean isScaleSupported() {
            if (this.dataTypeDef != null) {
                return this.dataTypeDef.isScaleSupported();
            }
            switch (this.jdbcType) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNullableSupported() {
            if (this.dataTypeDef != null) {
                return this.dataTypeDef.isNullableSupported();
            }
            return true;
        }
    }
}

