/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.Generator;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.IIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaSequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableGeneratorModelAdapter;
import org.eclipse.dali.orm.impl.GeneratorImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaIdMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IIdMappingModelAdapter {
    private JavaGeneratorModelAdapter generatorModelAdapter;
    public static final String ANNOTATION_NAME = "Id";
    public static final String GENERATED_VALUE_ANNOTATION = "GeneratedValue";
    public static final String TABLE_GENERATOR_ANNOTATION = "TableGenerator";
    public static final String SEQUENCE_GENERATOR_ANNOTATION = "SequenceGenerator";

    public IColumnModelAdapter createColumnModelAdapter() {
        return new JavaColumnModelAdapter(this.buildColumnOwner());
    }

    private IColumnModelAdapter.ColumnOwner buildColumnOwner() {
        return new IColumnModelAdapter.ColumnOwner(){

            public Table getTableNamed(String tableName) {
                return this.getTypeMapping().getResolvedDBTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return JavaIdMappingModelAdapter.this.getIdMapping().getTypeMapping();
            }

            public ITextRange getTextRange() {
                return JavaIdMappingModelAdapter.this.getAttributeMapping().getTextRange();
            }
        };
    }

    public IGeneratedValueModelAdapter createGeneratedValueModelAdapter() {
        return new JavaGeneratedValueModelAdapter(this);
    }

    private void initializeGeneratorModelAdapter() {
        this.generatorModelAdapter = this.buildGeneratorModelAdapter();
        if (this.generatorModelAdapter != null) {
            Generator generator = this.generatorModelAdapter.buildGenerator();
            ((GeneratorImpl)generator).setSpecifiedNameGen("");
            this.getIdMapping().setGenerator(generator);
        }
    }

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return OrmFactory.eINSTANCE.createIdMapping(this);
    }

    protected void initialize() {
        super.initialize();
        this.initializeGeneratorModelAdapter();
    }

    public void specifiedGeneratorNameChanged() {
        this.getGeneratedValueModelAdapter().specifiedGeneratorNameChanged();
    }

    public void strategyChanged() {
        this.generatorChanged();
    }

    public void generatorChanged() {
        this.updateJavaGenerator();
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersGeneratedValue(astRoot);
        this.updatePersGenerator(astRoot);
        this.updatePersColumn(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        super.postUpdatePersModel(astRoot);
        this.getColumnModelAdapter().postUpdatePersModel(astRoot);
    }

    void updatePersGenerator(CompilationUnit astRoot) {
        GenerationType persGenerationType = this.getGenerationType();
        if (persGenerationType.getValue() == 4 || persGenerationType.getValue() == 2) {
            this.getGeneratorModelAdapter().updatePersModel(astRoot);
        } else {
            this.generatorModelAdapter = null;
        }
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.getColumnModelAdapter().updatePersModel(astRoot);
    }

    private void updatePersGeneratedValue(CompilationUnit astRoot) {
        this.getGeneratedValueModelAdapter().updatePersModel(astRoot);
    }

    private JavaGeneratedValueModelAdapter getGeneratedValueModelAdapter() {
        return (JavaGeneratedValueModelAdapter)this.getIdMapping().getGeneratedValue().getModelAdapter();
    }

    private JavaGeneratorModelAdapter getGeneratorModelAdapter() {
        if (this.generatorModelAdapter == null) {
            this.initializeGeneratorModelAdapter();
        }
        return this.generatorModelAdapter;
    }

    private JavaGeneratorModelAdapter buildGeneratorModelAdapter() {
        GenerationType persGenerationType = this.getGenerationType();
        if (persGenerationType.getValue() == 4) {
            return new JavaTableGeneratorModelAdapter(this.getAttribute());
        }
        if (persGenerationType.getValue() == 2) {
            return new JavaSequenceGeneratorModelAdapter(this.getAttribute());
        }
        return null;
    }

    private void updateJavaGenerator() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        GenerationType persGenerationType = this.getGenerationType();
        this.initializeGeneratorModelAdapter();
        if (persGenerationType.getValue() == 4) {
            this.removeSequenceAnnotation(astRoot);
            if (!this.containsAnnotation(TABLE_GENERATOR_ANNOTATION, astRoot)) {
                this.addMappingAnnotation(TABLE_GENERATOR_ANNOTATION);
            }
        } else if (persGenerationType.getValue() == 2) {
            this.removeTableAnnotation(astRoot);
            if (!this.containsAnnotation(SEQUENCE_GENERATOR_ANNOTATION, astRoot)) {
                this.addMappingAnnotation(SEQUENCE_GENERATOR_ANNOTATION);
            }
        } else {
            this.removeTableAnnotation(astRoot);
            this.removeSequenceAnnotation(astRoot);
            this.generatorModelAdapter = null;
        }
    }

    private void removeTableAnnotation(CompilationUnit astRoot) {
        if (this.containsAnnotation(TABLE_GENERATOR_ANNOTATION, astRoot)) {
            this.removeAnnotation(TABLE_GENERATOR_ANNOTATION);
        }
    }

    private void removeSequenceAnnotation(CompilationUnit astRoot) {
        if (this.containsAnnotation(SEQUENCE_GENERATOR_ANNOTATION, astRoot)) {
            this.removeAnnotation(SEQUENCE_GENERATOR_ANNOTATION);
        }
    }

    private GenerationType getGenerationType() {
        return this.getIdMapping().getGeneratedValue().getStrategy();
    }

    private IdMapping getIdMapping() {
        return (IdMapping)this.getAttributeMapping();
    }

    private JavaColumnModelAdapter getColumnModelAdapter() {
        return (JavaColumnModelAdapter)this.getIdMapping().getColumn().getModelAdapter();
    }

    public String attributeMappingName() {
        return ANNOTATION_NAME;
    }
}

