/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.NullConnection;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;

public final class ConnectionRepository {
    private ConnectionManager rdbConnectionManager = RDBCorePlugin.getDefault().getConnectionManager();
    private ConnectionManagerListener connectionManagerListener;
    private Set connections;
    private static ConnectionRepository INSTANCE;

    public static ConnectionRepository instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionRepository();
        }
        return INSTANCE;
    }

    private ConnectionRepository() {
    }

    private Set getConnections() {
        if (this.connections == null) {
            this.connections = this.buildConnections();
        }
        return this.connections;
    }

    private Set buildConnections() {
        ConnectionInfo[] infos = this.rdbConnectionManager.getAllNamedConnectionInfo();
        HashSet<Connection> result = new HashSet<Connection>(infos.length);
        int i = infos.length;
        while (i-- > 0) {
            result.add(Connection.createConnection(infos[i]));
        }
        return result;
    }

    public Iterator connections() {
        return this.getConnections().iterator();
    }

    public Iterator connectionNames() {
        return new TransformationIterator(this.connections()){

            protected Object transform(Object next) {
                return ((Connection)next).getName();
            }
        };
    }

    public Connection connectionNamed(String name) {
        Iterator stream = this.connections();
        while (stream.hasNext()) {
            Connection connection = (Connection)stream.next();
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        return NullConnection.instance();
    }

    void addConnection(ConnectionInfo info) {
        this.getConnections().add(Connection.createConnection(info));
    }

    void removeConnection(String name) {
        this.getConnections().remove(this.connectionNamed(name));
    }

    void initializeListeners() {
        this.connectionManagerListener = new LocalConnectionManagerListener();
        this.addListener(this.connectionManagerListener);
    }

    void disposeListeners() {
        this.removeListener(this.connectionManagerListener);
        this.connectionManagerListener = null;
    }

    void addListener(ConnectionManagerListener listener) {
        this.rdbConnectionManager.addListener(listener);
    }

    void removeListener(ConnectionManagerListener listener) {
        this.rdbConnectionManager.removeListener(listener);
    }

    private class LocalConnectionManagerListener
    implements ConnectionManagerListener {
        private LocalConnectionManagerListener() {
        }

        public void connectionInfoCreated(ConnectionInfo info) {
            ConnectionRepository.this.addConnection(info);
        }

        public void connectionInfoRemoved(String name) {
            ConnectionRepository.this.removeConnection(name);
        }

        public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
        }

        public void connected(ConnectionInfo info, java.sql.Connection connection) {
        }

        public void disconnected(ConnectionInfo info, java.sql.Connection connection) {
        }
    }
}

