/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.SequenceGenerator;
import org.eclipse.dali.orm.provider.GeneratorItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.GeneratorComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SequenceGeneratorComposite
extends GeneratorComposite
implements IPersistenceComposite {
    Group sequenceGeneratorGroup;
    private Combo sequenceNameCombo;
    private ModifyListener sequenceNameComboListener;
    static /* synthetic */ Class class$0;

    public SequenceGeneratorComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected GeneratorItemProvider createGeneratorItemProvider(OrmItemProviderAdapterFactory adapterFactory) {
        return (GeneratorItemProvider)adapterFactory.createSequenceGeneratorAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.sequenceGeneratorGroup = new Group((Composite)this, 16);
        this.sequenceGeneratorGroup.setText(DaliUiMessages.SequenceGeneratorComposite_sequenceGenerator);
        this.sequenceGeneratorGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sequenceGeneratorGroup.setLayoutData((Object)gridData);
        Label sequenceGeneratorLabel = new Label((Composite)this.sequenceGeneratorGroup, 16384);
        sequenceGeneratorLabel.setText(DaliUiMessages.SequenceGeneratorComposite_name);
        this.nameViewer = this.buildNameViewer((Composite)this.sequenceGeneratorGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameViewer.getTextWidget().setLayoutData((Object)gridData);
        Label sequenceNameLabel = new Label((Composite)this.sequenceGeneratorGroup, 16384);
        sequenceNameLabel.setText(DaliUiMessages.SequenceGeneratorComposite_sequence);
        this.sequenceNameCombo = this.buildSequenceNameCombo((Composite)this.sequenceGeneratorGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sequenceNameCombo.setLayoutData((Object)gridData);
    }

    private Combo buildSequenceNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.add("");
        combo.select(0);
        combo.addModifyListener(this.getSequenceNameListener());
        return combo;
    }

    private ModifyListener getSequenceNameListener() {
        if (this.sequenceNameComboListener == null) {
            this.sequenceNameComboListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (SequenceGeneratorComposite.this.populating) {
                        return;
                    }
                    String text = ((Combo)e.getSource()).getText();
                    if (text != null && SequenceGeneratorComposite.this.sequenceNameCombo.getItemCount() > 0 && text.equals(SequenceGeneratorComposite.this.sequenceNameCombo.getItem(0))) {
                        text = null;
                    }
                    SequenceGeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)SequenceGeneratorComposite.this.editingDomain, (Object)SequenceGeneratorComposite.this.getGenerator(), (Object)OrmPackage.eINSTANCE.getSequenceGenerator_SpecifiedSequenceName(), (Object)text));
                }
            };
        }
        return this.sequenceNameComboListener;
    }

    protected void generatorChanged(Notification notification) {
        super.generatorChanged(notification);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.SequenceGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 9) {
            final String sequenceName = notification.getNewStringValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (sequenceName == null) {
                        SequenceGeneratorComposite.this.sequenceNameCombo.select(0);
                    } else if (!SequenceGeneratorComposite.this.sequenceNameCombo.getText().equals(sequenceName)) {
                        SequenceGeneratorComposite.this.sequenceNameCombo.setText(sequenceName);
                    }
                }
            });
        }
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (model == null) {
            this.populating = false;
            return;
        }
        this.populateSequenceNameCombo();
        this.populating = false;
    }

    private void populateSequenceNameCombo() {
        String sequenceName;
        this.populating = true;
        if (this.getGenerator() == null) {
            return;
        }
        PersistenceProject persistenceProject = this.getGenerator().getPersistenceProject();
        Connection connectionInfo = persistenceProject.getConnectionInfo();
        this.sequenceNameCombo.setItem(0, DaliUiMessages.SequenceGeneratorComposite_default);
        if (connectionInfo.isConnected()) {
            this.sequenceNameCombo.remove(1, this.sequenceNameCombo.getItemCount() - 1);
            Iterator stream = CollectionTools.sort((Iterator)connectionInfo.getDatabase().schemaNamed(persistenceProject.getSchemaName()).sequenceNames());
            while (stream.hasNext()) {
                this.sequenceNameCombo.add((String)stream.next());
            }
        }
        if ((sequenceName = this.getSequenceGenerator().getSpecifiedSequenceName()) != null) {
            if (!this.sequenceNameCombo.getText().equals(sequenceName)) {
                this.sequenceNameCombo.setText(sequenceName);
            }
        } else {
            this.sequenceNameCombo.select(0);
        }
        this.populating = false;
    }

    protected SequenceGenerator getSequenceGenerator() {
        return (SequenceGenerator)this.getGenerator();
    }

    protected void clear() {
        super.clear();
        this.sequenceNameCombo.select(0);
    }
}

