/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.Generator;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.IIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaSequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableGeneratorModelAdapter;
import org.eclipse.dali.orm.impl.GeneratorImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaIdMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IIdMappingModelAdapter {
    private JavaGeneratorModelAdapter generatorModelAdapter;

    public IColumnModelAdapter createColumnModelAdapter() {
        return new JavaColumnModelAdapter();
    }

    public IGeneratedValueModelAdapter createGeneratedValueModelAdapter() {
        return new JavaGeneratedValueModelAdapter(this);
    }

    private void initializeGeneratorModelAdapter() {
        this.generatorModelAdapter = this.buildGeneratorModelAdapter();
        if (this.generatorModelAdapter != null) {
            Generator generator = this.generatorModelAdapter.buildGenerator();
            ((GeneratorImpl)generator).setSpecifiedNameGen("");
            this.getIdMapping().setGenerator(generator);
        }
    }

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return OrmFactory.eINSTANCE.createIdMapping(this);
    }

    protected void initialize() {
        super.initialize();
        this.initializeGeneratorModelAdapter();
    }

    public void specifiedGeneratorNameChanged() {
        this.getGeneratedValueModelAdapter().specifiedGeneratorNameChanged();
    }

    public void strategyChanged() {
        this.generatorChanged();
    }

    public void generatorChanged() {
        this.updateJavaGenerator();
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.postUpdatePersModel(astRoot);
    }

    private void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersGeneratedValue(astRoot);
        this.updatePersGenerator(astRoot);
        this.updatePersColumn(astRoot);
    }

    void updatePersGenerator(CompilationUnit astRoot) {
        GenerationType persGenerationType = this.getGenerationType();
        if (persGenerationType.getValue() == 4 || persGenerationType.getValue() == 2) {
            this.getGeneratorModelAdapter().updatePersModel(astRoot);
        } else {
            this.generatorModelAdapter = null;
        }
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.getColumnModelAdapter().updatePersModel(astRoot);
    }

    private void updatePersGeneratedValue(CompilationUnit astRoot) {
        this.getGeneratedValueModelAdapter().updatePersModel(astRoot);
    }

    private JavaGeneratedValueModelAdapter getGeneratedValueModelAdapter() {
        return (JavaGeneratedValueModelAdapter)this.getIdMapping().getGeneratedValue().getModelAdapter();
    }

    private JavaGeneratorModelAdapter getGeneratorModelAdapter() {
        if (this.generatorModelAdapter == null) {
            this.initializeGeneratorModelAdapter();
        }
        return this.generatorModelAdapter;
    }

    private JavaGeneratorModelAdapter buildGeneratorModelAdapter() {
        GenerationType persGenerationType = this.getGenerationType();
        if (persGenerationType.getValue() == 4) {
            return new JavaTableGeneratorModelAdapter();
        }
        if (persGenerationType.getValue() == 2) {
            return new JavaSequenceGeneratorModelAdapter();
        }
        return null;
    }

    private void updateJavaGenerator() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        GenerationType persGenerationType = this.getGenerationType();
        this.initializeGeneratorModelAdapter();
        if (persGenerationType.getValue() == 4) {
            this.removeSequenceAnnotation(astRoot);
            if (!this.containsAnnotation("TableGenerator", astRoot)) {
                this.addMappingAnnotation("TableGenerator");
            }
        } else if (persGenerationType.getValue() == 2) {
            this.removeTableAnnotation(astRoot);
            if (!this.containsAnnotation("SequenceGenerator", astRoot)) {
                this.addMappingAnnotation("SequenceGenerator");
            }
        } else {
            this.removeTableAnnotation(astRoot);
            this.removeSequenceAnnotation(astRoot);
            this.generatorModelAdapter = null;
        }
    }

    private void removeTableAnnotation(CompilationUnit astRoot) {
        if (this.containsAnnotation("TableGenerator", astRoot)) {
            this.removeAnnotation("TableGenerator");
        }
    }

    private void removeSequenceAnnotation(CompilationUnit astRoot) {
        if (this.containsAnnotation("SequenceGenerator", astRoot)) {
            this.removeAnnotation("SequenceGenerator");
        }
    }

    private GenerationType getGenerationType() {
        return this.getIdMapping().getGeneratedValue().getStrategy();
    }

    private IdMapping getIdMapping() {
        return (IdMapping)this.getAttributeMapping();
    }

    private JavaColumnModelAdapter getColumnModelAdapter() {
        return (JavaColumnModelAdapter)this.getIdMapping().getColumn().getModelAdapter();
    }

    public String attributeMappingName() {
        return "Id";
    }
}

