/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IEmbeddableModelAdapter;
import org.eclipse.dali.orm.adapters.java.IJavaTypeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaEmbeddableModelAdapter
implements IEmbeddableModelAdapter,
IJavaTypeMappingModelAdapter {
    private Embeddable embeddable;
    private Type type;

    public JavaEmbeddableModelAdapter(Type type) {
        this.type = type;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.embeddable = (Embeddable)typeMapping;
    }

    public void engage(CompilationUnit astRoot) {
        this.updatePersModel(astRoot);
    }

    public void disengage() {
        this.embeddable = null;
    }

    public void addAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        if (!this.type.containsAnnotation("Embeddable", astRoot)) {
            this.type.addAnnotation("Embeddable", astRoot);
        }
    }

    public void removeAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        if (this.type.containsAnnotation("Embeddable", astRoot)) {
            this.type.removeAnnotation("Embeddable", astRoot);
        }
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    public ITextRange getTextRange() {
        return this.type.getTextRange(this.getEmbeddable().getAnnotationName());
    }

    private void updatePersModel(CompilationUnit astRoot) {
    }

    public void synchWithJavaDelta(IJavaElementDelta delta, CompilationUnit astRoot) {
        if ((delta.getFlags() & 1) != 0) {
            this.updatePersModel(astRoot);
        }
    }
}

