/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility.iterators;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.SingleElementIterator;

public class GraphIterator
implements Iterator {
    private Collection iterators;
    private Set visitedNeighbors;
    private MisterRogers misterRogers;
    private Iterator currentIterator;
    private static final Iterator END_ITERATOR = NullIterator.instance();
    private Object nextNeighbor;
    private static final Object END_NEIGHBOR = new Object();

    public GraphIterator(Iterator roots) {
        this(roots, MisterRogers.NULL_INSTANCE);
    }

    public GraphIterator(Object root) {
        this(root, MisterRogers.NULL_INSTANCE);
    }

    public GraphIterator(Object root, MisterRogers misterRogers) {
        this(new SingleElementIterator(root), misterRogers);
    }

    public GraphIterator(Iterator roots, MisterRogers misterRogers) {
        this.currentIterator = roots;
        this.iterators = new LinkedList();
        this.misterRogers = misterRogers;
        this.visitedNeighbors = new HashSet();
        this.loadNextNeighbor();
    }

    private void loadNextNeighbor() {
        if (this.currentIterator == END_ITERATOR) {
            this.nextNeighbor = END_NEIGHBOR;
        } else if (this.currentIterator.hasNext()) {
            Object nextPossibleNeighbor = this.currentIterator.next();
            if (this.visitedNeighbors.contains(nextPossibleNeighbor)) {
                this.loadNextNeighbor();
            } else {
                this.nextNeighbor = nextPossibleNeighbor;
                this.visitedNeighbors.add(nextPossibleNeighbor);
                this.iterators.add(this.neighbors(nextPossibleNeighbor));
            }
        } else {
            Iterator stream = this.iterators.iterator();
            while (!this.currentIterator.hasNext() && stream.hasNext()) {
                this.currentIterator = (Iterator)stream.next();
                stream.remove();
            }
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = END_ITERATOR;
            }
            this.loadNextNeighbor();
        }
    }

    public boolean hasNext() {
        return this.nextNeighbor != END_NEIGHBOR;
    }

    public Object next() {
        if (this.nextNeighbor == END_NEIGHBOR) {
            throw new NoSuchElementException();
        }
        Object next = this.nextNeighbor;
        this.loadNextNeighbor();
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    protected Iterator neighbors(Object next) {
        return this.misterRogers.neighbors(next);
    }

    public String toString() {
        return String.valueOf(ClassTools.shortClassNameForObject(this)) + '(' + this.currentIterator + ')';
    }

    public static interface MisterRogers {
        public static final MisterRogers NULL_INSTANCE = new MisterRogers(){

            public Iterator neighbors(Object next) {
                return NullIterator.instance();
            }

            public String toString() {
                return String.valueOf(super.toString()) + "(Hello, neighbor.)";
            }
        };

        public Iterator neighbors(Object var1);
    }
}

