/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.util.jdt;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class ASTTools {
    public static StringLiteral newStringLiteral(AST ast, String literalValue) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(literalValue);
        return stringLiteral;
    }

    public static NormalAnnotation newNormalAnnotation(AST ast, String annotationName) {
        NormalAnnotation annotation = ast.newNormalAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(annotationName));
        return annotation;
    }

    public static MarkerAnnotation newMarkerAnnotation(AST ast, String annotationName) {
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(annotationName));
        return annotation;
    }

    public static SingleMemberAnnotation newSingleMemberAnnotation(AST ast, String annotationName) {
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(annotationName));
        return annotation;
    }

    public static boolean containsAnyAnnotation(BodyDeclaration bodyDeclaration, String[] annotationNames) {
        Iterator stream = bodyDeclaration.modifiers().iterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = (IExtendedModifier)stream.next();
            if (!modifier.isAnnotation() || !CollectionTools.contains((Object[])annotationNames, (Object)((Annotation)modifier).getTypeName().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static Annotation getAnnotation(BodyDeclaration bodyDeclaration, String annotationName) {
        Iterator stream = bodyDeclaration.modifiers().iterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = (IExtendedModifier)stream.next();
            if (!modifier.isAnnotation() || !((Annotation)modifier).getTypeName().getFullyQualifiedName().equals(annotationName)) continue;
            return (Annotation)modifier;
        }
        return null;
    }

    public static void addValuePair(NormalAnnotation annotation, MemberValuePair valuePair) {
        List list = (List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
        list.add(valuePair);
    }

    public static void addLiteralMemberValuePair(NormalAnnotation annotation, String name, String value) {
        AST ast = annotation.getAST();
        List list = (List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
        MemberValuePair newValuePair = ast.newMemberValuePair();
        newValuePair.setName(ast.newSimpleName(name));
        newValuePair.setValue((Expression)ASTTools.newStringLiteral(ast, value));
        list.add(newValuePair);
    }

    public static void addAnnotation(BodyDeclaration bodyDeclaration, String annotationName) {
        ASTTools.addAnnotation(bodyDeclaration, (Annotation)ASTTools.newMarkerAnnotation(bodyDeclaration.getAST(), annotationName));
    }

    public static void addAnnotation(BodyDeclaration bodyDeclaration, Annotation annotation) {
        List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
        list.add(ASTTools.annotationLocation(bodyDeclaration), annotation);
    }

    public static void removeAnnotation(BodyDeclaration bodyDeclaration, String annotationName) {
        ASTTools.removeAnnotation(bodyDeclaration, ASTTools.getAnnotation(bodyDeclaration, annotationName));
    }

    public static void removeAnnotation(BodyDeclaration bodyDeclaration, Annotation annotation) {
        List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
        list.remove(annotation);
    }

    public static void removeAnnotationElement(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        AST ast = bodyDeclaration.getAST();
        Annotation annotation = ASTTools.getAnnotation(bodyDeclaration, annotationName);
        MemberValuePair valuePairToRemove = ASTTools.getMemberValuePair(annotation, elementName);
        if (valuePairToRemove != null) {
            if (((NormalAnnotation)annotation).values().size() == 1) {
                MarkerAnnotation newAnnotation = ASTTools.newMarkerAnnotation(ast, annotationName);
                List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
                int index = list.indexOf(annotation);
                list.set(index, newAnnotation);
            } else {
                ASTTools.removeValuePair((NormalAnnotation)annotation, valuePairToRemove);
            }
        }
    }

    public static void removeValuePair(NormalAnnotation annotation, MemberValuePair valuePair) {
        List list = (List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
        list.remove(valuePair);
    }

    public static void replaceAnnotation(BodyDeclaration bodyDeclaration, Annotation oldAnnotation, Annotation newAnnotation) {
        List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
        int index = list.indexOf(oldAnnotation);
        list.set(index, newAnnotation);
    }

    public static MemberValuePair getMemberValuePair(BodyDeclaration bodyDeclaration, String annotationName, String name) {
        return ASTTools.getMemberValuePair(ASTTools.getAnnotation(bodyDeclaration, annotationName), name);
    }

    public static MemberValuePair getMemberValuePair(Annotation annotation, String elementName) {
        if (annotation != null && annotation.isNormalAnnotation()) {
            return ASTTools.getMemberValuePair((NormalAnnotation)annotation, elementName);
        }
        return null;
    }

    public static MemberValuePair getMemberValuePair(NormalAnnotation annotation, String elementName) {
        Iterator stream = annotation.values().iterator();
        while (stream.hasNext()) {
            MemberValuePair valuePair = (MemberValuePair)stream.next();
            if (!valuePair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return valuePair;
        }
        return null;
    }

    public static boolean containsAnnotationElement(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        return ASTTools.getMemberValuePair(bodyDeclaration, annotationName, elementName) != null;
    }

    public static String getAnnotationElementStringValue(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        MemberValuePair valuePair = ASTTools.getMemberValuePair(bodyDeclaration, annotationName, elementName);
        if (valuePair != null) {
            return ASTTools.stringValue(valuePair);
        }
        return null;
    }

    public static String stringValue(MemberValuePair valuePair) {
        if (valuePair.getValue().getNodeType() == 45) {
            return ((StringLiteral)valuePair.getValue()).getLiteralValue();
        }
        return null;
    }

    public static ITextRange getTextRange(final ASTNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException("Cannot get the ITextRange of a null ASTNode");
        }
        return new ITextRange(){

            public int getLineNumber() {
                return ((CompilationUnit)astNode.getRoot()).lineNumber(this.getOffset());
            }

            public int getOffset() {
                return astNode.getStartPosition();
            }

            public int getLength() {
                return astNode.getLength();
            }
        };
    }

    public static int annotationLocation(BodyDeclaration bodyDeclaration) {
        int count = 0;
        ListIterator i = bodyDeclaration.modifiers().listIterator();
        while (i.hasNext()) {
            IExtendedModifier modifier = (IExtendedModifier)i.next();
            if (modifier.isModifier()) break;
            ++count;
        }
        return count;
    }
}

