/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.List;
import org.eclipse.dali.core.CascadeType;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.FetchType;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.NonOwningMapping;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.adapters.INonOwningMappingModelAdapter;
import org.eclipse.dali.core.impl.RelationshipMappingImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public abstract class NonOwningMappingImpl
extends RelationshipMappingImpl
implements NonOwningMapping {
    protected static final String MAPPED_BY_EDEFAULT = null;
    protected String mappedBy = MAPPED_BY_EDEFAULT;

    protected NonOwningMappingImpl() {
    }

    protected NonOwningMappingImpl(INonOwningMappingModelAdapter adapter) {
        super(adapter);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getNonOwningMapping();
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedByGen(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldMappedBy, (Object)this.mappedBy));
        }
    }

    public void setMappedBy(String newMappedBy) {
        this.setMappedByGen(newMappedBy);
        ((INonOwningMappingModelAdapter)this.getModelAdapter()).mappedByChanged();
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getFetchType();
            }
            case 1: {
                return this.getCascadeType();
            }
            case 2: {
                return this.getDefaultTargetEntity();
            }
            case 3: {
                return this.getSpecifiedTargetEntity();
            }
            case 4: {
                return this.getTargetEntity();
            }
            case 5: {
                return this.getResolvedTargetEntity();
            }
            case 6: {
                return this.getMappedBy();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setFetchType((FetchType)((Object)newValue));
                return;
            }
            case 1: {
                this.setCascadeType((CascadeType)((Object)newValue));
                return;
            }
            case 2: {
                this.setDefaultTargetEntity((String)newValue);
                return;
            }
            case 3: {
                this.setSpecifiedTargetEntity((String)newValue);
                return;
            }
            case 6: {
                this.setMappedBy((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setFetchType(FETCH_TYPE_EDEFAULT);
                return;
            }
            case 1: {
                this.setCascadeType(CASCADE_TYPE_EDEFAULT);
                return;
            }
            case 2: {
                this.setDefaultTargetEntity(DEFAULT_TARGET_ENTITY_EDEFAULT);
                return;
            }
            case 3: {
                this.setSpecifiedTargetEntity(SPECIFIED_TARGET_ENTITY_EDEFAULT);
                return;
            }
            case 6: {
                this.setMappedBy(MAPPED_BY_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.fetchType != FETCH_TYPE_EDEFAULT;
            }
            case 1: {
                return this.cascadeType != CASCADE_TYPE_EDEFAULT;
            }
            case 2: {
                return DEFAULT_TARGET_ENTITY_EDEFAULT == null ? this.defaultTargetEntity != null : !DEFAULT_TARGET_ENTITY_EDEFAULT.equals(this.defaultTargetEntity);
            }
            case 3: {
                return SPECIFIED_TARGET_ENTITY_EDEFAULT == null ? this.specifiedTargetEntity != null : !SPECIFIED_TARGET_ENTITY_EDEFAULT.equals(this.specifiedTargetEntity);
            }
            case 4: {
                return "" == null ? this.getTargetEntity() != null : !"".equals(this.getTargetEntity());
            }
            case 5: {
                return this.getResolvedTargetEntity() != null;
            }
            case 6: {
                return MAPPED_BY_EDEFAULT == null ? this.mappedBy != null : !MAPPED_BY_EDEFAULT.equals(this.mappedBy);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappedBy: ");
        result.append(this.mappedBy);
        result.append(')');
        return result.toString();
    }

    protected PersistentAttribute getMappedByPersistentAttribute() {
        String targetEntity;
        String mappedBy = this.getMappedBy();
        if (mappedBy != null && (targetEntity = this.getFullyQualifiedTargetEntity()) != null) {
            return this.getPersistenceFile().resolvePersistentAttribute(targetEntity, mappedBy);
        }
        return null;
    }

    protected ITextRange mappedByTextRange() {
        ITextRange textRange = ((INonOwningMappingModelAdapter)this.getModelAdapter()).mappedByTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addMappedByDoesNotExistProblemTo(problems);
        this.addMappedByInvalidMappingTypeProblemTo(problems);
    }

    private void addMappedByDoesNotExistProblemTo(List problems) {
        if (this.getMappedBy() == null) {
            return;
        }
        PersistentAttribute mappedByPersistentAttribute = this.getMappedByPersistentAttribute();
        if (mappedByPersistentAttribute == null) {
            problems.add(this.buildProblem("MappedBy specified for " + this.getPersistentAttribute().getName() + " does not exist on the target entity class", this.mappedByTextRange()));
        }
    }

    private void addMappedByInvalidMappingTypeProblemTo(List problems) {
        PersistentAttribute mappedByPersistentAttribute = this.getMappedByPersistentAttribute();
        if (mappedByPersistentAttribute == null) {
            return;
        }
        if (mappedByPersistentAttribute.getAttributeMapping().isPossibleRelationshipOwner()) {
            return;
        }
        problems.add(this.buildProblem("MappedBy specified on " + this.getPersistentAttribute().getName() + " is not a valid mapping type", this.mappedByTextRange()));
    }
}

