/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.JoinTable;
import org.eclipse.dali.core.MultiRelationshipMapping;
import org.eclipse.dali.core.RelationshipMapping;
import org.eclipse.dali.core.Table;
import org.eclipse.dali.core.adapters.IJoinTableModelAdapter;
import org.eclipse.dali.core.adapters.java.AbstractJavaJoinColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaInverseJoinColumnInJoinTableModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaJoinColumnInJoinTableModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;

public class JavaJoinTableModelAdapter
extends JavaTableModelAdapter
implements IJoinTableModelAdapter {
    static final String JOIN_TABLE_ANNOTATION = "JoinTable";
    static final String JOIN_COLUMNS_MEMBER = "joinColumns";
    static final String INVERSE_JOIN_COLUMNS_MEMBER = "inverseJoinColumns";
    private JavaJoinColumnInJoinTableModelAdapter joinColumnModelAdapter = new JavaJoinColumnInJoinTableModelAdapter(this.buildJoinColumnOwner());
    private JavaInverseJoinColumnInJoinTableModelAdapter inverseJoinColumnModelAdapter = new JavaInverseJoinColumnInJoinTableModelAdapter(this.buildJoinColumnOwner());

    JavaJoinTableModelAdapter() {
    }

    private AbstractJavaJoinColumnModelAdapter.JoinColumnOwner buildJoinColumnOwner() {
        return new AbstractJavaJoinColumnModelAdapter.JoinColumnOwner(){

            public RelationshipMapping relationshipMapping() {
                return (MultiRelationshipMapping)JavaJoinTableModelAdapter.this.getJoinTable().getParent();
            }
        };
    }

    public void engage(Table table, CompilationUnit astRoot) {
        if (!(table instanceof JoinTable)) {
            throw new IllegalArgumentException();
        }
        Attribute attribute = ((JavaAttributeMappingModelAdapter)((MultiRelationshipMapping)table.getParent()).getModelAdapter()).getAttribute();
        JoinColumn column = this.joinColumnModelAdapter.buildJoinColumn(attribute);
        ((JoinTable)table).getJoinColumns().add((Object)column);
        JoinColumn inverseJoinColumn = this.inverseJoinColumnModelAdapter.buildJoinColumn(attribute);
        ((JoinTable)table).getInverseJoinColumns().add((Object)inverseJoinColumn);
        super.engage(table, astRoot);
    }

    void updatePersModel(CompilationUnit astRoot) {
        super.updatePersModel(astRoot);
        this.updatePersDefaultJoinColumns(astRoot);
        this.updatePersDefaultInverseJoingColumns(astRoot);
        this.joinColumnModelAdapter.updatePersModel(astRoot);
        this.inverseJoinColumnModelAdapter.updatePersModel(astRoot);
    }

    private void updatePersDefaultJoinColumns(CompilationUnit astRoot) {
        MemberValuePair memberValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, JOIN_COLUMNS_MEMBER, astRoot);
        if (memberValuePair == null) {
            if (!this.getJoinTable().isDefaultJoinColumns()) {
                this.getJoinTable().setDefaultJoinColumns(true);
            }
        } else if (this.getJoinTable().isDefaultJoinColumns()) {
            this.getJoinTable().setDefaultJoinColumns(false);
        }
    }

    private void updatePersDefaultInverseJoingColumns(CompilationUnit astRoot) {
        MemberValuePair memberValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, INVERSE_JOIN_COLUMNS_MEMBER, astRoot);
        if (memberValuePair == null) {
            if (!this.getJoinTable().isDefaultInverseJoinColumns()) {
                this.getJoinTable().setDefaultInverseJoinColumns(true);
            }
        } else if (this.getJoinTable().isDefaultInverseJoinColumns()) {
            this.getJoinTable().setDefaultInverseJoinColumns(false);
        }
    }

    protected String annotationName() {
        return JOIN_TABLE_ANNOTATION;
    }

    private JoinTable getJoinTable() {
        return (JoinTable)this.getTable();
    }

    protected String defaultName() {
        Table owningTable = this.getMultiRelationshipMapping().getTypeMapping().getTable();
        Entity targetEntity = this.getMultiRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity != null) {
            Table table = targetEntity.getTable();
            if (owningTable != null && table != null) {
                return String.valueOf(owningTable.getName()) + "_" + table.getName();
            }
        }
        return "";
    }

    private MultiRelationshipMapping getMultiRelationshipMapping() {
        return (MultiRelationshipMapping)this.getJoinTable().eContainer();
    }

    protected Member member() {
        return ((JavaPersistentAttributeModelAdapter)this.getMultiRelationshipMapping().getPersistentAttribute().getModelAdapter()).getAttribute();
    }

    public void defaultJoinColumnsChanged() {
    }

    public void defaultInverseJoinColumnsChanged() {
    }
}

