/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.PersistenceFile;
import org.eclipse.dali.core.PersistenceSourceRefElement;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.PreferenceConstants;
import org.eclipse.dali.ui.views.AbstractPersistenceView;
import org.eclipse.dali.ui.views.EmptyComposite;
import org.eclipse.dali.ui.views.PersistencePropertiesView;
import org.eclipse.dali.ui.views.ToggleLinkingAction;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.texteditor.ITextEditor;

public class PersistenceOutlineView
extends AbstractPersistenceView {
    private TreeViewer viewer;
    private PageBook pageBook;
    private EmptyComposite emptyComposite;
    private IPartListener2 partListener;
    private PersistenceFile persistenceFile;
    private ISelectionListener postSelectionListener;
    private boolean linkingWithEditorEnabled;

    public PersistenceOutlineView() {
        this.initLinkingEnabled();
        this.partListener = this.buildPartListener();
    }

    private IPartListener2 buildPartListener() {
        return new IPartListener2(){

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                PersistenceOutlineView.this.handlePartRef(partRef);
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                PersistenceOutlineView.this.handlePartRef(partRef);
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef instanceof IEditorReference) {
                    PersistenceOutlineView.this.setPersistenceFile(null);
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
    }

    private void handlePartRef(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            IEditorInput input = null;
            try {
                input = ((IEditorReference)partRef).getEditorInput();
            }
            catch (PartInitException partInitException) {}
            this.setActiveInput(input);
        }
    }

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.emptyComposite = new EmptyComposite((Composite)this.pageBook, "Persistence outline is not available. Selection is either not a persistence mapping or 'Persistence' have not been enabled for its project.");
        this.createTree((Composite)this.pageBook);
        this.viewer.setInput((Object)this.getPersistenceFile());
        if (this.persistenceFile != null) {
            this.pageBook.showPage((Control)this.viewer.getTree());
        } else {
            this.pageBook.showPage((Control)this.emptyComposite);
        }
        this.registerToolbarActions();
        this.hookPostSelectionListener();
    }

    private void createTree(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersistencePropertiesView persistencePropertiesView;
                if (event.getSelection() instanceof StructuredSelection && (persistencePropertiesView = PersistenceOutlineView.this.getPersistencePropertiesView()) != null) {
                    persistencePropertiesView.populate((EObject)((StructuredSelection)event.getSelection()).getFirstElement());
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void registerToolbarActions() {
        IActionBars actionBars = ((IViewSite)this.getSite()).getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new ToggleLinkingAction(this));
        }
    }

    private void hookPostSelectionListener() {
        this.postSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part == PersistenceOutlineView.this) {
                    Iterator i = ((StructuredSelection)selection).iterator();
                    while (i.hasNext()) {
                        PersistenceSourceRefElement element = (PersistenceSourceRefElement)i.next();
                        ITextRange range = element.getTextRange();
                        IEditorPart editorPart = PersistenceOutlineView.this.getSite().getPage().getActiveEditor();
                        if (!(editorPart instanceof ITextEditor)) continue;
                        ((ITextEditor)editorPart).selectAndReveal(range.getOffset(), range.getLength());
                    }
                } else if (part instanceof IEditorPart && PersistenceOutlineView.this.isLinkingWithEditorEnabled()) {
                    PersistenceOutlineView.this.setSelectionFromEditor((IEditorPart)part, selection);
                }
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.postSelectionListener);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setWorkbenchPage(site.getPage());
    }

    private void setWorkbenchPage(IWorkbenchPage page) {
        this.hookPartListener(page);
        IEditorInput input = page.getActiveEditor() == null ? null : page.getActiveEditor().getEditorInput();
        this.initializePersistenceFile(page, PersistenceUiPlugin.getPlugin().getPersistenceManager().persistenceFileForInput(input));
    }

    private void hookPartListener(IWorkbenchPage page) {
        page.addPartListener(this.partListener);
    }

    private void unhookPartListener() {
        this.getSite().getPage().removePartListener(this.partListener);
    }

    private void initLinkingEnabled() {
        PreferenceConstants.getPreferenceStore().setDefault(this.linkWithEditorPreferenceProperty(), true);
        this.linkingWithEditorEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.linkWithEditorPreferenceProperty());
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.linkingWithEditorEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue(this.linkWithEditorPreferenceProperty(), enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor(editor);
        }
    }

    private String linkWithEditorPreferenceProperty() {
        return "org.eclipse.dali.linkpropertiestoeditor";
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(this.linkWithEditorPreferenceProperty(), this.linkingWithEditorEnabled ? 1 : 0);
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(this.linkWithEditorPreferenceProperty());
        if (val != null) {
            this.linkingWithEditorEnabled = val != 0;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            this.restoreLinkingEnabled(memento);
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        this.saveLinkingEnabled(memento);
        super.saveState(memento);
    }

    protected boolean isLinkingWithEditorEnabled() {
        return this.linkingWithEditorEnabled;
    }

    public void dispose() {
        this.unhookPartListener();
        super.dispose();
    }

    public PersistenceFile getPersistenceFile() {
        return this.persistenceFile;
    }

    private void setActiveInput(IEditorInput input) {
        this.setPersistenceFile(PersistenceUiPlugin.getPlugin().getPersistenceManager().persistenceFileForInput(input));
    }

    private void initializePersistenceFile(IWorkbenchPage page, PersistenceFile pFile) {
        this.persistenceFile = pFile;
        PersistencePropertiesView persistencePropertiesView = (PersistencePropertiesView)page.findView("org.eclipse.dali.ui.persistencePropertiesView");
        if (persistencePropertiesView != null) {
            persistencePropertiesView.setPersistenceFile(pFile);
        }
    }

    private void setPersistenceFile(PersistenceFile pFile) {
        PersistencePropertiesView persistencePropertiesView;
        if (this.persistenceFile == pFile) {
            return;
        }
        this.persistenceFile = pFile;
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.getPersistenceFile());
        }
        if (this.pageBook != null) {
            if (pFile != null) {
                this.pageBook.showPage((Control)this.viewer.getTree());
            } else {
                this.pageBook.showPage((Control)this.emptyComposite);
            }
        }
        if ((persistencePropertiesView = this.getPersistencePropertiesView()) != null) {
            persistencePropertiesView.setPersistenceFile(pFile);
        }
    }

    private PersistencePropertiesView getPersistencePropertiesView() {
        return (PersistencePropertiesView)this.getSite().getPage().findView("org.eclipse.dali.ui.persistencePropertiesView");
    }

    protected void setSelectionFromEditor(IEditorPart part) {
        IEditorPart editorPart = this.getSite().getPage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            this.setSelectionFromEditor(editorPart, ((ITextEditor)editorPart).getSelectionProvider().getSelection());
        }
    }

    protected void setSelectionFromEditor(IEditorPart part, ISelection selection) {
        if (this.persistenceFile == null) {
            return;
        }
        PersistenceSourceRefElement pElement = null;
        part.getEditorInput();
        if (selection instanceof ITextSelection) {
            int offset = ((ITextSelection)selection).getOffset();
            pElement = this.persistenceFile.persistenceObjectAt(offset);
        }
        if (pElement != null) {
            this.setSelection(pElement);
        }
    }

    private void setSelection(PersistenceSourceRefElement element) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
    }

    public static interface EditorSelector {
        public int offset();

        public int length();
    }
}

