/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.AccessType;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Embeddable;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.PersistentTypeItemProvider;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class EmbeddableComposite
extends Composite
implements IPersistenceComposite {
    private Embeddable embeddable;
    private PersistentType persistentType;
    private ComboViewer accessTypeComboViewer;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private INotifyChangedListener persistentTypeListener;
    private EditingDomain editingDomain;
    private boolean populating;
    static /* synthetic */ Class class$0;

    public EmbeddableComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label accessTypeLabel = new Label(composite, 16384);
        accessTypeLabel.setText("Access Type:");
        this.accessTypeComboViewer = this.buildAccessTypeCombo(composite);
        this.accessTypeComboViewer.getCombo().setEnabled(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.accessTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.accessTypeComboViewer.getCombo(), "org.eclipse.dali.ui.entity_accessType");
    }

    private ComboViewer buildAccessTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(AccessType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (EmbeddableComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    EmbeddableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)EmbeddableComposite.this.editingDomain, (Object)EmbeddableComposite.this.persistentType, (Object)DaliPackage.eINSTANCE.getPersistentType_AccessType(), (Object)selection.getFirstElement()));
                }
            }
        });
        return viewer;
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.embeddable != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
        this.embeddable = (Embeddable)model;
        if (this.embeddable == null) {
            return;
        }
        this.persistentType = this.embeddable.getPersistentType();
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.accessTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.embeddable.getPersistentType().getAccessType()));
        this.populating = false;
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.core.PersistentType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 2) {
                        AccessType accessType = (AccessType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, accessType){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ AccessType val$accessType;
                            {
                                this.this$1 = var1_1;
                                this.val$accessType = accessType;
                            }

                            public void run() {
                                if (((StructuredSelection)EmbeddableComposite.access$3(2.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$accessType) {
                                    EmbeddableComposite.access$3(2.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$accessType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ EmbeddableComposite access$0(2 var0) {
                    return var0.EmbeddableComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    static /* synthetic */ ComboViewer access$3(EmbeddableComposite embeddableComposite) {
        return embeddableComposite.accessTypeComboViewer;
    }
}

