/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.db.Column;
import org.eclipse.dali.db.ForeignKey;
import org.eclipse.dali.db.JavaPropertyNameGenerator;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.IndentingPrintWriter;
import org.eclipse.dali.internal.utility.JavaType;
import org.eclipse.dali.internal.utility.NameTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class EntityGenerator {
    private final Config config;
    private final IPackageFragment packageFragment;
    private final Table table;
    private final IProgressMonitor monitor;
    private final Map imports = new HashMap();
    private final Map attributeNames = new HashMap();
    static /* synthetic */ Class class$0;

    public static void generateEntity(Config config, IPackageFragment packageFragment, Table table, IProgressMonitor monitor) {
        if (config == null || packageFragment == null || table == null) {
            throw new NullPointerException();
        }
        new EntityGenerator(config, packageFragment, table, monitor).generateEntity();
    }

    private EntityGenerator(Config config, IPackageFragment packageFragment, Table table, IProgressMonitor monitor) {
        this.config = config;
        this.packageFragment = packageFragment;
        this.table = table;
        this.monitor = monitor;
    }

    private void generateEntity() {
        try {
            this.generateEntityUnhandled();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void generateEntityUnhandled() throws JavaModelException {
        this.packageFragment.createCompilationUnit(String.valueOf(this.table.shortJavaClassName(this.config.caseSensitive())) + ".java", this.buildSource(), true, this.monitor);
    }

    private String buildSource() {
        String entitySource = this.buildBodySource();
        StringWriter sw = new StringWriter(entitySource.length() + 5000);
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)sw);
        this.printHeaderSourceOn(pw);
        pw.print(entitySource);
        return sw.toString();
    }

    private String buildBodySource() {
        StringWriter sw = new StringWriter(20000);
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)sw);
        this.printEntitySourceOn(pw);
        return sw.toString();
    }

    private void printEntitySourceOn(IndentingPrintWriter pw) {
        this.printPersistenceAnnotationOn("Entity", pw);
        pw.println();
        if (this.table.primaryKeyColumnsSize() > 1) {
            this.printPersistenceAnnotationOn("IdClass", pw);
            pw.print('(');
            pw.print(this.shortTypeDeclaration(this.entityName()));
            pw.print(".PK.class)");
            pw.println();
        }
        pw.print("public class ");
        pw.print(this.shortTypeDeclaration(this.entityName()));
        pw.print(" {");
        pw.println();
        pw.indent();
        this.printBasicFieldsSourceOn(this.table.nonForeignKeyColumns(), pw, true, true);
        this.printOneToOneFieldsSourceOn(this.table.foreignKeys(), pw);
        if (this.config.annotateProperties() || this.config.generateGettersAndSetters()) {
            this.printBasicGettersAndSettersSourceOn(this.table.nonForeignKeyColumns(), pw, true);
        }
        pw.println();
        if (this.table.primaryKeyColumnsSize() > 1) {
            this.printIdClassSourceOn(pw);
            pw.println();
            pw.println();
        }
        pw.undent();
        pw.print('}');
        pw.println();
    }

    private void printIdClassSourceOn(IndentingPrintWriter pw) {
        pw.print("public static class PK implements ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.Serializable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        pw.print(this.shortTypeDeclaration(clazz.getName()));
        pw.print(" {");
        pw.println();
        pw.indent();
        this.printBasicFieldsSourceOn(this.table.primaryKeyColumns(), pw, false, false);
        this.printPublicZeroArgumentConstructorOn("PK", pw);
        pw.println();
        pw.println();
        if (this.config.annotateProperties() || this.config.generateGettersAndSetters()) {
            this.printBasicGettersAndSettersSourceOn(this.table.primaryKeyColumns(), pw, false);
        }
        this.printEqualsMethodOn("PK", this.table.primaryKeyColumns(), pw);
        pw.println();
        pw.println();
        this.printHashCodeMethodOn(this.table.primaryKeyColumns(), pw);
        pw.println();
        pw.println();
        pw.undent();
        pw.print('}');
        pw.println();
    }

    private void printBasicFieldsSourceOn(Iterator columns, IndentingPrintWriter pw, boolean printId, boolean genNewName) {
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            this.printBasicFieldSourceOn(column, pw, printId, genNewName);
            pw.println();
        }
        pw.println();
    }

    private void printBasicFieldSourceOn(Column column, IndentingPrintWriter pw, boolean printId, boolean genNewName) {
        if (printId && this.config.annotateFields() && this.table.primaryKeyColumnsContains(column)) {
            this.printPersistenceAnnotationOn("Id", pw);
            pw.print(' ');
        }
        this.printVisiblityOn(this.config.fieldVisibility(), pw);
        pw.print(this.shortTypeDeclaration(column.javaTypeDeclaration()));
        pw.print(' ');
        pw.print(genNewName ? this.propertyName1((JavaPropertyNameGenerator)column) : this.propertyName2((JavaPropertyNameGenerator)column));
        pw.print(';');
    }

    private void printOneToOneFieldsSourceOn(Iterator foreignKeys, IndentingPrintWriter pw) {
        while (foreignKeys.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)foreignKeys.next();
            this.printOneToOneFieldSourceOn(foreignKey, pw);
            pw.println();
        }
        pw.println();
    }

    private void printOneToOneFieldSourceOn(ForeignKey foreignKey, IndentingPrintWriter pw) {
        if (this.config.annotateFields()) {
            this.printOneToOneAnnotationSourceOn(foreignKey, pw);
        }
        this.printVisiblityOn(this.config.fieldVisibility(), pw);
        pw.print(this.shortTypeDeclaration(String.valueOf(this.packageName()) + '.' + foreignKey.shortJavaClassName(this.config.caseSensitive())));
        pw.print(' ');
        pw.print(this.propertyName1((JavaPropertyNameGenerator)foreignKey));
        pw.print(';');
    }

    private void printOneToOneAnnotationSourceOn(ForeignKey foreignKey, IndentingPrintWriter pw) {
        this.printPersistenceAnnotationOn("OneToOne", pw);
        pw.println();
        if (foreignKey.baseColumnNameIsEntityDefault()) {
            return;
        }
        if (foreignKey.referencesSingleColumnPrimaryKey()) {
            this.printPersistenceAnnotationOn("JoinColumn", pw);
            pw.print("(name=\"");
            pw.print(((ForeignKey.ColumnPair)foreignKey.columnPairs().next()).getBaseColumn().getName());
            pw.print("\")");
        } else {
            if (foreignKey.columnPairsSize() > 1) {
                this.printPersistenceAnnotationOn("JoinColumns", pw);
                pw.print("({");
                pw.println();
                pw.indent();
            }
            Iterator stream = foreignKey.columnPairs();
            while (stream.hasNext()) {
                ForeignKey.ColumnPair columnPair = (ForeignKey.ColumnPair)stream.next();
                this.printPersistenceAnnotationOn("JoinColumn", pw);
                pw.print("(name=\"");
                pw.print(columnPair.getBaseColumn().getName());
                pw.print("\", referencedColumnName=\"");
                pw.print(columnPair.getReferencedColumn().getName());
                pw.print("\")");
                if (!stream.hasNext()) continue;
                pw.println(',');
            }
            if (foreignKey.columnPairsSize() > 1) {
                pw.undent();
                pw.println();
                pw.print("})");
            }
        }
        pw.println();
    }

    private void printPublicZeroArgumentConstructorOn(String ctorName, IndentingPrintWriter pw) {
        pw.print("public ");
        pw.print(ctorName);
        pw.print("() {");
        pw.println();
        pw.indent();
        pw.println("super();");
        pw.undent();
        pw.print('}');
    }

    private void printBasicGettersAndSettersSourceOn(Iterator columns, IndentingPrintWriter pw, boolean printId) {
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            this.printBasicPropertySourceOn(column, pw, printId);
            pw.println();
            pw.println();
        }
    }

    private void printBasicPropertySourceOn(Column column, IndentingPrintWriter pw, boolean printId) {
        String typeDeclaration = this.shortTypeDeclaration(column.javaTypeDeclaration());
        String propertyName = this.propertyName2((JavaPropertyNameGenerator)column);
        if (printId && this.config.annotateProperties() && this.table.primaryKeyColumnsContains(column)) {
            this.printPersistenceAnnotationOn("Id", pw);
            pw.println();
        }
        this.printGetterSourceOn(typeDeclaration, propertyName, pw);
        pw.println();
        pw.println();
        this.printSetterSourceOn(typeDeclaration, propertyName, pw);
    }

    private void printGetterSourceOn(String typeDeclaration, String propertyName, IndentingPrintWriter pw) {
        this.printVisiblityOn(this.config.methodVisibility(), pw);
        pw.print(typeDeclaration);
        pw.print(' ');
        pw.print(typeDeclaration.equals("boolean") ? "is" : "get");
        pw.print(StringTools.capitalize((String)propertyName));
        pw.print("() {");
        pw.println();
        pw.indent();
        pw.print("return this.");
        pw.print(propertyName);
        pw.print(';');
        pw.println();
        pw.undent();
        pw.print('}');
    }

    private void printSetterSourceOn(String typeDeclaration, String propertyName, IndentingPrintWriter pw) {
        this.printVisiblityOn(this.config.methodVisibility(), pw);
        pw.print("void set");
        pw.print(StringTools.capitalize((String)propertyName));
        pw.print('(');
        pw.print(typeDeclaration);
        pw.print(' ');
        pw.print(propertyName);
        pw.print(") {");
        pw.println();
        pw.indent();
        pw.print("this.");
        pw.print(propertyName);
        pw.print(" = ");
        pw.print(propertyName);
        pw.print(';');
        pw.println();
        pw.undent();
        pw.print('}');
    }

    private void printEqualsMethodOn(String className, Iterator columns, IndentingPrintWriter pw) {
        this.printAnnotationOn("java.lang.Override", pw);
        pw.println();
        pw.println("public boolean equals(Object o) {");
        pw.indent();
        pw.println("if (o == this) {");
        pw.indent();
        pw.println("return true;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.print("if ( ! (o instanceof ");
        pw.print(className);
        pw.print(")) {");
        pw.println();
        pw.indent();
        pw.println("return false;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.print(className);
        pw.print(" other = (");
        pw.print(className);
        pw.print(") o;");
        pw.println();
        pw.print("return ");
        pw.indent();
        while (columns.hasNext()) {
            this.printComparisonClauseOn((Column)columns.next(), pw);
            if (!columns.hasNext()) continue;
            pw.println();
            pw.print("&& ");
        }
        pw.print(';');
        pw.println();
        pw.undent();
        pw.undent();
        pw.print('}');
    }

    private void printComparisonClauseOn(Column column, IndentingPrintWriter pw) {
        String fieldName = this.propertyName2((JavaPropertyNameGenerator)column);
        JavaType javaType = column.javaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveComparisonClauseOn(fieldName, pw);
        } else {
            this.printReferenceComparisonClauseOn(fieldName, pw);
        }
    }

    private void printPrimitiveComparisonClauseOn(String fieldName, IndentingPrintWriter pw) {
        pw.print("(this.");
        pw.print(fieldName);
        pw.print(" == other.");
        pw.print(fieldName);
        pw.print(')');
    }

    private void printReferenceComparisonClauseOn(String fieldName, IndentingPrintWriter pw) {
        pw.print("this.");
        pw.print(fieldName);
        pw.print(".equals(other.");
        pw.print(fieldName);
        pw.print(')');
    }

    private void printHashCodeMethodOn(Iterator columns, IndentingPrintWriter pw) {
        this.printAnnotationOn("java.lang.Override", pw);
        pw.println();
        pw.println("public int hashCode() {");
        pw.indent();
        pw.print("return ");
        pw.indent();
        while (columns.hasNext()) {
            this.printHashCodeClauseOn((Column)columns.next(), pw);
            if (!columns.hasNext()) continue;
            pw.println();
            pw.print("^ ");
        }
        pw.print(';');
        pw.println();
        pw.undent();
        pw.undent();
        pw.print('}');
    }

    private void printHashCodeClauseOn(Column column, IndentingPrintWriter pw) {
        String fieldName = this.propertyName2((JavaPropertyNameGenerator)column);
        JavaType javaType = column.javaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveHashCodeClauseOn(javaType.getElementTypeName(), fieldName, pw);
        } else {
            this.printReferenceHashCodeClauseOn(fieldName, pw);
        }
    }

    private void printPrimitiveHashCodeClauseOn(String primitiveName, String fieldName, IndentingPrintWriter pw) {
        if (primitiveName.equals("int") || primitiveName.equals("short") || primitiveName.equals("byte") || primitiveName.equals("char")) {
            pw.print("this.");
            pw.print(fieldName);
        } else if (primitiveName.equals("long")) {
            pw.print("((int) (this.");
            pw.print(fieldName);
            pw.print(" ^ (this.");
            pw.print(fieldName);
            pw.print(" >>> 32)))");
        } else if (primitiveName.equals("double")) {
            pw.print("((int) (");
            pw.print(this.shortTypeDeclaration("java.lang.Double"));
            pw.print(".doubleToLongBits(this.");
            pw.print(fieldName);
            pw.print(") ^ (");
            pw.print(this.shortTypeDeclaration("java.lang.Double"));
            pw.print(".doubleToLongBits(this.");
            pw.print(fieldName);
            pw.print(") >>> 32)))");
        } else if (primitiveName.equals("float")) {
            pw.print(this.shortTypeDeclaration("java.lang.Float"));
            pw.print(".floatToIntBits(this.");
            pw.print(fieldName);
            pw.print(')');
        } else if (primitiveName.equals("boolean")) {
            pw.print("(this.");
            pw.print(fieldName);
            pw.print(" ? 1231 : 1237)");
        } else {
            throw new IllegalArgumentException(primitiveName);
        }
    }

    private void printReferenceHashCodeClauseOn(String fieldName, IndentingPrintWriter pw) {
        pw.print("this.");
        pw.print(fieldName);
        pw.print(".hashCode()");
    }

    private void printPersistenceAnnotationOn(String shortAnnotationName, IndentingPrintWriter pw) {
        this.printAnnotationOn("javax.persistence." + shortAnnotationName, pw);
    }

    private void printAnnotationOn(String annotationName, IndentingPrintWriter pw) {
        pw.print('@');
        pw.print(this.shortTypeDeclaration(annotationName));
    }

    private void printVisiblityOn(String visibilityModifier, IndentingPrintWriter pw) {
        if (visibilityModifier.length() != 0) {
            pw.print(visibilityModifier);
            pw.print(' ');
        }
    }

    private String propertyName1(JavaPropertyNameGenerator dbObject) {
        String fieldName = dbObject.javaPropertyName(this.config.caseSensitive());
        fieldName = NameTools.uniqueNameFor((String)fieldName, this.attributeNames.values());
        this.attributeNames.put(dbObject, fieldName);
        return fieldName;
    }

    private String propertyName2(JavaPropertyNameGenerator dbObject) {
        return (String)this.attributeNames.get(dbObject);
    }

    private void printHeaderSourceOn(IndentingPrintWriter pw) {
        pw.print("package ");
        pw.print(this.packageName());
        pw.print(';');
        pw.println();
        pw.println();
        Iterator stream = this.sortedImports();
        while (stream.hasNext()) {
            Map.Entry entry = (Map.Entry)stream.next();
            Object pkg = entry.getValue();
            if (pkg.equals("java.lang")) continue;
            Object shortName = entry.getKey();
            if (pkg.equals(this.packageName()) && shortName.equals(this.table.shortJavaClassName(this.config.caseSensitive()))) continue;
            pw.print("import ");
            pw.print(pkg);
            pw.print('.');
            pw.print(shortName);
            pw.print(';');
            pw.println();
        }
        pw.println();
    }

    private String entityName() {
        return String.valueOf(this.packageName()) + '.' + this.table.shortJavaClassName(this.config.caseSensitive());
    }

    private String packageName() {
        return this.packageFragment.getElementName();
    }

    private Iterator sortedImports() {
        TreeSet sortedImports = new TreeSet(this.buildImportsComparator());
        sortedImports.addAll(this.imports.entrySet());
        return sortedImports.iterator();
    }

    private Comparator buildImportsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                Collator collator = Collator.getInstance();
                int pkg = collator.compare((String)e1.getValue(), (String)e2.getValue());
                return pkg == 0 ? collator.compare((String)e1.getKey(), (String)e2.getKey()) : pkg;
            }
        };
    }

    private String shortTypeDeclaration(String typeDeclaration) {
        int last = typeDeclaration.lastIndexOf(46);
        if (last == -1) {
            return typeDeclaration;
        }
        String shortClassDeclaration = typeDeclaration.substring(last + 1);
        String packageName = typeDeclaration.substring(0, last);
        String prev = (String)this.imports.get(shortClassDeclaration);
        if (prev == null) {
            this.imports.put(shortClassDeclaration, packageName);
            return shortClassDeclaration;
        }
        if (prev.equals(packageName)) {
            return shortClassDeclaration;
        }
        return typeDeclaration;
    }

    public static class Config {
        private boolean caseSensitive = false;
        private boolean annotateProperties = false;
        private int fieldVisibility = 2;
        private int methodVisibility = 1;
        private boolean generateGettersAndSetters = true;
        public static final int PRIVATE = 0;
        public static final int PACKAGE = 1;
        public static final int PROTECTED = 2;
        public static final int PUBLIC = 3;

        public boolean caseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public boolean annotateProperties() {
            return this.annotateProperties;
        }

        public boolean annotateFields() {
            return !this.annotateProperties;
        }

        public void setAnnotateProperties(boolean annotateProperties) {
            this.annotateProperties = annotateProperties;
        }

        public int getFieldVisibility() {
            return this.fieldVisibility;
        }

        public void setFieldVisibility(int fieldVisibility) {
            switch (fieldVisibility) {
                case 0: 
                case 1: 
                case 2: {
                    this.fieldVisibility = fieldVisibility;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid field visibility: " + fieldVisibility);
                }
            }
        }

        String fieldVisibility() {
            switch (this.fieldVisibility) {
                case 0: {
                    return "private";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "protected";
                }
            }
            throw new IllegalStateException("invalid field visibility: " + this.fieldVisibility);
        }

        public int getMethodVisibility() {
            return this.methodVisibility;
        }

        public void setMethodVisibility(int methodVisibility) {
            switch (methodVisibility) {
                case 2: 
                case 3: {
                    this.methodVisibility = methodVisibility;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid method visibility: " + methodVisibility);
                }
            }
        }

        String methodVisibility() {
            switch (this.methodVisibility) {
                case 2: {
                    return "protected";
                }
                case 3: {
                    return "public";
                }
            }
            throw new IllegalStateException("invalid method visibility: " + this.methodVisibility);
        }

        public boolean generateGettersAndSetters() {
            return this.generateGettersAndSetters;
        }

        public void setGenerateGettersAndSetters(boolean generateGettersAndSetters) {
            this.generateGettersAndSetters = generateGettersAndSetters;
        }
    }
}

