/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.util;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.UnresolvedType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DBMSMetadataSessionTransforms;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilderException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;

public class DatabaseTypeBuilder {
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    public static final String FORWARD_SLASH = "/";
    public static final String NOT = "NOT ";
    public static final String OR = " OR ";
    public static final String RESULT = "RESULT";
    public static final String PERCENT = "%";
    public static final String NEW_LINE = "\n";
    public static final String TOPLEVEL = "TOPLEVEL";
    public static final String ROWTYPE_MACRO = "%ROWTYPE";
    public static final String TYPE_MACRO = "%TYPE";
    public static final String DOT = ".";
    public static final String TRANSFORM_PREFIX = "DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'";
    public static final String DBMS_METADATA_GET_DDL_STMT_PREFIX = "SELECT DBMS_METADATA.GET_DDL('";
    public static final String DBMS_METADATA_GET_DDL_STMT1 = "', AO.OBJECT_NAME) AS RESULT FROM ALL_OBJECTS AO WHERE ";
    public static final String EXCLUDED_ADMIN_SCHEMAS = "'*SYS*|XDB|*ORD*|DBSNMP|ANONYMOUS|OUTLN|MGMT_VIEW|SI_INFORMTN_SCHEMA|WK_TEST|WKPROXY'";
    public static final String DBMS_METADATA_GET_DDL_STMT_STMT2 = "REGEXP_LIKE(OWNER,?) AND";
    public static final String DBMS_METADATA_GET_DDL_STMT_STMT3 = " AO.STATUS = 'VALID' AND AO.OBJECT_TYPE = ? AND";
    public static final String DBMS_METADATA_GET_DDL_STMT_SUFFIX = " AO.OBJECT_NAME LIKE ?";
    public static final int OBJECT_TYPE_UNKNOWN_CODE = -1;
    public static final String ALL_OBJECTS_OBJECT_TYPE_FIELD = "OBJECT_TYPE";
    public static final String OBJECT_TYPE_FUNCTION = "FUNCTION";
    public static final int OBJECT_TYPE_FUNCTION_CODE = 1;
    public static final String OBJECT_TYPE_PACKAGE = "PACKAGE";
    public static final int OBJECT_TYPE_PACKAGE_CODE = 2;
    public static final String OBJECT_TYPE_PROCEDURE = "PROCEDURE";
    public static final int OBJECT_TYPE_PROCEDURE_CODE = 3;
    public static final String OBJECT_TYPE_TABLE = "TABLE";
    public static final int OBJECT_TYPE_TABLE_CODE = 4;
    public static final String OBJECT_TYPE_TYPE = "TYPE";
    public static final int OBJECT_TYPE_TYPE_CODE = 5;
    public static final String GET_OBJECT_TYPE_STMT = "SELECT DECODE(AO.OBJECT_TYPE, 'FUNCTION', 1, 'PACKAGE', 2, 'PROCEDURE', 3, 'TABLE', 4, 'TYPE', 5,-1) AS OBJECT_TYPE FROM ALL_OBJECTS AO WHERE (STATUS = 'VALID' AND OWNER LIKE ? AND OBJECT_NAME = ?)";
    static DBMSMetadataSessionTransforms TRANSFORMS_FACTORY;
    protected boolean transformsSet = false;

    static {
        ServiceLoader<DBMSMetadataSessionTransforms> transformsFactories = ServiceLoader.load(DBMSMetadataSessionTransforms.class);
        Iterator<DBMSMetadataSessionTransforms> i = transformsFactories.iterator();
        TRANSFORMS_FACTORY = i.hasNext() ? i.next() : null;
    }

    public List<TableType> buildTables(Connection conn, String schemaPattern, String tablePattern) throws ParseException {
        return this.buildTables(conn, schemaPattern, tablePattern, true);
    }

    protected List<TableType> buildTables(Connection conn, String schemaPattern, String tablePattern, boolean resolveTypes) throws ParseException {
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add(schemaPattern);
        ArrayList<String> tablePatterns = new ArrayList<String>();
        tablePatterns.add(tablePattern);
        return this.buildTables(conn, schemaPatterns, tablePatterns, resolveTypes);
    }

    public List<TableType> buildTables(Connection conn, List<String> schemaPatterns, List<String> tablePatterns) throws ParseException {
        return this.buildTables(conn, schemaPatterns, tablePatterns, true);
    }

    protected List<TableType> buildTables(Connection conn, List<String> schemaPatterns, List<String> tablePatterns, boolean resolveTypes) throws ParseException {
        List<String> ddls;
        ArrayList<TableType> tableTypes = null;
        ArrayList<String> copyOfSchemaPatterns = new ArrayList<String>();
        ArrayList<String> copyOfTablePatterns = new ArrayList<String>();
        String getDDlStmt = this.buildDDLStmt(OBJECT_TYPE_TABLE, schemaPatterns, tablePatterns, copyOfSchemaPatterns, copyOfTablePatterns);
        if (this.setDbmsMetadataSessionTransforms(conn) && (ddls = this.getDDLs(conn, OBJECT_TYPE_TABLE, getDDlStmt, copyOfSchemaPatterns, copyOfTablePatterns)) != null) {
            TreeSet<String> distinctDDLs = new TreeSet<String>();
            distinctDDLs.addAll(ddls);
            tableTypes = new ArrayList<TableType>();
            for (String ddl : distinctDDLs) {
                DDLParser parser = this.newDDLParser(ddl, copyOfSchemaPatterns);
                TableType tableType = parser.parseTable();
                if (tableType == null) continue;
                tableTypes.add(tableType);
                if (!resolveTypes) continue;
                UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                unresolvedTypesVisitor.visit(tableType);
                if (unresolvedTypesVisitor.getUnresolvedTypes().isEmpty()) continue;
                this.resolvedTypes(conn, tableType.getSchema(), parser, unresolvedTypesVisitor.getUnresolvedTypes(), tableType);
            }
        }
        return tableTypes;
    }

    public List<PLSQLPackageType> buildPackages(Connection conn, String schemaPattern, String packagePattern) throws ParseException {
        return this.buildPackages(conn, schemaPattern, packagePattern, true);
    }

    protected List<PLSQLPackageType> buildPackages(Connection conn, String schemaPattern, String packagePattern, boolean resolveTypes) throws ParseException {
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add(schemaPattern);
        ArrayList<String> packagePatterns = new ArrayList<String>();
        packagePatterns.add(packagePattern);
        return this.buildPackages(conn, schemaPatterns, packagePatterns, resolveTypes);
    }

    public List<PLSQLPackageType> buildPackages(Connection conn, List<String> schemaPatterns, List<String> packagePatterns) throws ParseException {
        return this.buildPackages(conn, schemaPatterns, packagePatterns, true);
    }

    protected List<PLSQLPackageType> buildPackages(Connection conn, List<String> schemaPatterns, List<String> packagePatterns, boolean resolveTypes) throws ParseException {
        List<String> ddls;
        ArrayList<PLSQLPackageType> packageTypes = null;
        ArrayList<String> copyOfSchemaPatterns = new ArrayList<String>();
        ArrayList<String> copyOfPackagePatterns = new ArrayList<String>();
        String getDDlStmt = this.buildDDLStmt(OBJECT_TYPE_PACKAGE, schemaPatterns, packagePatterns, copyOfSchemaPatterns, copyOfPackagePatterns);
        if (this.setDbmsMetadataSessionTransforms(conn) && (ddls = this.getDDLs(conn, OBJECT_TYPE_PACKAGE, getDDlStmt, copyOfSchemaPatterns, copyOfPackagePatterns)) != null) {
            DDLParser parser;
            TreeSet<String> distinctDDLs = new TreeSet<String>();
            distinctDDLs.addAll(ddls);
            packageTypes = new ArrayList<PLSQLPackageType>();
            HashMap<PLSQLPackageType, DDLParser> parserMap = new HashMap<PLSQLPackageType, DDLParser>();
            for (String ddl : distinctDDLs) {
                parser = this.newDDLParser(ddl, copyOfSchemaPatterns);
                PLSQLPackageType packageType = parser.parsePLSQLPackage();
                if (packageType == null) continue;
                packageTypes.add(packageType);
                parserMap.put(packageType, parser);
            }
            if (!parserMap.isEmpty() && resolveTypes) {
                for (PLSQLPackageType packageType : parserMap.keySet()) {
                    parser = (DDLParser)parserMap.get(packageType);
                    UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                    unresolvedTypesVisitor.visit(packageType);
                    if (unresolvedTypesVisitor.getUnresolvedTypes().isEmpty()) continue;
                    this.resolvedTypes(conn, packageType.getSchema(), parser, unresolvedTypesVisitor.getUnresolvedTypes(), packageType, packageTypes);
                }
            }
        }
        return packageTypes;
    }

    public List<ProcedureType> buildProcedures(Connection conn, String schemaPattern, String procedurePattern) throws ParseException {
        return this.buildProcedures(conn, schemaPattern, procedurePattern, true);
    }

    protected List<ProcedureType> buildProcedures(Connection conn, String schemaPattern, String procedurePattern, boolean resolveTypes) throws ParseException {
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add(schemaPattern);
        ArrayList<String> procedurePatterns = new ArrayList<String>();
        procedurePatterns.add(procedurePattern);
        return this.buildProcedures(conn, schemaPatterns, procedurePatterns, resolveTypes);
    }

    public List<ProcedureType> buildProcedures(Connection conn, List<String> schemaPatterns, List<String> procedurePatterns) throws ParseException {
        return this.buildProcedures(conn, schemaPatterns, procedurePatterns, true);
    }

    protected List<ProcedureType> buildProcedures(Connection conn, List<String> schemaPatterns, List<String> procedurePatterns, boolean resolveTypes) throws ParseException {
        List<String> ddls;
        ArrayList<ProcedureType> procedureTypes = null;
        ArrayList<String> copyOfSchemaPatterns = new ArrayList<String>();
        ArrayList<String> copyOfProcedurePatterns = new ArrayList<String>();
        String getDDlStmt = this.buildDDLStmt(OBJECT_TYPE_PROCEDURE, schemaPatterns, procedurePatterns, copyOfSchemaPatterns, copyOfProcedurePatterns);
        if (this.setDbmsMetadataSessionTransforms(conn) && (ddls = this.getDDLs(conn, OBJECT_TYPE_PROCEDURE, getDDlStmt, copyOfSchemaPatterns, copyOfProcedurePatterns)) != null) {
            TreeSet<String> distinctDDLs = new TreeSet<String>();
            distinctDDLs.addAll(ddls);
            procedureTypes = new ArrayList<ProcedureType>();
            for (String ddl : distinctDDLs) {
                DDLParser parser = this.newDDLParser(ddl, copyOfSchemaPatterns);
                ProcedureType procedureType = parser.parseTopLevelProcedure();
                if (procedureType == null) continue;
                procedureTypes.add(procedureType);
                if (!resolveTypes) continue;
                UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                unresolvedTypesVisitor.visit(procedureType);
                if (unresolvedTypesVisitor.getUnresolvedTypes().isEmpty()) continue;
                this.resolvedTypes(conn, procedureType.getSchema(), parser, unresolvedTypesVisitor.getUnresolvedTypes(), procedureType);
            }
        }
        return procedureTypes;
    }

    public List<FunctionType> buildFunctions(Connection conn, String schemaPattern, String functionPattern) throws ParseException {
        return this.buildFunctions(conn, schemaPattern, functionPattern, true);
    }

    protected List<FunctionType> buildFunctions(Connection conn, String schemaPattern, String functionPattern, boolean resolveTypes) throws ParseException {
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add(schemaPattern);
        ArrayList<String> functionPatterns = new ArrayList<String>();
        functionPatterns.add(functionPattern);
        return this.buildFunctions(conn, schemaPatterns, functionPatterns, resolveTypes);
    }

    public List<FunctionType> buildFunctions(Connection conn, List<String> schemaPatterns, List<String> functionPatterns) throws ParseException {
        return this.buildFunctions(conn, schemaPatterns, functionPatterns, true);
    }

    protected List<FunctionType> buildFunctions(Connection conn, List<String> schemaPatterns, List<String> functionPatterns, boolean resolveTypes) throws ParseException {
        List<String> ddls;
        ArrayList<FunctionType> functionsTypes = null;
        ArrayList<String> copyOfSchemaPatterns = new ArrayList<String>();
        ArrayList<String> copyOfFunctionPatterns = new ArrayList<String>();
        String getDDlStmt = this.buildDDLStmt(OBJECT_TYPE_FUNCTION, schemaPatterns, functionPatterns, copyOfSchemaPatterns, copyOfFunctionPatterns);
        if (this.setDbmsMetadataSessionTransforms(conn) && (ddls = this.getDDLs(conn, OBJECT_TYPE_FUNCTION, getDDlStmt, copyOfSchemaPatterns, copyOfFunctionPatterns)) != null) {
            TreeSet<String> distinctDDLs = new TreeSet<String>();
            distinctDDLs.addAll(ddls);
            functionsTypes = new ArrayList<FunctionType>();
            for (String ddl : distinctDDLs) {
                DDLParser parser = this.newDDLParser(ddl, copyOfSchemaPatterns);
                FunctionType functionType = parser.parseTopLevelFunction();
                if (functionType == null) continue;
                functionsTypes.add(functionType);
                if (!resolveTypes) continue;
                UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                unresolvedTypesVisitor.visit(functionType);
                if (unresolvedTypesVisitor.getUnresolvedTypes().isEmpty()) continue;
                this.resolvedTypes(conn, functionType.getSchema(), parser, unresolvedTypesVisitor.getUnresolvedTypes(), functionType);
            }
        }
        return functionsTypes;
    }

    public List<CompositeDatabaseType> buildTypes(Connection conn, String schemaPattern, String namePattern) throws ParseException {
        return this.buildTypes(conn, schemaPattern, namePattern, true);
    }

    protected List<CompositeDatabaseType> buildTypes(Connection conn, String schemaPattern, String namePattern, boolean resolveTypes) throws ParseException {
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add(schemaPattern);
        ArrayList<String> namePatterns = new ArrayList<String>();
        namePatterns.add(namePattern);
        return this.buildTypes(conn, schemaPatterns, namePatterns, resolveTypes);
    }

    public List<CompositeDatabaseType> buildTypes(Connection conn, List<String> schemaPatterns, List<String> namePatterns) throws ParseException {
        return this.buildTypes(conn, schemaPatterns, namePatterns, true);
    }

    protected List<CompositeDatabaseType> buildTypes(Connection conn, List<String> schemaPatterns, List<String> namePatterns, boolean resolveTypes) throws ParseException {
        List<String> ddls;
        ArrayList<CompositeDatabaseType> databaseTypes = null;
        ArrayList<String> copyOfSchemaPatterns = new ArrayList<String>();
        ArrayList<String> copyOfNamePatterns = new ArrayList<String>();
        String getDDlStmt = this.buildDDLStmt(OBJECT_TYPE_TYPE, schemaPatterns, namePatterns, copyOfSchemaPatterns, copyOfNamePatterns);
        if (this.setDbmsMetadataSessionTransforms(conn) && (ddls = this.getDDLs(conn, OBJECT_TYPE_TYPE, getDDlStmt, copyOfSchemaPatterns, copyOfNamePatterns)) != null) {
            TreeSet<String> distinctDDLs = new TreeSet<String>();
            distinctDDLs.addAll(ddls);
            databaseTypes = new ArrayList<CompositeDatabaseType>();
            for (String ddl : distinctDDLs) {
                DDLParser parser = this.newDDLParser(ddl, copyOfSchemaPatterns);
                CompositeDatabaseType databaseType = parser.parseType();
                if (databaseType == null) continue;
                databaseTypes.add(databaseType);
                if (!resolveTypes) continue;
                UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                unresolvedTypesVisitor.visit(databaseType);
                if (unresolvedTypesVisitor.getUnresolvedTypes().isEmpty()) continue;
                String schemaPattern = null;
                schemaPattern = databaseType.isObjectTableType() ? ((ObjectTableType)databaseType).getSchema() : (databaseType.isObjectType() ? ((ObjectType)databaseType).getSchema() : (databaseType.isVArrayType() ? ((VArrayType)databaseType).getSchema() : PERCENT));
                this.resolvedTypes(conn, schemaPattern, parser, unresolvedTypesVisitor.getUnresolvedTypes(), databaseType);
            }
        }
        return databaseTypes;
    }

    protected String buildDDLStmt(String objectType, List<String> schemaPatterns, List<String> namePatterns, List<String> copyOfSchemaPatterns, List<String> copyOfNamePatterns) {
        StringBuilder sb = new StringBuilder();
        sb.append(DBMS_METADATA_GET_DDL_STMT_PREFIX);
        sb.append(objectType);
        sb.append(DBMS_METADATA_GET_DDL_STMT1);
        int i = 0;
        int len = schemaPatterns.size();
        while (i < len) {
            String schemaPattern = schemaPatterns.get(i);
            String schemaPatternU = schemaPattern == null ? null : schemaPattern.toUpperCase();
            String namePattern = namePatterns.get(i);
            String namePatternU = namePattern == null ? null : namePattern.toUpperCase();
            copyOfNamePatterns.add(namePatternU);
            sb.append('(');
            if (DatabaseTypeBuilder.schemaPatternExcludesAdminSchemas(schemaPatternU)) {
                sb.append(NOT);
                copyOfSchemaPatterns.add(EXCLUDED_ADMIN_SCHEMAS);
            } else {
                copyOfSchemaPatterns.add(schemaPatternU);
            }
            sb.append(DBMS_METADATA_GET_DDL_STMT_STMT2);
            sb.append(DBMS_METADATA_GET_DDL_STMT_STMT3);
            sb.append(DBMS_METADATA_GET_DDL_STMT_SUFFIX);
            sb.append(')');
            if (i < len - 1) {
                sb.append(OR);
            }
            ++i;
        }
        return sb.toString();
    }

    protected DDLParser newDDLParser(String ddl, List<String> schemaPatterns) {
        DDLParser parser = new DDLParser(new StringReader(ddl));
        parser.setTypesRepository(new DatabaseTypesRepository());
        parser.setSchemaPatterns(schemaPatterns);
        return parser;
    }

    protected List<String> getDDLs(Connection conn, String typeSpec, String getDDlStmt, List<String> schemaPatterns, List<String> typeNamePatterns) {
        ArrayList<String> ddls;
        block31: {
            ResultSet rs;
            PreparedStatement pStmt;
            block30: {
                ddls = null;
                pStmt = null;
                rs = null;
                try {
                    try {
                        pStmt = conn.prepareStatement(getDDlStmt);
                        int j = 0;
                        int i = 0;
                        int len = schemaPatterns.size();
                        while (i < len) {
                            pStmt.setString(++j, schemaPatterns.get(i));
                            pStmt.setString(++j, typeSpec);
                            pStmt.setString(++j, typeNamePatterns.get(i));
                            ++i;
                        }
                        rs = pStmt.executeQuery();
                        if (!rs.next()) break block30;
                        ddls = new ArrayList<String>();
                        do {
                            Clob clob = rs.getClob(RESULT);
                            String ddl = null;
                            if (clob != null) {
                                Reader is = clob.getCharacterStream();
                                StringBuffer sb = new StringBuffer();
                                int length = (int)clob.length();
                                if (length > 0) {
                                    char[] buffer = new char[length];
                                    try {
                                        while (is.read(buffer) != -1) {
                                            sb.append(buffer);
                                        }
                                    }
                                    catch (Exception exception) {}
                                    ddl = sb.toString().trim();
                                }
                            }
                            if (ddl == null) continue;
                            if (ddl.endsWith(FORWARD_SLASH)) {
                                ddl = (String)ddl.subSequence(0, ddl.length() - 1);
                            }
                            ddls.add(ddl);
                        } while (rs.next());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (pStmt != null) {
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return ddls;
    }

    protected void resolvedTypes(Connection conn, String schemaPattern, DDLParser parser, List<UnresolvedType> unresolvedTypes, DatabaseType databaseType) throws ParseException {
        this.resolvedTypes(conn, schemaPattern, parser, unresolvedTypes, databaseType, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void resolvedTypes(Connection conn, String schemaPattern, DDLParser parser, List<UnresolvedType> unresolvedTypes, DatabaseType databaseType, List<PLSQLPackageType> processedPackages) throws ParseException {
        boolean bl;
        ArrayList<String> percentNameList = new ArrayList<String>();
        ArrayList<String> nonPercentNameList = new ArrayList<String>();
        for (UnresolvedType uType : unresolvedTypes) {
            CompositeDatabaseType owningType = uType.getOwningType();
            if (owningType != null && (owningType.isTYPEType() || owningType.isROWTYPEType())) {
                if (percentNameList.contains(uType.getTypeName())) continue;
                percentNameList.add(uType.getTypeName());
                continue;
            }
            if (nonPercentNameList.contains(uType.getTypeName())) continue;
            nonPercentNameList.add(uType.getTypeName());
        }
        Collections.sort(percentNameList);
        Collections.sort(nonPercentNameList);
        Collections.reverse(percentNameList);
        Collections.reverse(nonPercentNameList);
        ArrayList<UnresolvedType> percentList = new ArrayList<UnresolvedType>();
        block8: for (String tname : percentNameList) {
            for (UnresolvedType unresolvedType : unresolvedTypes) {
                if (!unresolvedType.getTypeName().equals(tname)) continue;
                percentList.add(unresolvedType);
                continue block8;
            }
        }
        ArrayList<UnresolvedType> nonPercentList = new ArrayList<UnresolvedType>();
        block10: for (String tname : nonPercentNameList) {
            for (UnresolvedType unresolvedType : unresolvedTypes) {
                if (!unresolvedType.getTypeName().equals(tname)) continue;
                nonPercentList.add(unresolvedType);
                continue block10;
            }
        }
        Stack<UnresolvedType> stac = new Stack<UnresolvedType>();
        for (UnresolvedType unresolvedType : percentList) {
            if (stac.contains(unresolvedType)) continue;
            stac.push(unresolvedType);
        }
        for (UnresolvedType unresolvedType : nonPercentList) {
            if (stac.contains(unresolvedType)) continue;
            stac.push(unresolvedType);
        }
        boolean bl2 = false;
        DatabaseTypesRepository databaseTypesRepository = parser.getTypesRepository();
        while (!bl) {
            CompositeDatabaseType resolvedType = null;
            UnresolvedType uType = (UnresolvedType)stac.pop();
            String typeName = uType.getTypeName();
            CompositeDatabaseType owningType = uType.getOwningType();
            int dotIdx = typeName.indexOf(DOT);
            String typeName1 = typeName;
            String typeName2 = null;
            if (dotIdx != -1) {
                typeName1 = typeName.substring(0, dotIdx);
                typeName2 = typeName.substring(dotIdx + 1, typeName.length());
                if ((dotIdx = typeName2.indexOf(DOT)) != -1) {
                    String tmpStr = typeName2;
                    typeName1 = tmpStr.substring(0, dotIdx);
                    typeName2 = tmpStr.substring(dotIdx + 1, tmpStr.length());
                }
            }
            if ((resolvedType = (CompositeDatabaseType)databaseTypesRepository.getDatabaseType(typeName)) == null) {
                if (owningType.isROWTYPEType()) {
                    void var22_41;
                    ROWTYPEType rType = (ROWTYPEType)owningType;
                    String string = rType.getTypeName();
                    if (string.contains(ROWTYPE_MACRO)) {
                        int idx = string.indexOf(ROWTYPE_MACRO);
                        String string2 = string.substring(0, idx);
                    }
                    if ((resolvedType = (CompositeDatabaseType)databaseTypesRepository.getDatabaseType((String)var22_41)) == null) {
                        TableType tableType = null;
                        List<TableType> tables = this.buildTables(conn, schemaPattern, (String)var22_41, false);
                        if (tables != null && tables.size() > 0) {
                            tableType = tables.get(0);
                            databaseTypesRepository.setDatabaseType(tableType.getTableName(), tableType);
                            rType.setEnclosedType(tableType);
                            databaseTypesRepository.setDatabaseType(rType.getTypeName(), rType);
                        }
                        resolvedType = tableType;
                        if (tableType != null && !tableType.isResolved()) {
                            UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                            unresolvedTypesVisitor.visit(tableType);
                            for (UnresolvedType u2Type : unresolvedTypesVisitor.getUnresolvedTypes()) {
                                if (stac.contains(u2Type)) continue;
                                stac.push(u2Type);
                            }
                        }
                    } else {
                        uType.getOwningType().setEnclosedType(resolvedType);
                    }
                } else if (owningType.isTYPEType()) {
                    TYPEType tType = (TYPEType)owningType;
                    DatabaseType databaseType2 = DatabaseTypeBuilder.findField(typeName1, databaseType);
                    if (databaseType2 != null) {
                        void var22_44;
                        if (typeName2 != null) {
                            DatabaseType databaseType3 = DatabaseTypeBuilder.findField(typeName2, databaseType2);
                        }
                        if (var22_44 != null) {
                            tType.setEnclosedType((DatabaseType)var22_44);
                            resolvedType = (CompositeDatabaseType)var22_44;
                        }
                    }
                }
                if (resolvedType == null) {
                    int objectTypeCode = this.getObjectType(conn, schemaPattern, typeName1);
                    switch (objectTypeCode) {
                        case 1: {
                            List<FunctionType> list = this.buildFunctions(conn, schemaPattern, typeName1, false);
                            if (list == null || list.size() <= 0) break;
                            resolvedType = list.get(0);
                            break;
                        }
                        case 2: {
                            List<PLSQLPackageType> packages;
                            PLSQLPackageType plsqlPkg = null;
                            if (processedPackages != null) {
                                for (PLSQLPackageType pkg : processedPackages) {
                                    if (!pkg.getPackageName().equals(typeName1)) continue;
                                    plsqlPkg = pkg;
                                    break;
                                }
                            }
                            if (plsqlPkg == null && (packages = this.buildPackages(conn, schemaPattern, typeName1, false)) != null && packages.size() > 0) {
                                plsqlPkg = packages.get(0);
                                processedPackages.add(plsqlPkg);
                            }
                            if (plsqlPkg == null) break;
                            if (typeName2 == null) {
                                resolvedType = plsqlPkg;
                                break;
                            }
                            DatabaseType dbType = DatabaseTypeBuilder.findField(typeName2, plsqlPkg);
                            if (dbType == null || !dbType.isComposite()) break;
                            resolvedType = (CompositeDatabaseType)dbType;
                            break;
                        }
                        case 3: {
                            List<ProcedureType> procedures = this.buildProcedures(conn, schemaPattern, typeName1, false);
                            if (procedures == null || procedures.size() <= 0) break;
                            resolvedType = procedures.get(0);
                            break;
                        }
                        case 4: {
                            DatabaseType foundType;
                            List<TableType> tables = this.buildTables(conn, schemaPattern, typeName1, false);
                            if (tables == null || tables.size() <= 0) break;
                            TableType tableType = tables.get(0);
                            resolvedType = tableType;
                            if (typeName2 != null && (foundType = DatabaseTypeBuilder.findField(typeName2, resolvedType)) != null) {
                                resolvedType = (CompositeDatabaseType)foundType;
                            }
                            if (tableType.isResolved()) break;
                            UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                            unresolvedTypesVisitor.visit(tableType);
                            for (UnresolvedType u2Type : unresolvedTypesVisitor.getUnresolvedTypes()) {
                                if (stac.contains(u2Type)) continue;
                                stac.push(u2Type);
                            }
                            break;
                        }
                        case 5: {
                            DatabaseType foundType;
                            List<CompositeDatabaseType> types = this.buildTypes(conn, schemaPattern, typeName1, false);
                            if (types == null || types.size() <= 0) break;
                            resolvedType = types.get(0);
                            if (typeName2 == null || (foundType = DatabaseTypeBuilder.findField(typeName2, resolvedType)) == null) break;
                            resolvedType = (CompositeDatabaseType)foundType;
                            break;
                        }
                    }
                }
            }
            if (resolvedType != null) {
                if (owningType.isPLSQLRecordType() && !resolvedType.isFieldType()) {
                    PLSQLRecordType recordType = (PLSQLRecordType)owningType;
                    for (FieldType fieldType : recordType.getFields()) {
                        if (fieldType.isResolved() || !fieldType.getEnclosedType().getTypeName().equals(resolvedType.getTypeName())) continue;
                        fieldType.setEnclosedType(resolvedType);
                    }
                } else {
                    owningType.setEnclosedType(resolvedType);
                }
                databaseTypesRepository.setDatabaseType(resolvedType.getTypeName(), resolvedType);
                for (UnresolvedType unresolvedType : unresolvedTypes) {
                    if (!unresolvedType.getTypeName().equals(typeName) || !(unresolvedType.getOwningType().getEnclosedType() instanceof UnresolvedType)) continue;
                    unresolvedType.getOwningType().setEnclosedType(resolvedType);
                }
                if (!resolvedType.isResolved()) {
                    UnresolvedTypesVisitor unresolvedTypesVisitor = new UnresolvedTypesVisitor();
                    unresolvedTypesVisitor.visit(resolvedType);
                    for (UnresolvedType unresolvedType : unresolvedTypesVisitor.getUnresolvedTypes()) {
                        if (stac.contains(unresolvedType)) continue;
                        stac.push(unresolvedType);
                    }
                }
            }
            if (!stac.isEmpty()) continue;
            bl = true;
        }
    }

    protected int getObjectType(Connection conn, String schema, String typeName) {
        int objectType;
        block24: {
            objectType = -1;
            String schemaPattern = schema == null ? PERCENT : schema;
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                try {
                    boolean b;
                    pStmt = conn.prepareStatement(GET_OBJECT_TYPE_STMT);
                    pStmt.setString(1, schemaPattern);
                    pStmt.setString(2, typeName.toUpperCase());
                    boolean worked = pStmt.execute();
                    if (worked && (b = (rs = pStmt.getResultSet()).next())) {
                        objectType = rs.getInt(ALL_OBJECTS_OBJECT_TYPE_FIELD);
                    }
                }
                catch (SQLException sQLException) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    if (pStmt != null) {
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sQLException3) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return objectType;
    }

    public Properties getTransformProperties() throws DatabaseTypeBuilderException {
        if (TRANSFORMS_FACTORY == null) {
            throw DatabaseTypeBuilderException.noTransformsFactories();
        }
        Properties transformProperties = TRANSFORMS_FACTORY.getTransformProperties();
        if (transformProperties == null) {
            throw DatabaseTypeBuilderException.noTransformsProperties();
        }
        return transformProperties;
    }

    protected boolean setDbmsMetadataSessionTransforms(Connection conn) {
        boolean worked;
        block14: {
            if (this.transformsSet) {
                return true;
            }
            worked = true;
            Statement cStmt = null;
            try {
                try {
                    Properties transformProperties = this.getTransformProperties();
                    StringBuilder sb = new StringBuilder(BEGIN);
                    for (Map.Entry<Object, Object> me : transformProperties.entrySet()) {
                        sb.append(NEW_LINE);
                        sb.append(TRANSFORM_PREFIX);
                        sb.append(me.getKey());
                        sb.append("',");
                        sb.append(me.getValue());
                        sb.append(");");
                    }
                    sb.append(NEW_LINE);
                    sb.append(END);
                    sb.append(";");
                    cStmt = conn.prepareCall(sb.toString());
                    cStmt.execute();
                }
                catch (Exception exception) {
                    worked = false;
                    try {
                        cStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    cStmt.close();
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                cStmt.close();
            }
            catch (SQLException sQLException) {}
        }
        if (worked) {
            this.transformsSet = true;
        }
        return worked;
    }

    static boolean schemaPatternExcludesAdminSchemas(String schemaPattern) {
        return schemaPattern == null || schemaPattern.length() == 0 || TOPLEVEL.equals(schemaPattern) || PERCENT.equals(schemaPattern);
    }

    static DatabaseType findField(String fieldName, DatabaseType targetType) {
        int pctIdx = fieldName.indexOf(PERCENT);
        if (pctIdx != -1) {
            fieldName = fieldName.substring(0, pctIdx);
        }
        if (targetType.isPLSQLRecordType()) {
            PLSQLRecordType plsqlRecordType = (PLSQLRecordType)targetType;
            for (FieldType fieldType : plsqlRecordType.getFields()) {
                if (!fieldType.getFieldName().equals(fieldName)) continue;
                return fieldType;
            }
        } else if (targetType.isTableType()) {
            TableType tableType = (TableType)targetType;
            for (FieldType columnType : tableType.getColumns()) {
                if (!columnType.getFieldName().equalsIgnoreCase(fieldName)) continue;
                return columnType;
            }
        } else if (targetType.isObjectType()) {
            ObjectType objectType = (ObjectType)targetType;
            for (FieldType fieldType : objectType.getFields()) {
                if (!fieldType.getFieldName().equals(fieldName)) continue;
                return fieldType;
            }
        } else if (targetType instanceof PLSQLPackageType) {
            PLSQLPackageType packageType = (PLSQLPackageType)targetType;
            for (PLSQLCursorType cursorType : packageType.getCursors()) {
                if (!cursorType.getCursorName().equals(fieldName)) continue;
                return cursorType;
            }
            for (PLSQLType plsqlType : packageType.getTypes()) {
                if (!plsqlType.getTypeName().equals(fieldName)) continue;
                return plsqlType;
            }
            for (ProcedureType procType : packageType.getProcedures()) {
                if (!procType.getProcedureName().equals(fieldName)) continue;
                return procType;
            }
            for (FieldType fieldType : packageType.getLocalVariables()) {
                if (!fieldType.getFieldName().equals(fieldName)) continue;
                return fieldType;
            }
        } else if (targetType.isFieldType()) {
            FieldType fldType = (FieldType)targetType;
            DatabaseType eType = fldType.getEnclosedType();
            if (eType.isComposite()) {
                CompositeDatabaseType cType = (CompositeDatabaseType)eType;
                while (cType.getEnclosedType() != null) {
                    eType = cType.getEnclosedType();
                    if (!eType.isComposite()) break;
                    cType = (CompositeDatabaseType)eType;
                }
            }
            return DatabaseTypeBuilder.findField(fieldName, eType);
        }
        return null;
    }
}

