/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.mapping.tests.parser;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingPackage;
import org.eclipse.vorto.editor.mapping.MappingStandaloneSetup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MappingModelSyntaxTest {
    private static final String EXAMPLES_DIRECTORY = "resources/org/eclipse/vorto/editor/mapping/tests/parser/examples/mydevice/";

    @Before
    public void setup() {
        MappingStandaloneSetup.doSetup();
    }

    @Test
    public void parseMappingWithEntityAttribute() throws IOException {
        MappingModel mappingModel = this.createMappingModel("type/Entity_Attribute.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)3L, (long)rules.size());
    }

    @Test
    public void parseMappingWithEntityProperty() throws IOException {
        MappingModel mappingModel = this.createMappingModel("type/Entity_Property.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
    }

    @Test
    public void parseMappingWithEntityReference() throws IOException {
        MappingModel mappingModel = this.createMappingModel("type/Entity_Ref.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
    }

    @Test
    public void parseMappingWithEnumAttribute() throws IOException {
        MappingModel mappingModel = this.createMappingModel("type/Enum_Attribute.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)3L, (long)rules.size());
    }

    @Test
    public void parseMappingWithEnumProperty() throws IOException {
        MappingModel mappingModel = this.createMappingModel("type/Enum_Property.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
    }

    @Test
    public void parseMappingWithFunctionBlockAttribute() throws IOException {
        MappingModel mappingModel = this.createMappingModel("fb/FunctionBlock_Attribute.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)6L, (long)rules.size());
    }

    @Test
    public void parseMappingWithFunctionBlockProperty() throws IOException {
        MappingModel mappingModel = this.createMappingModel("fb/FunctionBlock_Property.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)6L, (long)rules.size());
    }

    @Test
    public void parseMappingWithFunctionBlockReference() throws IOException {
        MappingModel mappingModel = this.createMappingModel("fb/FunctionBlock_Ref.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
    }

    @Test
    public void parseMappingWithInfoModelAttribute() throws IOException {
        MappingModel mappingModel = this.createMappingModel("Infomodel_Attribute.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)6L, (long)rules.size());
    }

    @Test
    public void parseMappingWithInfomodelReference() throws IOException {
        MappingModel mappingModel = this.createMappingModel("Infomodel_FBRef.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
    }

    private MappingModel createMappingModel(String mappingFileName) throws IOException {
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getPackageRegistry().put((Object)"http://www.eclipse.org/vorto/metamodel/Mapping", (Object)MappingPackage.eINSTANCE);
        rset.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        String exampleSmarthomeMappingFile = EXAMPLES_DIRECTORY + mappingFileName;
        Resource resource = rset.getResource(URI.createFileURI((String)exampleSmarthomeMappingFile), true);
        resource.load(null);
        MappingModel mappingModel = (MappingModel)resource.getContents().get(0);
        return mappingModel;
    }
}

