/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.AbstractModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.parser.IModelParser;
import org.eclipse.vorto.core.ui.parser.ParseModelResult;

public class FunctionblockModelElement
extends AbstractModelElement {
    private IFile modelFile;
    private FunctionblockModel model;
    private Collection<Resource.Diagnostic> diagnostics;
    private ModelType[] possibleReferenceTypes = new ModelType[]{ModelType.Datatype, ModelType.Functionblock};
    private IModelParser modelParser;

    public FunctionblockModelElement(IModelProject modelProject, IFile modelFile, IModelParser modelParser) {
        super(modelProject);
        this.modelFile = modelFile;
        this.modelParser = modelParser;
        ParseModelResult<FunctionblockModel> parseResult = modelParser.parseModelWithError(modelFile, FunctionblockModel.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }

    @Override
    public IFile getModelFile() {
        return this.modelFile;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Collection<Resource.Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    protected String getImageURLAsString() {
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/fb.png";
    }

    @Override
    protected String getErrorImageURLAsString() {
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/fb-error.png";
    }

    @Override
    protected ModelType[] getPossibleReferenceTypes() {
        return this.possibleReferenceTypes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.modelFile == null ? 0 : this.modelFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionblockModelElement other = (FunctionblockModelElement)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.modelFile == null ? other.modelFile != null : !this.modelFile.equals((Object)other.modelFile));
    }

    @Override
    public void reload() {
        ParseModelResult<FunctionblockModel> parseResult = this.modelParser.parseModelWithError(this.modelFile, FunctionblockModel.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }
}

