/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.wizard;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vorto.codegen.ui.context.IGeneratorProjectContext;

public class GeneratorWizardPage
extends WizardPage
implements IGeneratorProjectContext {
    private static final String DEFAULT_PACKAGE_NAME = "org.eclipse.vorto.example";
    private static final String SELECT_DIRECTORY = "Select a directory for this project";
    private static final String WORKSPACE_FOLDER_SELECTION = "Workspace folder selection";
    public static final String PROJECTNAME_REGEX = "[^a-zA-Z0-9 \\._]";
    public static final String DEFAULT_PROJECT_NAME = "MyGenerator";
    private static final boolean MICRO_SERVICE_SUPPORT_DEFAULT = true;
    private Text txtProjectName;
    private Text txtWorkspaceLocation;
    private Text txtPackageName;
    private String workspaceLocation;
    private boolean isMicroServiceSelected;

    public GeneratorWizardPage(String pageName) {
        super(pageName);
        this.setTitle("New Code Generator Project");
        this.setMessage("Create a new Code Generator Project");
    }

    public void createControl(Composite parent) {
        Composite topContainer = new Composite(parent, 0);
        this.setControl((Control)topContainer);
        topContainer.setLayout((Layout)new GridLayout(1, false));
        Group grpGeneratorProject = new Group(topContainer, 0);
        grpGeneratorProject.setText("ProjectDetails");
        grpGeneratorProject.setLayout((Layout)new GridLayout(3, false));
        GridData gridGroupGeneratorProject = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridGroupGeneratorProject.heightHint = 163;
        gridGroupGeneratorProject.widthHint = 570;
        grpGeneratorProject.setLayoutData((Object)gridGroupGeneratorProject);
        Label lblProjectName = new Label((Composite)grpGeneratorProject, 0);
        lblProjectName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProjectName.setText("Project Name:");
        this.txtProjectName = new Text((Composite)grpGeneratorProject, 2048);
        GridData gridTxtProjectName = new GridData(4, 0x1000000, false, false, 1, 1);
        gridTxtProjectName.widthHint = 304;
        this.txtProjectName.setLayoutData((Object)gridTxtProjectName);
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorWizardPage.this.projectNameChanged();
                try {
                    GeneratorWizardPage.this.dialogChanged();
                }
                catch (IOException iOException) {
                    throw new RuntimeException();
                }
            }
        });
        new Label((Composite)grpGeneratorProject, 0);
        Label lblPackageName = new Label((Composite)grpGeneratorProject, 0);
        lblPackageName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPackageName.setText("Package Name:");
        this.txtPackageName = new Text((Composite)grpGeneratorProject, 2048);
        GridData gd_txtDemo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtDemo.widthHint = 79;
        this.txtPackageName.setLayoutData((Object)gd_txtDemo);
        new Label((Composite)grpGeneratorProject, 0);
        Label lblVersion = new Label((Composite)grpGeneratorProject, 0);
        lblVersion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVersion.setText("Location:");
        this.txtWorkspaceLocation = new Text((Composite)grpGeneratorProject, 2048);
        GridData gd_txtWorkspaceLocation = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtWorkspaceLocation.widthHint = 403;
        this.txtWorkspaceLocation.setLayoutData((Object)gd_txtWorkspaceLocation);
        this.txtWorkspaceLocation.setEditable(false);
        Button btnBrowse = new Button((Composite)grpGeneratorProject, 0);
        btnBrowse.setText("Browse...");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GeneratorWizardPage.this.handleBrowse(e);
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        });
        new Label((Composite)grpGeneratorProject, 0);
        Button btnCreateMicroService = new Button((Composite)grpGeneratorProject, 32);
        btnCreateMicroService.setToolTipText("This option adds support for running the generator as a server-side micro-service.");
        btnCreateMicroService.setSelection(true);
        btnCreateMicroService.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorWizardPage.this.isMicroServiceSelected = !GeneratorWizardPage.this.isMicroServiceSelected;
            }
        });
        btnCreateMicroService.setText(" Server-side Generation Support");
        new Label((Composite)grpGeneratorProject, 0);
        this.initialize();
        try {
            this.dialogChanged();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        this.setControl((Control)topContainer);
    }

    private void initialize() {
        this.txtProjectName.setText(DEFAULT_PROJECT_NAME);
        this.txtWorkspaceLocation.setText(String.valueOf(this.getWorkspaceLocation()) + "/" + DEFAULT_PROJECT_NAME);
        this.txtPackageName.setText(DEFAULT_PACKAGE_NAME);
        this.isMicroServiceSelected = true;
    }

    private void handleBrowse(SelectionEvent e) throws IOException {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setFilterPath(this.workspaceLocation);
        directoryDialog.setText(WORKSPACE_FOLDER_SELECTION);
        directoryDialog.setMessage(SELECT_DIRECTORY);
        String selectedDirectory = directoryDialog.open();
        this.setDirectoryToWorkspaceField(selectedDirectory);
    }

    private void setDirectoryToWorkspaceField(String selectedDirectory) throws IOException {
        String _selectedDirectory = StringUtils.replace((String)selectedDirectory, (String)"\\", (String)"/");
        if (_selectedDirectory != null) {
            this.workspaceLocation = _selectedDirectory;
            this.updateWorkspaceLocationField(this.workspaceLocation);
            this.dialogChanged();
        }
    }

    public void dialogChanged() throws IOException {
        if (this.validateProject()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean validateProject() throws IOException {
        boolean result = true;
        String projectName = this.getProjectName();
        result &= this.validateStrExist(projectName, "Project name must be specified");
        result &= this.validateExistingSameProjectName();
        if (this.checkForRegexPattern(projectName, true, PROJECTNAME_REGEX)) {
            this.setErrorMessage("Project name should not contain special characters.");
            result = false;
        }
        return result;
    }

    private boolean checkForRegexPattern(String input, boolean expectedBool, String regexPattern) {
        return Pattern.compile(regexPattern).matcher(input).find() == expectedBool;
    }

    private boolean validateStrExist(String string, String errorMsgToBeShown) {
        if (Strings.isNullOrEmpty((String)string)) {
            this.setErrorMessage(errorMsgToBeShown);
            return false;
        }
        return true;
    }

    private boolean validateExistingSameProjectName() throws IOException {
        String canonicalPath;
        String existingName;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = this.getProjectName();
        if (workspace.getRoot().getProject(this.getProjectName()).exists()) {
            this.setErrorMessage("Project " + this.getProjectName() + " already exists.");
            return false;
        }
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(projectName);
        if (projectLocation.toFile().exists() && !(existingName = (projectLocation = new Path(canonicalPath = projectLocation.toFile().getCanonicalPath())).lastSegment()).equals(projectName)) {
            this.setErrorMessage("Project " + this.getProjectName() + " already exists.");
            return false;
        }
        return true;
    }

    public void updateWorkspaceLocationField(String directory) {
        this.txtWorkspaceLocation.setText(String.valueOf(directory) + "/" + this.getProjectName());
    }

    private void projectNameChanged() {
        String projectName = this.getProjectName();
        this.txtWorkspaceLocation.setText(String.valueOf(this.getWorkspaceLocation()) + "/" + projectName);
    }

    @Override
    public String getWorkspaceLocation() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.workspaceLocation == null) {
            this.workspaceLocation = workspace.getRoot().getLocation().toString();
        }
        return this.workspaceLocation;
    }

    @Override
    public String getGeneratorName() {
        return this.txtProjectName.getText();
    }

    @Override
    public String getProjectName() {
        return this.txtProjectName.getText();
    }

    @Override
    public String getPackageName() {
        return this.txtPackageName.getText();
    }

    @Override
    public String getPackageFolders() {
        return this.getPackageName().replaceAll("\\.", "/");
    }

    @Override
    public boolean isMicroServiceSupport() {
        return this.isMicroServiceSelected;
    }
}

