/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.tasks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.context.IGeneratorProjectContext;
import org.eclipse.vorto.codegen.ui.tasks.ConfigurationContainer;
import org.eclipse.vorto.codegen.ui.tasks.CopyResourceTask;
import org.eclipse.vorto.codegen.ui.tasks.FolderModule;
import org.eclipse.vorto.codegen.ui.tasks.IEclipseProjectConfiguration;
import org.eclipse.vorto.codegen.ui.tasks.LocationWrapper;
import org.eclipse.vorto.codegen.ui.tasks.NatureConfiguration;
import org.eclipse.vorto.codegen.ui.tasks.ProjectFileOutputter;

public class EclipseProjectGenerator<Context> {
    public static final String SKIP_PROJECT_CONFIGURATION = "skip.project.cfg";
    private ConfigurationContainer configuration;
    private List<ICodeGeneratorTask<Context>> tasks = new ArrayList<ICodeGeneratorTask<Context>>();
    private NatureConfiguration natureConfiguration = new NatureConfiguration();
    private IProject project;
    private LocationWrapper locationW;

    @SafeVarargs
    public EclipseProjectGenerator(LocationWrapper location, ConfigurationContainer configuration, ICodeGeneratorTask<Context> ... tasks) {
        this.locationW = location;
        this.configuration = configuration;
        this.addConfiguration(this.natureConfiguration);
        this.tasks.addAll(Arrays.asList(tasks));
    }

    @SafeVarargs
    public EclipseProjectGenerator(String projectName, ConfigurationContainer configuration, ICodeGeneratorTask<Context> ... tasks) {
        String rootWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        this.locationW = new LocationWrapper(rootWorkspace, projectName);
        this.configuration = configuration;
        this.addConfiguration(this.natureConfiguration);
        this.tasks.addAll(Arrays.asList(tasks));
    }

    public EclipseProjectGenerator(LocationWrapper location) {
        this.locationW = location;
        this.configuration = new ConfigurationContainer(new IEclipseProjectConfiguration[0]);
        this.addConfiguration(this.natureConfiguration);
    }

    public EclipseProjectGenerator(String projectName) {
        String rootWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        this.locationW = new LocationWrapper(rootWorkspace, projectName);
        this.configuration = new ConfigurationContainer(new IEclipseProjectConfiguration[0]);
        this.addConfiguration(this.natureConfiguration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(Context context, InvocationContext invocationContext, IProgressMonitor monitor) {
        block11: {
            this.project = this.getWorkspace().getProject(this.locationW.getProjectName());
            this.tasks.addAll(this.configuration.getGeneratorTasks());
            if (!this.project.exists()) {
                try {
                    this.project = this.createProjectInWorkspace(monitor);
                    this.project.open(monitor);
                    Iterator<ICodeGeneratorTask<Context>> iterator = this.tasks.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (!Boolean.valueOf((String)invocationContext.getConfigurationProperties().get(SKIP_PROJECT_CONFIGURATION)).booleanValue()) {
                                this.configuration.configure(this.project);
                            }
                            break block11;
                        }
                        ICodeGeneratorTask<Context> task = iterator.next();
                        task.generate(context, invocationContext, (IGeneratedWriter)new ProjectFileOutputter(this.project));
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            for (ICodeGeneratorTask<Context> task : this.tasks) {
                task.generate(context, invocationContext, (IGeneratedWriter)new ProjectFileOutputter(this.project));
            }
        }
        try {
            this.project.refreshLocal(1, monitor);
        }
        catch (CoreException e1) {
            throw new RuntimeException(e1);
        }
        if (this.project.isOpen()) return;
        try {
            this.project.open(monitor);
            return;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private IProject createProjectInWorkspace(IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription desc = workspace.newProjectDescription(this.locationW.getProjectName());
        desc.setLocation((IPath)this.locationW.getValidPath());
        if (!this.isDefaultWorkLocation(workspace)) {
            this.project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            this.project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return this.project;
    }

    private boolean isDefaultWorkLocation(IWorkspace workspace) {
        String defaultWorkspace = workspace.getRoot().getLocation().toString();
        return StringUtils.equals((CharSequence)defaultWorkspace, (CharSequence)this.locationW.getPath());
    }

    public IProject getProject() {
        return this.project;
    }

    private IWorkspaceRoot getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public EclipseProjectGenerator<Context> addFolder(String folder) {
        this.tasks.add(new FolderModule(folder));
        return this;
    }

    public EclipseProjectGenerator<Context> addNature(String nature) {
        this.natureConfiguration.addNature(nature);
        return this;
    }

    public EclipseProjectGenerator<Context> mavenNature(ITemplate<Context> pomFileTemplate, String ... srcFolders) {
        this.natureConfiguration.addMavenNature(pomFileTemplate, srcFolders);
        return this;
    }

    public EclipseProjectGenerator<Context> javaNature(String ... srcFolders) {
        this.natureConfiguration.addJavaNature(srcFolders);
        return this;
    }

    public EclipseProjectGenerator<Context> addConfiguration(IEclipseProjectConfiguration configuration) {
        this.configuration.addConfiguration(configuration);
        return this;
    }

    public EclipseProjectGenerator<Context> addTask(ICodeGeneratorTask<Context> task) {
        this.tasks.add(task);
        return this;
    }

    public EclipseProjectGenerator<Context> addTask(IFileTemplate<Context> template) {
        this.tasks.add((ICodeGeneratorTask<Context>)new GeneratorTaskFromFileTemplate(template));
        return this;
    }

    public EclipseProjectGenerator<Context> pluginNature(ITemplate<Context> buildFileModule, ITemplate<Context> manifestFileModule, String ... srcFolders) {
        this.natureConfiguration.addPluginNature(buildFileModule, manifestFileModule, srcFolders);
        return this;
    }

    public EclipseProjectGenerator<Context> pluginNature(String outputLocation, ITemplate<IGeneratorProjectContext> buildFileModule, ITemplate<IGeneratorProjectContext> manifestFileModule, String ... srcFolders) {
        this.natureConfiguration.addPluginNature(outputLocation, buildFileModule, manifestFileModule, srcFolders);
        return this;
    }

    public EclipseProjectGenerator<Context> copy(URL resource, String targetFolder, String fileSuffix) {
        this.tasks.add(new CopyResourceTask(resource, targetFolder));
        return this;
    }

    public EclipseProjectGenerator<Context> copy(URL resource, String targetFolder) {
        this.tasks.add(new CopyResourceTask(resource, targetFolder));
        return this;
    }
}

