/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.progresstask;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vorto.codegen.ui.progresstask.IProgressTask;

public class ProgressTaskExecutionService {
    private static ProgressTaskExecutionService service;

    public static ProgressTaskExecutionService getProgressTaskExecutionService() {
        if (service == null) {
            service = new ProgressTaskExecutionService();
        }
        return service;
    }

    public void syncRun(final IProgressTask task) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                try {
                    progressDialog.run(false, true, (IRunnableWithProgress)task);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)shell, (String)task.getErrorMessage(), (String)ProgressTaskExecutionService.this.getExceptionMsg(ex, "Error creating project"));
                }
            }
        });
    }

    private String getExceptionMsg(Exception e, String defaultMsg) {
        String errorMsg = "";
        if (!StringUtils.isEmpty((CharSequence)e.getMessage())) {
            errorMsg = e.getMessage();
        } else if (e.getCause() != null && !StringUtils.isEmpty((CharSequence)e.getCause().getMessage())) {
            errorMsg = e.getCause().getMessage();
        }
        return errorMsg;
    }
}

