/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.sorted.immutable;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap;
import org.eclipse.collections.api.partition.bag.sorted.PartitionImmutableSortedBag;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.immutable.AbstractImmutableBagIterable;
import org.eclipse.collections.impl.bag.sorted.immutable.ImmutableSortedBagSerializationProxy;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.bag.sorted.mutable.TreeBagMultimap;
import org.eclipse.collections.impl.partition.bag.sorted.PartitionTreeBag;
import org.eclipse.collections.impl.tuple.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
abstract class AbstractImmutableSortedBag<T>
extends AbstractImmutableBagIterable<T>
implements ImmutableSortedBag<T> {
    AbstractImmutableSortedBag() {
    }

    public ImmutableSortedBag<T> newWithoutAll(Iterable<? extends T> elements) {
        return this.reject((Predicate<? super T>)Predicates.in(elements));
    }

    public ImmutableSortedBag<T> toImmutable() {
        return this;
    }

    public ImmutableSortedBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    protected Object writeReplace() {
        return new ImmutableSortedBagSerializationProxy(this);
    }

    public <V> ImmutableSortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    public <V> ImmutableSortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, TreeBagMultimap.newMultimap(this.comparator())).toImmutable();
    }

    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap()).toImmutable();
    }

    public ImmutableSortedBag<T> select(Predicate<? super T> predicate) {
        return this.select(predicate, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public <P> ImmutableSortedBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public ImmutableSortedBag<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public <P> ImmutableSortedBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, TreeBag.newBag(this.comparator())).toImmutable();
    }

    public PartitionImmutableSortedBag<T> partition(final Predicate<? super T> predicate) {
        final PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                MutableSortedBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result.toImmutable();
    }

    public <P> PartitionImmutableSortedBag<T> partitionWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        final PartitionTreeBag result = new PartitionTreeBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                MutableSortedBag bucket = predicate.accept(each, parameter) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result.toImmutable();
    }

    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, FastList.newList()).toImmutable();
    }

    public <P, V> ImmutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, FastList.newList()).toImmutable();
    }

    public <V> ImmutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, FastList.newList()).toImmutable();
    }

    public ImmutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanArrayList(this.size())).toImmutable();
    }

    public ImmutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteArrayList(this.size())).toImmutable();
    }

    public ImmutableCharList collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharArrayList(this.size())).toImmutable();
    }

    public ImmutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleArrayList(this.size())).toImmutable();
    }

    public ImmutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatArrayList(this.size())).toImmutable();
    }

    public ImmutableIntList collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntArrayList(this.size())).toImmutable();
    }

    public ImmutableLongList collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongArrayList(this.size())).toImmutable();
    }

    public ImmutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortArrayList(this.size())).toImmutable();
    }

    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, FastList.newList()).toImmutable();
    }

    public ImmutableSortedBag<T> selectByOccurrences(final IntPredicate predicate) {
        final TreeBag result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(occurrences)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    public <S> ImmutableSortedBag<S> selectInstancesOf(final Class<S> clazz) {
        Comparator comparator = this.comparator();
        final TreeBag result = TreeBag.newBag(comparator);
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (clazz.isInstance(each)) {
                    result.addOccurrences(clazz.cast(each), occurrences);
                }
            }
        });
        return result.toImmutable();
    }

    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> that) {
        final FastList list = FastList.newList();
        final Iterator<S> iterator = that.iterator();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int parameter) {
                for (int i = 0; i < parameter; ++i) {
                    if (!iterator.hasNext()) continue;
                    list.add(Tuples.pair(each, iterator.next()));
                }
            }
        });
        return list.toImmutable();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, final R target) {
        final Iterator<S> iterator = that.iterator();
        if (target instanceof MutableBag) {
            final MutableBag targetBag = (MutableBag)target;
            this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

                public void value(T each, int occurrences) {
                    if (iterator.hasNext()) {
                        targetBag.addOccurrences(Tuples.pair(each, iterator.next()), occurrences);
                    }
                }
            });
        } else {
            this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

                public void value(T each, int occurrences) {
                    for (int i = 0; i < occurrences; ++i) {
                        if (!iterator.hasNext()) continue;
                        target.add(Tuples.pair(each, iterator.next()));
                    }
                }
            });
        }
        return target;
    }

    /*
     * Exception decompiling
     */
    public ImmutableSortedSet<Pair<T, Integer>> zipWithIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.applyExpressionRewriter(NewAnonymousArray.java:112)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ImmutableList<ObjectIntPair<T>> topOccurrences(int n) {
        return this.occurrencesSortingBy(n, new IntFunction<ObjectIntPair<T>>(){

            public int intValueOf(ObjectIntPair<T> item) {
                return -item.getTwo();
            }
        }).toImmutable();
    }

    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int n) {
        return this.occurrencesSortingBy(n, new IntFunction<ObjectIntPair<T>>(){

            public int intValueOf(ObjectIntPair<T> item) {
                return item.getTwo();
            }
        }).toImmutable();
    }

    private MutableList<ObjectIntPair<T>> occurrencesSortingBy(int n, IntFunction<ObjectIntPair<T>> function) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return Lists.fixedSize.empty();
        }
        MutableList sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((ObjectIntPair)results.getLast()).getTwo() == ((ObjectIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    public MutableStack<T> toStack() {
        return Stacks.mutable.withAll((Iterable)this);
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        Object[] objects = this.toArray();
        TreeBag batch = TreeBag.newBag(this.comparator());
        int j = 0;
        while (j < objects.length) {
            for (int i = 0; i < size && j < objects.length; ++j, ++i) {
                batch.add(objects[j]);
            }
            result.add((Object)batch.toImmutable());
        }
        return result.toImmutable();
    }

    public ImmutableSortedBag<T> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    public int detectLastIndex(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    public void reverseForEach(Procedure<? super T> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reverseForEach() not implemented yet");
    }

    public LazyIterable<T> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }
}

