/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;

public class TextEditorPropertyAction
extends Action
implements IPropertyChangeListener {
    private final MergeSourceViewer[] viewers;
    private final String preferenceKey;
    private final IPreferenceStore store;

    public TextEditorPropertyAction(String label, MergeSourceViewer[] viewers, String preferenceKey) {
        super(label, 2);
        this.viewers = viewers;
        this.preferenceKey = preferenceKey;
        this.store = EditorsUI.getPreferenceStore();
        if (this.store != null) {
            this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.synchronizeWithPreference();
        this.addActionToViewers();
    }

    private void addActionToViewers() {
        MergeSourceViewer[] mergeSourceViewerArray = this.viewers;
        int n = this.viewers.length;
        int n2 = 0;
        while (n2 < n) {
            MergeSourceViewer viewer = mergeSourceViewerArray[n2];
            viewer.addTextAction((IAction)this);
            ++n2;
        }
    }

    public MergeSourceViewer[] getViewers() {
        return this.viewers;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.getPreferenceKey())) {
            this.synchronizeWithPreference();
        }
    }

    protected void synchronizeWithPreference() {
        boolean checked = false;
        if (this.store != null) {
            checked = this.store.getBoolean(this.getPreferenceKey());
        }
        if (checked != this.isChecked() && this.toggleState(checked)) {
            this.setChecked(checked);
        }
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void run() {
        this.toggleState(this.isChecked());
        if (this.store != null) {
            this.store.setValue(this.getPreferenceKey(), this.isChecked());
        }
    }

    public void dispose() {
        if (this.store != null) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected boolean toggleState(boolean checked) {
        return false;
    }
}

