/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class VirtualTableQueryFilter {
    private final List<Long> fDesiredColumns;
    private final long fDesiredIndex;
    private final int fDesiredCount;

    public VirtualTableQueryFilter(List<Long> desiredColumns, long index, int count) {
        if (index < 0L) {
            throw new IllegalArgumentException("Index must be positive");
        }
        this.fDesiredColumns = ImmutableList.copyOf(desiredColumns);
        this.fDesiredIndex = index;
        this.fDesiredCount = count;
    }

    public List<Long> getColumnsId() {
        return this.fDesiredColumns;
    }

    public int getCount() {
        return this.fDesiredCount;
    }

    public long getIndex() {
        return this.fDesiredIndex;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        VirtualTableQueryFilter other = (VirtualTableQueryFilter)obj;
        return this.fDesiredColumns.equals(other.getColumnsId()) && this.fDesiredIndex == other.getIndex() && this.fDesiredCount == other.getCount();
    }

    public int hashCode() {
        return Objects.hash(this.fDesiredColumns, this.fDesiredIndex, this.fDesiredCount);
    }
}

