/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public interface RandomVectorScorerSupplier {
    public RandomVectorScorer scorer(int var1) throws IOException;

    public static RandomVectorScorerSupplier createFloats(RandomAccessVectorValues<float[]> vectors, VectorSimilarityFunction similarityFunction) throws IOException {
        RandomAccessVectorValues<float[]> vectorsCopy = vectors.copy();
        return queryOrd -> cand -> similarityFunction.compare((float[])vectors.vectorValue(queryOrd), (float[])vectorsCopy.vectorValue(cand));
    }

    public static RandomVectorScorerSupplier createBytes(RandomAccessVectorValues<byte[]> vectors, VectorSimilarityFunction similarityFunction) throws IOException {
        RandomAccessVectorValues<byte[]> vectorsCopy = vectors.copy();
        return queryOrd -> cand -> similarityFunction.compare((byte[])vectors.vectorValue(queryOrd), (byte[])vectorsCopy.vectorValue(cand));
    }
}

